%include "icedump.inc"

; ------------------------------------------------------------------------------
; this is the new PAGEIN parser that accepts the following syntax:

;             PAGEIN <address> [<length> <file name>]

; if only <address> is specified then the old PAGEIN will be emulated (but this
; time it will work in V86 and 16 bit ring-3 modes as well). on syntax error
; nothing is done.
; ------------------------------------------------------------------------------

	BITS 32

%if WINICE_VERSION = 0x322
	ORG 0x7D777
%elif WINICE_VERSION= 0x323
	ORG 0x7E55E
%else
	ORG NotSupportedVersion
%endif


; ------------------------------------------------------------------------------
; on entry ESI points to the full command line (e.g. "PAGEIN 0 FFFFF c:\dump").
; during parsing ESI will skip from token to token.
; ------------------------------------------------------------------------------
parser
	pushad
	call	pSaveRegs		; save the client registers
	mov	ebp,WINICE_BASE		; reloc: offset 0
	call    pSkipWord		; skip over "PAGEIN"
	jb	.error
	call	pExp2Int		; parse <address>
	jb	.error
	mov	[ebp+dClient_EDI],eax	; store start address of block
	call	pSkipWhiteSpace		; skip to <length>
	jz	.emulate		; let's emulate the old behaviour
	call	pExp2Int		; parse <length>
	jb	.error
	call	pSkipWhiteSpace		; skip to <file name>
	jnz	.cont
.error
	call	pRestoreRegs		; restore the client registers
	popad
	retn

.emulate
	xor	eax,eax			; zero length, old PAGEIN is emulated
	xor	esi,esi			; no filename, old PAGEIN is emulated

.cont
	mov	[ebp+dClient_ECX],eax	; store length of block
	mov	[ebp+dClient_ESI],esi	; store pointer to file name

	mov	eax,oINT3-WINICE_DELTA
	mov	ecx,V86CB_OFF		; these two mov's will be modified
	mov	ebx,V86CB_SEG		; runtime while initializing
	test	byte [ebp+dClient_EFLAGS+2],2	; is client in V86 mode?
	jz	.PM
	test	ebx,ebx			; is callback valid?
	jnz	.setCSEIP
.testEIP
	jecxz	.error

;----- -------------------------------------------------------------------------
; by directly modifying the client CS:(E)IP we will have the client resume
; execution at one of the callbacks allocated during initialization or at the
; ring-0 entry point of the dumper. once the dumper code is executed, we will
; have the client return to a special INT3. it's special 'cos Winice will treat
; it differently (that's why we have to store its address in a special Winice
; internal variable). V86 mode handling is a bit more complicated, so the
; corresponding INT3 will be taken care of in the dumper code.

; see also the various entry points in the dumper as well.
; ------------------------------------------------------------------------------
.setCSEIP
	mov	[ebp+dClient_CS],ebx	; set client CS
.setEIP
	mov	[ebp+dClient_EIP],ecx	; set client (E)IP

	mov	[ebp+oPAGEIN_INT3],eax	; set address of final INT3

;        mov     eax,1
	xor     eax,eax			; wow, saves 1 byte ;-)
	mov     al,1

; ------------------------------------------------------------------------------
; these two flags will make Winice resume execution of the client and wait for
; the final INT3 that will transfer control back to Winice.
; ------------------------------------------------------------------------------
        mov     [ebp+fDoingPAGEIN],eax  ; set internal Winice flag to 1
        mov     [ebp+fExecMoreCmds],ah  ; set internal Winice flag to 0

	popad
	retn

.PM
	mov	ecx,PMCB_OFF		; these two mov's will be modified
	mov	ebx,PMCB_SEG		; runtime while initializing
	test	byte [ebp+dClient_CS],3	; is client in ring-0?
	jnz	.testEIP		; is callback valid?

	lea	ecx,[ebp+PAGEIN_R0]
	lea	eax,[ebp+oINT3]
	jmp	short .setEIP
