
#include <stdio.h>

#define MAX_BUFFER 4096  /* how much to hold at a time */
#define MAX_PATTERN 1024 /* how much space until end of buffer before */
                         /* we shift the buffer and do some more IO */


/* I only want alphanumeric, @ and . */
int iValidValue(char cChar)
{
        if (cChar >= 'a' && cChar <= 'z') return 1;
        if (cChar >= 'A' && cChar <= 'Z') return 1;
        if (cChar >= '0' && cChar <= '9') return 1;
        if (cChar == '@') return 1;
        if (cChar == '.') return 1;
        if (cChar == ' ') return 1;
        return 0;
}

/* Parses the buffer szBuffer for the string szToken. If found, it takes the
   next set of valid characters and puts them into szReturn. Always returns
   the effective offset after pulling a pattern. */

char *pzParseBuffer(char *szBuffer, char *szToken, char *szReturn)
{
        char *pzStart, *pzCurBuf, *pzCurTok, *pzReturn;
        int iFound;

        pzStart = szBuffer;
        pzCurBuf = szBuffer;
        pzCurTok = szToken;
        pzReturn = szReturn;
        iFound = 0;
        while (*pzCurBuf++ == *pzCurTok++)
           if (*pzCurTok == '\0') iFound = 1;
        if (*pzCurTok == '\0') iFound = 1;
        if (iFound != 1) {
           *pzReturn = '\0';
           return pzStart;
        }
        pzCurBuf--;
        while (iValidValue(*pzCurBuf))
                *pzReturn++ = *pzCurBuf++;
        *pzReturn = '\0';
        return pzCurBuf;
}

/* Processes a buffer. Looks at current position for matches to the various
   tokens. If found, advances the pointer and continues. If not found, then
   it increments the current position by 1 and searches again. If it hits
   the boundary of MAX_PATTERN from MAX_BUFFER, it shifts the buffer and
   requests more IO. Always returns either 0 or the offset after the shift.
*/ 

int ProcessBuffer(char *szBuffer, int iBufTop)
{
        char *pzBufPos, *pzSavPos, *pzCpyPos;
        char *szName = "Name\0", *szMail = "Mail\0", *szAddr = "Address";
        char *szURL = "http://\0";
        char szString[256];

        int  iIdx, iShift, iSize;
        iShift = MAX_BUFFER - MAX_PATTERN;

        pzBufPos = szBuffer;
        iIdx = 0;

        while (iIdx < iBufTop)
        {
                if (iIdx >= iShift)
                {
                        iSize = 0;
                        pzCpyPos = szBuffer;
                        while (iIdx < iBufTop)
                        {
                                *pzCpyPos++ = *pzBufPos++;
                                iIdx++;
                                iSize++;
                        }
                        return iSize;
                }
                pzSavPos = pzBufPos;
                pzBufPos = pzParseBuffer(pzBufPos, szName, szString);
                if (szString[0] != '\0') {
                        printf("Name: %s\n",szString);
                        iIdx += (int)(pzBufPos-pzSavPos);
                        continue;
                }
                pzBufPos = pzSavPos;
                pzBufPos = pzParseBuffer(pzBufPos, szMail, szString);
                if (szString[0] != '\0') {
                        printf("Mail: %s\n",szString);
                        iIdx += (int)(pzBufPos-pzSavPos);
                        continue;
                }
                pzBufPos = pzSavPos;
                pzBufPos = pzParseBuffer(pzBufPos, szAddr, szString);
                if (szString[0] != '\0') {
                        printf("Address: %s\n",szString);
                        iIdx += (int)(pzBufPos-pzSavPos);
                        continue;
                }
                pzBufPos = pzSavPos;
                pzBufPos = pzParseBuffer(pzBufPos, szURL, szString);
                if (szString[0] != '\0') {
                        printf("URL: %s\n",szString);
                        iIdx += (int)(pzBufPos-pzSavPos);
                        continue;
                }
                pzBufPos = ++pzSavPos;
                iIdx++;
      }
      return 0;
}

/* Processes a file. Basically, load to buffer from current position to end,
   then call the buffer processing routine. Keep filling until EOF. */

void ProcessFile(FILE *fFile)
{
        char szBuffer[MAX_BUFFER];
        int  iBufPos, iBufEnd, iInChar;

        iBufPos = 0;

        while ((iInChar = fgetc(fFile)) != EOF)
        {
                szBuffer[iBufPos++] = (char)iInChar;
                if (iBufPos == MAX_BUFFER-1)
                        iBufPos = ProcessBuffer(szBuffer,iBufPos);
        }

        if (iBufPos > 0)
                iBufEnd = ProcessBuffer(szBuffer,iBufPos);
        return;
}

void main(int argc, char **argv)
{
        FILE *fUser;

        /* Ugly, nasty hack, but, hey, it's a simple tool. */

        if (argc > 1 && argv[1][0] == '-' && argv[1][1] == 's')
          {if (!(fUser = fopen("\\windows\\system.dat","rb"))) abort();}
        else
          if (!(fUser = fopen("\\windows\\user.dat","rb"))) abort();

        /* Process whatever */
        ProcessFile(fUser);

        /* Bye! */
        return;
}
