
/*
 ***************************************************************************
 *                                                                         *
 *   EXEC-2-C.H - include file for sources restored by EXEX-2-C utility.   *
 *   Copyright (c) The Austin Code Works & Polyglot International,         *
 *				Jerusalem, 1991                            *
 *                                                                         *
 ***************************************************************************
 */



#define		UP	1
#define		DOWN	0


typedef         unsigned int    Word;
typedef         unsigned char   Byte;
typedef		unsigned long   Dword;
typedef         int          	(*FNC)();	/* pointer to function type */

/*
 *  Used to split the Dword to higher && lower part
 */
#define		HIGH_WRD(w)             (*((Word*)&(w) + 1))
#define		LWR_WRD(w)		((Word)(w))

/*
 * Higher && lower bits of Word or Byte
 */

typedef struct {
		/*--- first byte ---*/
		Word	lwr_bit	: 1;
		Word    dummy1  : 6;
		Word	byte_hgh_bit : 1;
		/*--- second byte ---*/
		Word    dummy2  : 7;
		Word    word_hgh_bit : 1;
					} Bits_t;

#define		Lwr_bit(a)		((Bits_t)(a).lwr_bit)
#define		High_bit(a)		(sizeof(a) == sizeof(Word) ? 	   \
						((Bits_t)(a).word_hgh_bit):\
						((Bits_t)(a).byte_hgh_bit))


/*---------------------------------------------------------------------------*\
 |  		REGISTER SIMULATION					     |
\*---------------------------------------------------------------------------*/

#ifdef  notdef

struct WORDREGS {
        unsigned int    _ax_, _bx_, _cx_, _dx_, _si_, _di_, _bp_, _sp_,
                        _cs_, _ss_, _ds_, _es_, _cflag_, _flags_;
};

struct BYTEREGS {
        unsigned char   _al_, _ah_, _bl_, _bh_, _cl_, _ch_, _dl_, _dh_;
};

typedef union   Regs    {
        struct  WORDREGS x;
        struct  BYTEREGS h;
                        }       REGS;

#define         ax      reg.x._ax_
#define         bx      ((Byte*)reg.x._bx_)
#define         cx      reg.x._cx_
#define         dx      reg.x._dx_

#define 	si      ((Byte*)reg.x._si_)
#define 	di	((Byte*)reg.x._di_)

#define         ah      reg.h._ah_
#define         al      reg.h._al_
#define         bh      reg.h._bh_
#define         bl      reg.h._bl_
#define         ch      reg.h._ch_
#define         cl      reg.h._cl_
#define         dh      reg.h._dh_
#define         dl      reg.h._dl_

#define         cs      reg.x._cs_
#define         es      reg.x._es_
#define         ds      reg.x._ds_
#define         ss      reg.x._ss_

#define         bp      ((Byte*)reg.x._bp_)
#define         sp      reg.x._sp_
#else

#define		HIGH_BYTE(w)		(*((Byte*)&(w)+1))
#define		LWR_BYTE(w)		((Byte)(w))


Word	ax, cx, dx, cs, ss, ds, es;
Byte  	*bx, *si, *di, *bp, *sp;

#define		ah	HIGH_BYTE( ax )
#define		al	LWR_BYTE(  ax )
#define		bh	HIGH_BYTE( bx )
#define		bl	LWR_BYTE(  bx )
#define		ch	HIGH_BYTE( cx )
#define		cl	LWR_BYTE(  cx )
#define		dh	HIGH_BYTE( dx )
#define		dl	LWR_BYTE(  dx )

#endif

extern Byte *MK_FP();

/*---------------------------------------------------------------------------*\
 |  		Declaration of the internal variables 			     |
\*---------------------------------------------------------------------------*/

#ifdef notdef
/*
 * register simulation variable
 */
REGS  		reg;
#endif

/*
 * temporary var used for MULT ant DIV group
 */
Dword		long_mul;

/*
 * temporary vars used for string operations
 */
char far *src;
char far *dst;

/*
 * general use temporary vars
 */
Word i;

