.386P
Locals
jumps

.Model Flat ,StdCall

include PE.inc
include Useful.inc
include MZ.inc
include Win32API.inc

;Define the needed external functions and constants here.
Extrn           ExitProcess:PROC
Extrn           MessageBoxA:PROC                
Extrn           GetModuleHandleA:PROC                

.Data                                        
Kern            db 'Kernel32',0
Getp            db 'GetProcAddress',0
base            dd 0


.Code                                  

Main:
    int 3
    Push offset Kern
    call GetModuleHandleA
    mov base, eax     
    Push offset Getp
    Push eax
    call GetProcAddressET

Exit_Proc:
     int 3
     Push LARGE-1
     Call ExitProcess

GetProcAddressET proc ;This function is similar to GetProcAddressIT except
                      ;  that it looks for API functions in the export table
                      ;  of a given DLL module. It has the same functionality
                      ;  as the original GetProcAddress API exported from
                      ;  KERNEL32 except that it is able to find API
                      ;  functions exported by ordinal from KERNEL32.
                      ;on entry:
                      ;  TOS+08h (Arg2): pszAPIname (pointer to API name)
                      ;  TOS+04h (Arg1): module handle/base address of module
                      ;  TOS+00h (return adress)
                      ;on exit:
                      ;  ECX = API function address
                      ;  ECX = 0, if not found

        pushad
        @SEH_SetupFrame <jmp Proc_Address_not_found>
        mov     eax,[esp.(2*Pshd).cPushad.Arg1] ;get Module Handle from Arg1
        mov     ebx,eax
        add     eax,[eax.MZ_lfanew]             ;get address of PE header
        mov     ecx,[eax.NT_OptionalHeader    \ ;get size of Export directory
                        .OH_DirectoryEntries  \
                        .DE_Export            \
                        .DD_Size]
        jecxz   Proc_Address_not_found          ;size is zero, no API exported
        mov     ebp,ebx                         ;get address of Export directory
        add     ebp,[eax.NT_OptionalHeader    \
                        .OH_DirectoryEntries  \
                        .DE_Export            \
                        .DD_VirtualAddress]
ifdef   Ordinal
        mov     eax,[esp.(2*Pshd).cPushad.Arg2] ;get address of requested API from Arg2
        test    eax,-10000h                     ;check if Arg2 is an ordinal
        jz      Its_API_ordinal
endif

Its_API_name:

        push    ecx
        mov     edx,ebx                         ;get address of exported API namez
        add     edx,[ebp.ED_AddressOfNames]
        mov     ecx,[ebp.ED_NumberOfNames]      ;get number of exported API namez
        xor     eax,eax
        cld

Search_for_API_name:

        mov     esi,ebx                         ;get address of next exported API name
        add     esi,[edx+eax*4]
        mov     edi,[esp.(3*Pshd).cPushad.Arg2] ;get address of requested API name from Arg2

Next_Char_in_API_name:

        cmpsb                           ;find requested API from all exported API namez
        jz      Matched_char_in_API_name
        inc     eax
        loop    Search_for_API_name
        pop     eax

Proc_Address_not_found:

        xor     eax,eax                 ;API not found
        jmp     End_GetProcAddressET

ifdef   Ordinal

Its_API_ordinal:

        sub     eax,[ebp.ED_BaseOrdinal]        ;normalize Ordinal, i.e. convert it to an index
        jmp     Check_Index
endif

Matched_char_in_API_name:

        cmp     byte ptr [esi-1],0              ;end of API name reached ?
        jnz     Next_Char_in_API_name
        pop     ecx
        mov     edx,ebx                         ;get address of exported API ordinalz
        add     edx,[ebp.ED_AddressOfOrdinals]
        movzx   eax,word ptr [edx+eax*2]        ;get index into exported API functionz

Check_Index:

        cmp     eax,[ebp.ED_NumberOfFunctions]  ;check for out of range index
        jae     Proc_Address_not_found
        mov     edx,ebx                         ;get address of exported API functionz
        add     edx,[ebp.ED_AddressOfFunctions]
        add     ebx,[edx+eax*4]         ;get address of requested API function
        mov     eax,ebx
        sub     ebx,ebp                 ;take care of forwarded API functionz
        cmp     ebx,ecx
        jb      Proc_Address_not_found

End_GetProcAddressET:

        mov     [esp.(2*Pshd).Pushad_ecx],eax   ;set requested Proc Address, if found
        @SEH_RemoveFrame
        popad
        jmp     Ret2Pshd

Ret2Pshd:

        ret     (2*Pshd)

GetProcAddressET endp

End Main
