

#include <Windows.H>

#include "ProcMem.h"


//////////////////////////////////////////////////////////////


#if defined(_X86_)
#define STACKPTR(Context)  (Context.Esp)
#endif

#if defined(_MIPS_)
#define STACKPTR(Context)  (Context.IntSp)
#endif

#if defined(_ALPHA_)
#define STACKPTR(Context)  (Context.IntSp)
#endif

#if !defined(STACKPTR)
#error Module contains CPU-specific code; modify and re-compile.
#endif


//////////////////////////////////////////////////////////////


#define ORD_ExitThread		((LPCSTR) MAKEINTRESOURCE(0x55))


//////////////////////////////////////////////////////////////


PVOID AllocProcessMemory (HANDLE hProcess, DWORD dwNumBytes) {
	CONTEXT Context;
	DWORD dwThreadId, dwNumBytesXferred, dwError;
	HANDLE hThread;
	HINSTANCE hinstKrnl = GetModuleHandle(__TEXT("Kernel32"));
	PVOID pvMem;
	MEMORY_BASIC_INFORMATION mbi;
	BOOL fOk = FALSE;	

	__try {
		hThread = CreateRemoteThread(
			hProcess, 
			NULL,	
			dwNumBytes + sizeof(HANDLE),
			(LPTHREAD_START_ROUTINE) 
				GetProcAddress(hinstKrnl, ORD_ExitThread), 
			0,
			CREATE_SUSPENDED,	
			&dwThreadId);	

		if (hThread == NULL) {	
			dwError = GetLastError();
			__leave;
		}

		Context.ContextFlags = CONTEXT_CONTROL;
		if (!GetThreadContext(hThread, &Context))
			__leave;

		if (sizeof(mbi) != VirtualQueryEx(hProcess,
			(PDWORD) STACKPTR(Context) - 1, &mbi, sizeof(mbi)))
			__leave;
		pvMem = (PVOID) mbi.BaseAddress;

		fOk = WriteProcessMemory(hProcess, pvMem, &hThread, 
			sizeof(hThread), &dwNumBytesXferred);

		if (!fOk) 
			__leave;

		pvMem = (PVOID) ((PHANDLE) pvMem + 1);
	}
	__finally {
		if (!fOk) {
			if (hThread) {
				ResumeThread(hThread);
			}
			pvMem = NULL;
		}
	}		
    
    return(pvMem);
}


//////////////////////////////////////////////////////////////


BOOL FreeProcessMemory (HANDLE hProcess, PVOID pvMem) {
	BOOL fOk;
	HANDLE hThread;
	DWORD dwNumBytesXferred;

	pvMem = (PVOID) ((PHANDLE) pvMem - 1);

	fOk = ReadProcessMemory(hProcess, pvMem, &hThread, 
		sizeof(hThread), &dwNumBytesXferred);

	if (fOk) {
		if (ResumeThread(hThread) == 0xffffffff) {
			fOk = FALSE;
		}
		CloseHandle(hThread);
	}

	return(fOk);
}


