//======================================================================
// 
// Ioctlcmd.h
//
// Copyright (C) 1996 Mark Russinovich and Bryce Cogswell
//
// Common header file for device driver and GUI. Contains common
// data structure definitions and IOCTL command codes.
//
//======================================================================

//
// Commands that the GUI can send the device driver.
//
enum {
	FILEMON_zerostats	= 1,
	FILEMON_getstats	= 2,  
        FILEMON_stopfilter      = 3,
        FILEMON_startfilter     = 4,
        FILEMON_setfilter       = 5
};



//
// Format of a data entry.
//
typedef struct {
	unsigned long	seq;
	char	text[0];
} ENTRY, *PENTRY;

//
// Size of a storage buffer in bytes.
//
#define MAX_STORE       64*0x1000

//
// Filter definition
//
typedef struct {
        char     processfilter[32];
        char     pathfilter[256];
        char     excludefilter[256];
        BOOL     logreads;
        BOOL     logwrites;
} FILTER, *PFILTER;

//
// Define page size for use by GUI.
//
#ifndef PAGE_SIZE
#define PAGE_SIZE 4096
#endif

