/*
   This program reproduces the sparkle effect in BrainsBreaker 2.1.
   The program template is derived by the book "Programming Windows 95"
   by Charles Petzold and Paul Yao. This is an envaluable source of info
   on the standard API programming using C.
   How to compile this using Microsoft Visual C++ 4.0:
   run VCVARS32.BAT installed by visual c++
   run enclosed MSC.BAT to setup compiler switches
   nmake sparkle.mak

   (C) Mad - 31/V/1998
*/

#include <windows.h>                    // standard include
#include <stdlib.h>                     // needed for the rand func

LRESULT CALLBACK WndProc (HWND, UINT, WPARAM, LPARAM) ;

int             i=0 ;           // counter for animation frames (0-21)
int             line, col ;     // x and y coord for our sparkle
HBITMAP         hBitmap ;       // handle to our bitmap

int cxClient, cyClient ;        // height and width of our client window

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
     static char szAppName[] = "Sparkle" ;              // program name
     HWND        hwnd ;                                 // handle to main win
     MSG         msg ;                                  // the message struct
     WNDCLASSEX  wndclass ;                             // the window class

     hBitmap = LoadBitmap (hInstance, "SPARKLE") ;
     // we load the bitmap from file resources, take a look at sparkle.rc and
     // sparkle.mak to see how this is generated and linked to the exe

     wndclass.cbSize        = sizeof (wndclass) ;
     wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
     wndclass.lpfnWndProc   = WndProc ;
     wndclass.cbClsExtra    = 0 ;
     wndclass.cbWndExtra    = 0 ;
     wndclass.hInstance     = hInstance ;
     wndclass.hIcon         = LoadIcon (NULL, IDI_APPLICATION) ;
     wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
     wndclass.hbrBackground = (HBRUSH) GetStockObject (BLACK_BRUSH) ;
     wndclass.lpszMenuName  = NULL ;
     wndclass.lpszClassName = szAppName ;
     wndclass.hIconSm       = LoadIcon (NULL, IDI_APPLICATION) ;

     RegisterClassEx (&wndclass) ;
     // we register standard window attributes, using a black background

     hwnd = CreateWindow (szAppName, "The sparkle effect",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;
     // we create the window


     SetTimer (hwnd, 1, 100, NULL) ;
     // this is the timer that produces WM_TIMER messages that we use
     // to do the animation
     // parameters: hwnd is the window handle, 1 is arbitrary timer number
     // 100 is timer resolution in milliseconds, change it if animation
     // is too fast on your system

     ShowWindow (hwnd, iCmdShow) ;
     UpdateWindow (hwnd) ;
     // these show program window on system desktop

     while (GetMessage (&msg, NULL, 0, 0))
     {
               TranslateMessage (&msg) ;
               DispatchMessage (&msg) ;
     }
     // this is the message loop 

     DeleteObject ((HGDIOBJ) hBitmap) ;   // we clean our bitmap

     return msg.wParam ;
}

LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
     BITMAP        ImageBit ;    // our bitmap
     HDC           hdcMem ;      // handle to memory device context
     HDC           hdc ;         // handle to our window device context

     switch (iMsg)
     {
          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;
          // if the user change window size, we change our drawing area

          case WM_TIMER:
               hdc = GetDC (hwnd) ;             
               hdcMem = CreateCompatibleDC(0) ; 
               SelectObject(hdcMem, hBitmap) ;
               GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &ImageBit) ;
               // we define a memory region to copy our bitmap, then we
               // select it and put its bits (pixel data) in our memory region

               if (i==0)        
               {                
                        line = (rand() % (cyClient-31)) ;
                        col = (rand() % (cxClient-25)) ;
               }
               // this controls where the animation should perform.
               // the place is choosed randomly in the client area every
               // time we are at frames number 0

               BitBlt(hdc, col, line, 21, 31, hdcMem, 21*i, 0, SRCCOPY);
               // this is the frame displaying
               // parameters are: hdc, handle to device context
               // col and line global variables of the top,left corner of
               // the frame, 21 and 31 refers to frame width and height
               // hdcMem is the memory handle from where we are copying
               // frames, 21*i and 0 are the top,left corner of the source
               // bitmap and SRCCOPY means we are simply copying the source
               // 21*i choose the frame cause i is the number of the frame
               // we should currently show and 21 is the frame width.

               DeleteDC(hdcMem) ;               // clean up handles
               ReleaseDC(hwnd, hdc) ;

               if (i<20) i++ ;          // get a new frame until 21, then
               else i=0 ;               // restart with first

               return 0 ;

          case WM_DESTROY:
               KillTimer (hwnd, 1) ;    // we release timer
               PostQuitMessage (0) ;    // and close the window
               return 0 ;
     }
     return DefWindowProc (hwnd, iMsg, wParam, lParam) ;
}
