; ---------------------------------------------------------------------------
; This is a key generator designed to work with Terminate 4.0/5.0 and up
; Compiled with Turbo Assembler:
; TASM /m5 ter5key.asm
; TLINK /t ter5key
; This produces a COM file. I used this file format, cause we must do memory
; manipulation, and in this type of program this is very easy (we got no
; relocation). The key is generated in memory, using data at the end of this
; file and then written to disk. At the end of data we have the CRC table
; derived from terminat.exe.
; When you find comment like 4342:B9D, this refers to offset in regist.lst
; and should be the same in the live approach
; (C) Mad - VI/1998 (Coded in about 4 days)
; ---------------------------------------------------------------------------

.MODEL tiny             ; this is a COM file
.CODE                   ; code starts here

                org 100h                ; origin for COM files

public start

; ===========================================================================
; The main function
; ===========================================================================

start		proc near

                call    GetUserData             ; get user input
                call    StoreCRC                ; create 2nd and 3rd CRC
                call    CryptData               ; crypt user data
                call    CRC_B                   ; generate 1st CRC
                call    CreateFile              ; write the key file to disk
                int     20h                     ; exit to DOS

start		endp

; ---------------------------------------------------------------------------
; Store 2nd and 3rd CRC in their locations. Refers to CalcCRC that does the
; real CRC generation.
; ---------------------------------------------------------------------------

StoreCRC        proc near               
                mov     LowCRC, 0FFFFh          ; 4342:B6C
		mov	HighCRC, 0FFFFh
                mov     si, offset O_426        ; offset of 4th chunk
                mov     ax, 5Bh                 ; we calculate CRC from 
                mov     Counter, ax             ; 5B to 15D
		mov	bp, 15Dh
		push	si
                call    CalcCRC                 ; real CRC calculating 
		pop	si
		add	si, 162h
		mov	bx, LowCRC
		mov	ax, HighCRC
                mov     [si-4], bx      ; this is the 2nd CRC at chunk end
                mov     [si-2], ax      ; this is the 2nd CRC at chunk end
                add     bx, 0Ah         ; fundamental for the 3rd CRC
                mov     [si+15Eh], bx   ; offset 6E6 of TERMINAT.KEY (3rd CRC)
                                        ; this is the end of the 5th block
                mov     [si+160h], ax   ; offset 6E8 of TERMINAT.KEY (3rd CRC)
                ret 
StoreCRC	endp

; ---------------------------------------------------------------------------
; Calculates 1st CRC for 11 blocks of 162h bytes.
; This CRC is stored at the end.
; Refers to CalcCRC that does the real CRC generation.
; ---------------------------------------------------------------------------

CRC_B           proc near               
                mov     si, offset KeyHeader    ; key-file beginning
                mov     cx, 0Bh                 ; we use this as a counter
                mov     LowCRC, 0FFFFh          ; these are for CRC
                                                ; 4342:4E8
                mov     HighCRC, 0FFFFh         ; initialization

CRC_B_loop:
		push	cx
		push	si
                xor     ax, ax                  ; 4342:4F6
                mov     Counter, ax             ; this time CRC is calculated
                mov     bp, 15Dh                ; for bytes 0-15D
                call    CalcCRC         
		pop	si
		pop	cx
                add     si, 162h                ; we go to the next chunk
                loop    CRC_B_loop              ; loop for 11 times
		mov	bx, LowCRC
		mov	ax, HighCRC
                mov     [si-4], bx              ; we store CRC at key end
		mov	[si-2],	ax
                ret 
CRC_B		endp


; ---------------------------------------------------------------------------
; Calculate a CRC using a table derived from the EXE file (offset 1D984 of
; TERMINAT.EXE)
; The routine is practically copied from the original one
; ---------------------------------------------------------------------------

CalcCRC         proc near               
                jmp     entry

restart:                              
                inc     Counter                 ; is [17D2] in live approach
                                                ; 4342:56B / 4342:B9D

entry:                              
		mov	di, Counter
		push	di
		add	di, si
                mov     al, [di]        ; refers to ES:[di] where is key chunk
                pop     di                      
		push	ax
		push	HighCRC
		push	LowCRC
		pop	bx
		pop	dx
		pop	cx
		push	dx
		push	bx
		xor	bx, cx
		xor	bh, bh
		shl	bx, 1
		shl	bx, 1
                add     bx, offset CRCData         ; array of CRC table
		mov	ax, [bx]
		mov	cx, [bx+2]
		pop	bx
		pop	dx
		push	cx
		mov	cx, 8

mult:           shr     dx, 1
		rcr	bx, 1
                loop    mult
		and	dx, 0FFh
		pop	cx
		xor	ax, bx
		mov	bx, cx
		xor	dx, bx
		mov	LowCRC,	ax
		mov	HighCRC, dx
		cmp	Counter, bp
                jz      done
                jmp     restart
                                        ; 4342:5D0 and 4342:C04
done:           ret 
CalcCRC		endp

; ---------------------------------------------------------------------------
; Here goes the real crypting
; Refers to the GenerateRND routine.
; The routine is practically copied from the original one, i've removed
; some check, cause they wan't occur
; Data crypting contains reference to the ES segment. Cause we are working
; with a COM file, we could remove them, or change to CS/DS, but doing so
; we lose original code
; ---------------------------------------------------------------------------

CryptData       proc near               
                mov     si, offset O_426        ; offset of 4th block
                mov     bp, 161h                ; crypt from 5B to 161
		mov	ax, 5Bh
		mov	Counter, ax
                jmp     entry_1

restart_1:
                inc     Counter         ; 4342:9D4 / Counter is [17D2]

entry_1:                                        ; loops 106 times
                mov     ax, es          
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	al, es:[di]
		xor	al, 0FFh
		mov	dl, al
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	es:[di], dl
		mov	ax, Counter
		cmp	ax, bp
                jnz     restart_1               ; 4342:A08
                mov     WCrypt_1, 7             ; [24E6]
                mov     WCrypt_2, 0             ; [24E8]
		mov	ax, 5Bh
		mov	Counter, ax
                jmp     entry_2

restart_2:
		inc	Counter

entry_2:
                mov     ax, 100h                ; 4342:A40
		push	ax
		call	GenerateRND
		mov	dx, ax
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	al, es:[di]
		xor	ah, ah
		xor	ax, dx
		mov	dl, al
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	es:[di], dl
		mov	ax, Counter
		cmp	ax, bp
                jnz     restart_2
                mov     WCrypt_1, 325Ch                 ; 4342:A7F
		mov	WCrypt_2, 0
		mov	ax, 5Bh
		mov	Counter, ax
                jmp     entry_3

restart_3:
                inc     Counter                         ; 4342:AB1

entry_3:
                mov     ax, 100h                        ; 4342:AB5
		push	ax
		call	GenerateRND
		mov	dx, ax
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	al, es:[di]
		xor	ah, ah
		xor	ax, dx
		mov	dl, al
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	es:[di], dl
		mov	ax, Counter
		cmp	ax, bp
                jnz     restart_3                       ; 4342:AF2
                mov     WCrypt_1, 904h                  ; 4342:AF4
		mov	WCrypt_2, 33EEh
		mov	ax, 5Bh
		mov	Counter, ax
                jmp     entry_4

restart_4:
                inc     Counter                         ; 4342:B26

entry_4:
                mov     ax, 100h                        ; 4342:B2A
		push	ax
		call	GenerateRND
		mov	dx, ax
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	al, es:[di]
		xor	ah, ah
		xor	ax, dx
		mov	dl, al
		mov	ax, es
		push	ax
		mov	di, Counter
		add	di, si
		pop	es
		mov	es:[di], dl
		mov	ax, Counter
		cmp	ax, bp
                jnz     restart_4                       ; 4342:B67
                ret 
CryptData       endp                 


; ---------------------------------------------------------------------------
; Generate a random number using WCrypt_1, WCrypt_2, WCrypt_3 and AX
; The routine is practically copied from the original one
; ---------------------------------------------------------------------------

GenerateRND     proc near                       ; CS:2053
        
		push	bp
		mov	bp, sp
		mov	ax, WCrypt_1
		mov	bx, WCrypt_2
		mov	cx, ax
                mul     WCrypt_3                ; gets initialized at 8405h
		shl	cx, 1
		shl	cx, 1
		shl	cx, 1
		add	ch, cl
		add	dx, cx
		add	dx, bx
		shl	bx, 1
		shl	bx, 1
		add	dx, bx
		add	dh, bl
		mov	cl, 5
		shl	bx, cl
		add	dh, bl
		add	ax, 1
		adc	dx, 0
		mov	WCrypt_1, ax
		mov	WCrypt_2, dx
		xor	ax, ax
                mov     bx, [word ptr bp + 4]   ; [BP+6] / [ACB4] / pushed AX
                                                ; AX = 100h
		or	bx, bx
                jz      done_2
		xchg	ax, dx
		div	bx
		xchg	ax, dx

done_2:
		pop	bp
                ret     2                       ; we remove the pushed value
GenerateRND	endp

; ---------------------------------------------------------------------------
; Create the key file named TERMINAT.KEY
; ---------------------------------------------------------------------------

CreateFile      proc near               
                mov     ah, 3Ch                 ; DOS func to create a file
                mov     dx, offset KeyName      ; Terminat.Key
                xor     cx, cx                  ; file attribute normal
                int     21h             
		mov	FileHandle, ax
                mov     ah, 40h
		mov	bx, FileHandle
                mov     cx, 0F36h               ; key length 3894 bytes
		mov	dx, offset KeyHeader
                int     21h             ; DOS func to write data to a file
                mov     ah, 3Eh
		mov	bx, FileHandle
                int     21h             ; DOS func to close a file
                ret 
CreateFile	endp


; ---------------------------------------------------------------------------
; Writes screen messages to input user data
; ---------------------------------------------------------------------------

GetUserData     proc near               
                mov     ax, 3           ; we set video mode 3, 80x25
                int     10h             ; and clear the screen
		xor	dx,dx
                call    SetCursorPos            ; we write at (0,0)
		mov	dx, offset NameMsg
                mov     ah, 9                   ; insert your name...
		int	21h
                mov     dx, 0100h               ; line 1 col 0
                mov     di, offset YourName     ; offset 4A1 of keyfile
		call	InputString
		mov	dx, 0200h
                call    SetCursorPos            ; we write at (2,0)
		mov	dx, offset AddressMsg
                mov     ah, 9                   ; insert your address...
		int	21h
                mov     dx, 0300h               ; line 3 col 0
                mov     di, offset Address      ; offset 4D4 of keyfile
		call	InputString
		mov	dx, 0400h
                call    SetCursorPos            ; we write at (4,0)
		mov	dx, offset CityMsg
                mov     ah, 9                   ; insert your city...
		int	21h
                mov     dx, 0500h               ; line 5 col 0
                mov     di, offset City         ; offset 507 of keyfile
		call	InputString
		mov	dx, 0600h
                call    SetCursorPos            ; we write at (6,0)
		mov	dx, offset CountryMsg
                mov     ah, 9                   ; insert your country...
		int	21h
                mov     dx, 0700h               ; line 7 col 0 
                mov     di, offset Country      ; offset 53A of keyfile
		call	InputString
                ret 
GetUserData	endp

; ---------------------------------------------------------------------------
; Get user data and handles various keys.
; Insert strings length in front of them (Pascal style)
; Max strings length is 50 chars, controlled by the CX counter (decreased)
; Input registers: DH, DL line and col where to write user input
; DI points to offset of string in memory
; ---------------------------------------------------------------------------

InputString     proc near
                mov     cx, 32h         ; max number of input chars (50)
                                        ; this will be truncated at 44 chars
                                        ; when displayed on Options Screen
                                        ; in Terminate (Alt-O)

get_key:
		call	SetCursorPos
                xor     ah, ah          ; we want service number 0
                int     16h             ; BIOS func to get a char from buffer
                                        ; AL contains ASCII code for the key
                or      al, al          ; AL=0 means an extended code, but we
                                        ; wan't accept those keys
                jnz     process         ; we process it
                jmp     get_key

process:
                cmp     al, 8           ; we have pressed BackSpace
                jz      backspace
                cmp     al, 0Dh         ; we have pressed Return Key
                jz      carriage
                or      cx,cx           ; if cx is 0, we can accept no more
                                        ; keys, so we go back to start until
                jz      get_key         ; we get a Return or Backspace
                dec     cx              ; we have CX-1 chars available
                push    ax              ; if we arrive here, we print char
                push    cx              ; on the screen
                mov     ah, 9           ; BIOS func to print chars
                mov     bx, 0Fh         ; char attributes (White on black)
                mov     cx, 1           ; number of chars to be printed
                int     10h             
		inc	dl
                call    SetCursorPos    ; move the cursor forward
		pop	cx
		pop	ax
                cld                     ; we clear string direction
                stosb                   ; we store inserted char in memory
                                        ; at DS:DI - remember this auto
                                        ; increase DI
                jmp     get_key

carriage:                               ; when we press Return, we complete
                                        ; the string inserting its length
                                        ; in front of it
                mov     ax, cx          ; CX contains # of chars available
                mov     cx, 32h         ; max number of input chars 
                sub     cx, ax          ; CX is # of inserted chars
                sub     di, cx          ; DI points to next char in the string
                dec     di              ; now it points to 1st char-1
                mov     [di], cl        ; we store string length
                ret 

backspace:                              
                dec     dl              ; if we have pressed backspace, we
                cmp     dl, 0           ; check we are not at the 1st char
                jge     removechar
                inc     dl              ; if we press backspace with no data
                jmp     get_key         ; inserted, we ignore it

removechar:
                dec     di              ; DI points to the char in memory
                inc     cx              ; CX is the number of chars available
                mov     byte ptr [di], 0 ; we put a NULL over the char
		push	ax
		push	cx
                call    SetCursorPos    ; we move the cursor back
                mov     ah, 9           ; BIOS func to write a char
                mov     al, 20h         ; we want a space
                mov     bx, 0Fh         ; char attribute
                mov     cx, 1           ; # of chars to be printed
                int     10h             
		pop	cx
		pop	ax
                jmp     get_key

InputString	endp

; ---------------------------------------------------------------------------
; Move the cursor at location dh,dl
; ---------------------------------------------------------------------------

SetCursorPos    proc near

                mov     ah, 2           ; BIOS func to set cursor position
                xor     bh, bh          ; we are writing in page 0
                int     10h             
                ret

SetCursorPos	endp



.DATA

NameMsg		db 'Insert your name (max 50 chars): ','$'
AddressMsg	db 'Insert your address (max 50 chars): ','$'
CityMsg		db 'Insert your zip/city (max 50 chars): ','$'
CountryMsg	db 'Insert your country (max 50 chars): ','$'
LowCRC          dw 0                    
HighCRC         dw 0                    
Counter         dw 0                    
WCrypt_1        dw 0                    
WCrypt_2        dw 0                    
WCrypt_3        dw 8405h                ; initialization from original routine
KeyName         db 'TERMINAT.KEY',0     
FileHandle      dw 0
; With KeyHeader starts the key data in memory. Most of it is initialized
; to 00. You must not move following data, cause this would change key
; organization in memory and prevent the key from functioning
KeyHeader       db 'Mad presents a Terminate 5.00 key '
; this is a fake header, change it if you want (don't change its length: 22h)
                db 141h dup(0)     
                db 01                           ; offset 163h of the key
                db 2C2h dup(0)              
O_426           db 7Bh dup(0)                   ; offset of the 4th block
YourName        db 33h dup(0)           
Address         db 33h dup(0)           
City            db 33h dup(0)           
Country         db 33h dup(0)           
                db 993h dup(0)
                db 01                           ; offset F00 of the key
                db 35h dup(0)

CRCData         db 0, 0, 0, 0, 96h, 30h                 ; retrieved from
                db 7, 77h, 2Ch, 61h, 0Eh, 0EEh          ; offset 1DD83 of
                db 0BAh, 51h, 9, 99h, 19h               ; terminat.exe
                db 0C4h, 6Dh, 7, 8Fh, 0F4h              ; 400h bytes long
		db 6Ah,	70h, 35h, 0A5h,	63h
		db 0E9h, 0A3h, 95h, 64h, 9Eh
		db 32h,	88h, 0DBh, 0Eh,	0A4h
		db 0B8h, 0DCh, 79h, 1Eh, 0E9h
		db 0D5h, 0E0h, 88h, 0D9h, 0D2h
		db 97h,	2Bh, 4Ch, 0B6h,	9
		db 0BDh, 7Ch, 0B1h, 7Eh, 7
		db 2Dh,	0B8h, 0E7h, 91h, 1Dh
		db 0BFh, 90h, 64h, 10h,	0B7h
		db 1Dh,	0F2h, 20h, 0B0h, 6Ah
		db 48h,	71h, 0B9h, 0F3h, 0DEh
		db 41h,	0BEh, 84h, 7Dh,	0D4h
		db 0DAh, 1Ah, 0EBh, 0E4h, 0DDh
		db 6Dh,	51h, 0B5h, 0D4h, 0F4h
		db 0C7h, 85h, 0D3h, 83h, 56h
		db 98h,	6Ch, 13h, 0C0h,	0A8h
		db 6Bh,	64h, 7Ah, 0F9h,	62h
		db 0FDh, 0ECh, 0C9h, 65h, 8Ah
		db 4Fh,	5Ch, 1,	14h, 0D9h
		db 6Ch,	6, 63h,	63h, 3Dh, 0Fh
		db 0FAh, 0F5h, 0Dh, 8, 8Dh
		db 0C8h, 20h, 6Eh, 3Bh,	5Eh
		db 10h,	69h, 4Ch, 0E4h,	41h
		db 60h,	0D5h, 72h, 71h,	67h
		db 0A2h, 0D1h, 0E4h, 3,	3Ch
		db 47h,	0D4h, 4, 4Bh, 0FDh
		db 85h,	0Dh, 0D2h, 6Bh,	0B5h
		db 0Ah,	0A5h, 0FAh, 0A8h, 0B5h
		db 35h,	6Ch, 98h, 0B2h,	42h
		db 0D6h, 0C9h, 0BBh, 0DBh, 40h
		db 0F9h, 0BCh, 0ACh, 0E3h, 6Ch
		db 0D8h, 32h, 75h, 5Ch,	0DFh
		db 45h,	0CFh, 0Dh, 0D6h, 0DCh
		db 59h,	3Dh, 0D1h, 0ABh, 0ACh
		db 30h,	0D9h, 26h, 3Ah,	0
		db 0DEh, 51h, 80h, 51h,	0D7h
		db 0C8h, 16h, 61h, 0D0h, 0BFh
		db 0B5h, 0F4h, 0B4h, 21h, 23h
		db 0C4h, 0B3h, 56h, 99h, 95h
		db 0BAh, 0CFh, 0Fh, 0A5h, 0BDh
		db 0B8h, 9Eh, 0B8h, 2, 28h
		db 8, 88h, 5, 5Fh, 0B2h, 0D9h
		db 0Ch,	0C6h, 24h, 0E9h, 0Bh
		db 0B1h, 87h, 7Ch, 6Fh,	2Fh
		db 11h,	4Ch, 68h, 58h, 0ABh
		db 1Dh,	61h, 0C1h, 3Dh,	2Dh
		db 66h,	0B6h, 90h, 41h,	0DCh
		db 76h,	6, 71h,	0DBh, 1, 0BCh
		db 20h,	0D2h, 98h, 2Ah,	10h
		db 0D5h, 0EFh, 89h, 85h, 0B1h
		db 71h,	1Fh, 0B5h, 0B6h, 6
		db 0A5h, 0E4h, 0BFh, 9Fh, 33h
		db 0D4h, 0B8h, 0E8h, 0A2h, 0C9h
		db 7, 78h, 34h,	0F9h, 0, 0Fh
		db 8Eh,	0A8h, 9, 96h, 18h
		db 98h,	0Eh, 0E1h, 0BBh, 0Dh
		db 6Ah,	7Fh, 2Dh, 3Dh, 6Dh
		db 8, 97h, 6Ch,	64h, 91h, 1
		db 5Ch,	63h, 0E6h, 0F4h, 51h
		db 6Bh,	6Bh, 62h, 61h, 6Ch
		db 1Ch,	0D8h, 30h, 65h,	85h
		db 4Eh,	0, 62h,	0F2h, 0EDh
		db 95h,	6, 6Ch,	7Bh, 0A5h
		db 1, 1Bh, 0C1h, 0F4h, 8, 82h
		db 57h,	0C4h, 0Fh, 0F5h, 0C6h
		db 0D9h, 0B0h, 65h, 50h, 0E9h
		db 0B7h, 12h, 0EAh, 0B8h, 0BEh
		db 8Bh,	7Ch, 88h, 0B9h,	0FCh
		db 0DFh, 1Dh, 0DDh, 62h, 49h
		db 2Dh,	0DAh, 15h, 0F3h, 7Ch
		db 0D3h, 8Ch, 65h, 4Ch,	0D4h
		db 0FBh, 58h, 61h, 0B2h, 4Dh
		db 0CEh, 51h, 0B5h, 3Ah, 74h
		db 0, 0BCh, 0A3h, 0E2h,	30h
		db 0BBh, 0D4h, 41h, 0A5h, 0DFh
		db 4Ah,	0D7h, 95h, 0D8h, 3Dh
		db 6Dh,	0C4h, 0D1h, 0A4h, 0FBh
		db 0F4h, 0D6h, 0D3h, 6Ah, 0E9h
		db 69h,	43h, 0FCh, 0D9h, 6Eh
		db 34h,	46h, 88h, 67h, 0ADh
		db 0D0h, 0B8h, 60h, 0DAh, 73h
		db 2Dh,	4, 44h,	0E5h, 1Dh
		db 3, 33h, 5Fh,	4Ch, 0Ah, 0AAh
		db 0C9h, 7Ch, 0Dh, 0DDh, 3Ch
		db 71h,	5, 50h,	0AAh, 41h
		db 2, 27h, 10h,	10h, 0Bh, 0BEh
		db 86h,	20h, 0Ch, 0C9h,	25h
		db 0B5h, 68h, 57h, 0B3h, 85h
		db 6Fh,	20h, 9,	0D4h, 66h
		db 0B9h, 9Fh, 0E4h, 61h, 0CEh
		db 0Eh,	0F9h, 0DEh, 5Eh, 98h
		db 0C9h, 0D9h, 29h, 22h, 98h
		db 0D0h, 0B0h, 0B4h, 0A8h, 0D7h
		db 0C7h, 17h, 3Dh, 0B3h, 59h
		db 81h,	0Dh, 0B4h, 2Eh,	3Bh
		db 5Ch,	0BDh, 0B7h, 0ADh, 6Ch
		db 0BAh, 0C0h, 20h, 83h, 0B8h
		db 0EDh, 0B6h, 0B3h, 0BFh, 9Ah
		db 0Ch,	0E2h, 0B6h, 3, 9Ah
		db 0D2h, 0B1h, 74h, 39h, 47h
		db 0D5h, 0EAh, 0AFh, 77h, 0D2h
		db 9Dh,	15h, 26h, 0DBh,	4
		db 83h,	16h, 0DCh, 73h,	12h
		db 0Bh,	63h, 0E3h, 84h,	3Bh
		db 64h,	94h, 3Eh, 6Ah, 6Dh
		db 0Dh,	0A8h, 5Ah, 6Ah,	7Ah
		db 0Bh,	0CFh, 0Eh, 0E4h, 9Dh
		db 0FFh, 9, 93h, 27h, 0AEh
		db 0, 0Ah, 0B1h, 9Eh, 7, 7Dh
		db 44h,	93h, 0Fh, 0F0h,	0D2h
		db 0A3h, 8, 87h, 68h, 0F2h
		db 1, 1Eh, 0FEh, 0C2h, 6, 69h
		db 5Dh,	57h, 62h, 0F7h,	0CBh
		db 67h,	65h, 80h, 71h, 36h
		db 6Ch,	19h, 0E7h, 6, 6Bh
		db 6Eh,	76h, 1Bh, 0D4h,	0FEh
		db 0E0h, 2Bh, 0D3h, 89h, 5Ah
		db 7Ah,	0DAh, 10h, 0CCh, 4Ah
		db 0DDh, 67h, 6Fh, 0DFh, 0B9h
		db 0F9h, 0F9h, 0EFh, 0BEh, 8Eh
		db 43h,	0BEh, 0B7h, 17h, 0D5h
		db 8Eh,	0B0h, 60h, 0E8h, 0A3h
		db 0D6h, 0D6h, 7Eh, 93h, 0D1h
		db 0A1h, 0C4h, 0C2h, 0D8h, 38h
		db 52h,	0F2h, 0DFh, 4Fh, 0F1h
		db 67h,	0BBh, 0D1h, 67h, 57h
		db 0BCh, 0A6h, 0DDh, 6,	0B5h
		db 3Fh,	4Bh, 36h, 0B2h,	48h
		db 0DAh, 2Bh, 0Dh, 0D8h, 4Ch
		db 1Bh,	0Ah, 0AFh, 0F6h, 4Ah
		db 3, 36h, 60h,	7Ah, 4,	41h
		db 0C3h, 0EFh, 60h, 0DFh, 55h
		db 0DFh, 67h, 0A8h, 0EFh, 8Eh
		db 6Eh,	31h, 79h, 0BEh,	69h
		db 46h,	8Ch, 0B3h, 61h,	0CBh
		db 1Ah,	83h, 66h, 0BCh,	0A0h
		db 0D2h, 6Fh, 25h, 36h,	0E2h
		db 68h,	52h, 95h, 77h, 0Ch
		db 0CCh, 3, 47h, 0Bh, 0BBh
		db 0B9h, 16h, 2, 22h, 2Fh
		db 26h,	5, 55h,	0BEh, 3Bh
		db 0BAh, 0C5h, 28h, 0Bh, 0BDh
		db 0B2h, 92h, 5Ah, 0B4h, 2Bh
		db 4, 6Ah, 0B3h, 5Ch, 0A7h
		db 0FFh, 0D7h, 0C2h, 31h, 0CFh
		db 0D0h, 0B5h, 8Bh, 9Eh, 0D9h
		db 2Ch,	1Dh, 0AEh, 0DEh, 5Bh
		db 0B0h, 0C2h, 64h, 9Bh, 26h
		db 0F2h, 63h, 0ECh, 9Ch, 0A3h
		db 6Ah,	75h, 0Ah, 93h, 6Dh
		db 2, 0A9h, 6, 9, 9Ch, 3Fh
		db 36h,	0Eh, 0EBh, 85h,	67h
		db 7, 72h, 13h,	57h, 0,	5
		db 82h,	4Ah, 0BFh, 95h,	14h
		db 7Ah,	0B8h, 0E2h, 0AEh, 2Bh
		db 0B1h, 7Bh, 38h, 1Bh,	0B6h
		db 0Ch,	9Bh, 8Eh, 0D2h,	92h
		db 0Dh,	0BEh, 0D5h, 0E5h, 0B7h
		db 0EFh, 0DCh, 7Ch, 21h, 0DFh
		db 0DBh, 0Bh, 0D4h, 0D2h, 0D3h
		db 86h,	42h, 0E2h, 0D4h, 0F1h
		db 0F8h, 0B3h, 0DDh, 68h, 6Eh
		db 83h,	0DAh, 1Fh, 0CDh, 16h
		db 0BEh, 81h, 5Bh, 26h,	0B9h
		db 0F6h, 0E1h, 77h, 0B0h, 6Fh
		db 77h,	47h, 0B7h, 18h,	0E6h
		db 5Ah,	8, 88h,	70h, 6Ah, 0Fh
		db 0FFh, 0CAh, 3Bh, 6, 66h
		db 5Ch,	0Bh, 1,	11h, 0FFh
		db 9Eh,	65h, 8Fh, 69h, 0AEh
		db 62h,	0F8h, 0D3h, 0FFh, 6Bh
		db 61h,	45h, 0CFh, 6Ch,	16h
		db 78h,	0E2h, 0Ah, 0A0h, 0EEh
		db 0D2h, 0Dh, 0D7h, 54h, 83h
		db 4, 4Eh, 0C2h, 0B3h, 3, 39h
		db 61h,	26h, 67h, 0A7h,	0F7h
		db 16h,	60h, 0D0h, 4Dh,	47h
		db 69h,	49h, 0DBh, 77h,	6Eh
		db 3Eh,	4Ah, 6Ah, 0D1h,	0AEh
		db 0DCh, 5Ah, 0D6h, 0D9h, 66h
		db 0Bh,	0DFh, 40h, 0F0h, 3Bh
		db 0D8h, 37h, 53h, 0AEh, 0BCh
		db 0A9h, 0C5h, 9Eh, 0BBh, 0DEh
		db 7Fh,	0CFh, 0B2h, 47h, 0E9h
		db 0FFh, 0B5h, 30h, 1Ch, 0F2h
		db 0BDh, 0BDh, 8Ah, 0C2h, 0BAh
		db 0CAh, 30h, 93h, 0B3h, 53h
		db 0A6h, 0A3h, 0B4h, 24h, 5
		db 36h,	0D0h, 0BAh, 93h, 6
		db 0D7h, 0CDh, 29h, 57h, 0DEh
		db 54h,	0BFh, 67h, 0D9h, 23h
		db 2Eh,	7Ah, 66h, 0B3h,	0B8h
		db 4Ah,	61h, 0C4h, 2, 1Bh
		db 68h,	5Dh, 94h, 2Bh, 6Fh
		db 2Ah,	37h, 0BEh, 0Bh,	0B4h
		db 0A1h, 8Eh, 0Ch, 0C3h, 1Bh
		db 0DFh, 5, 5Ah, 8Dh, 0EFh
		db 2, 2Dh

end start
