/* This is a byte patcher for BrainsBreaker 2.1.
   This was coded using C and API functions and is customizable for your
   needs. (Use it and change it if you like)
   How to compile (using Microsoft Visual C++ 4.0):
   Run your VCVARS32.BAT to set environment variables
   run enclosed MSC.BAT to set compiler switches
   nmake patch.mak

   (C) Mad - 31/V/1998
   Change these vars to suite your needs:
   iPatchSize (numbers of byte to be checked to validate our patching)
   OriginalData (array of original bytes from the file)
   PatchedData (array of patched bytes)
   dwPatchFileSize (file-to-be-patched size)
   dwPatchPosition (offset of the string to be patched in the file)
   data strings in the first (and others) MessageBox
*/

#include <windows.h>

int WINAPI WinMain (HINSTANCE hInstance,HINSTANCE hPrevInstance,
                    PSTR szCmdLine, int iCmdShow)
{
        HANDLE hFile ;
        int iResult, i ;
                // iResult contains the result IDYES or IDNO
                // i is a counter for byte checking used in the for loop
        const int iPatchSize = 11 ;
                // iPatchSize is the number of bytes to be readed
        BYTE ReadBuffer[iPatchSize] ;
                // buffer for file reading
        BYTE OriginalData[iPatchSize] = {
                0xB9,0x01,0x00,0x00,0x00,0x83,0x7D,0x0C,0x00,0x75,0x03 } ;
                // original bytes derived from file
        BYTE PatchedData[iPatchSize] = {
                0xB9,0x01,0x00,0x00,0x00,0x83,0x7D,0x0C,0x00,0xEB,0x03 } ;
                // our patch
        DWORD dwBufSize ;
                // contains numbers of bytes really readed from file
        DWORD dwFileSize ;
                // size of the file we have opened
        DWORD dwPatchFileSize = 593920 ;
                // file size
        DWORD dwPatchPosition = 0x6A02E ;
                // the patching string starts here
        BOOL bReadOK ;
                // contains TRUE if file is successfully read
        BOOL bWriteOK ;
                // contains TRUE if file is successfully written

        iResult = MessageBox(NULL, "This is a BrainsBreaker 2.1 patcher.\n"
                            "This enable you to insert a random code,\n"
                            "and register yourself with a Full Pack.\n\n"
                            "Do you want to continue ?",
                            "The Patcher", MB_YESNO | MB_ICONQUESTION) ;

        if (iResult == IDNO) return 0 ;

        hFile = CreateFile("BBRK32.EXE", GENERIC_READ | GENERIC_WRITE, 0,
                           (LPSECURITY_ATTRIBUTES) NULL, OPEN_EXISTING,
                           FILE_ATTRIBUTE_NORMAL, (HANDLE) NULL) ;

        // we open the file for reading/writing, only if it exist

        if (hFile == INVALID_HANDLE_VALUE)
        {
                MessageBox(NULL, "The file BBRK32.EXE doesn't exist here.",
                           "Error", MB_OK | MB_ICONERROR) ;
                return 0 ;
        }

        dwFileSize = GetFileSize(hFile, NULL);

        if (dwFileSize != dwPatchFileSize)
        {
                        MessageBox(NULL, "File size don't match."
                                   "\nProbably not the right version "
                                   "of the file.",
                                   "Error", MB_OK | MB_ICONERROR) ;
                        CloseHandle(hFile) ;
                        return 0 ;
        }

        SetFilePointer(hFile, dwPatchPosition, NULL, FILE_BEGIN) ;

        bReadOK = ReadFile(hFile, &ReadBuffer, iPatchSize, &dwBufSize, NULL) ;

        if (bReadOK && dwBufSize==0)
        {
                        MessageBox(NULL, "File size don't match.",
                                   "Error", MB_OK | MB_ICONERROR) ;
                        CloseHandle(hFile) ;
                        return 0 ;
        }

        for (i = 0; i < iPatchSize; i++)
        {
                if (ReadBuffer[i] != OriginalData[i])
                {
                        MessageBox(NULL, "Data don't match, unable to patch.",
                                   "Error", MB_OK | MB_ICONERROR) ;
                        CloseHandle(hFile) ;
                        return 0 ;
                }
        }
         
        SetFilePointer(hFile, dwPatchPosition, NULL, FILE_BEGIN) ;

        bWriteOK = WriteFile(hFile, &PatchedData, iPatchSize, &dwBufSize, NULL) ;

        if ((bWriteOK && dwBufSize!=iPatchSize) || !bWriteOK)
        {
                        MessageBox(NULL, "File patching not succeded.",
                                   "Error", MB_OK | MB_ICONERROR) ;
                        CloseHandle(hFile) ;
                        return 0 ;
        }

        MessageBox(NULL, "File succesfully patched.", "Success",
                   MB_OK | MB_ICONINFORMATION) ;

        CloseHandle(hFile) ;

        return 0 ;

}
