#------------------------------------------------------------------------------# 
#                             - Challenge #4 -                                 #
#                                 by JaZZ                                      #
#------------------------------------------------------------------------------#
# Compiler: Borland C++ 4.52

#include <windows.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#define  MAXSMALL 10

int debug=0;
void err(char*);
// returns a random nbr in [0,range-1]
int rnd(int range) {
return(rand()%range);
}
// generates a random number in [a,d] but excluding ]b,c[
int rndexcl(int a,int b,int c,int d) {
int r,nbval;
nbval=b-a+d-c+2;
r=rnd(nbval);
if (r>b-a) r+=c-b+a-1;
else r+=a;
return (r);
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
						  char * szCmdLine, int iCmdShow) {
int maxcolors=7;
int colortab[][2]={ {0xffff,0xC0C0C0},{0xffff,0x8080},{0xffff00,0xff0000},
						 {0xc0C0C0,0x808080},{0xff00ff,0x800080},{0xffff00,0x808000},
						 {0xff00,0x8000} };
// coordinates of every ellipses
int tabell[][4]={{14,14,17,17},
		 {14,13,18,18},
		 {13,12,19,20},{15,14,17,18},
		 {12,11,20,21},{14,13,18,19},
		 {11,9,21,22},{13,11,19,20},{15,13,17,18},
		 {10,8,22,23},{13,10,20,21},{14,12,18,19},
		 {9,7,22,25},{11,9,20,23},{13,11,18,21} };
int nbrell[]={1,1,2,2,3,3,3}; // nbr of ellipses for each step of drawing

/* data for the small sparkles:
 * step of appearance (0 for invalid)
 * state (1 to 7)
 * coordinates of the center
 * brush
*/
struct sparks {
	int step;
	int age;
	int x,y;
} smalltab[MAXSMALL];
int nbsmall;
// center of the cross
int x_ctr=15;
int y_ctr=15;
int crleftx,crrghtx,crtopy,crboty;
double delta_left,delta_right,delta_top,delta_bot;
double lx,rx,ty,by;
int cur_ell;
HWND hwnd;
HDC hdc_sav,hdc_work,hdcScreen,hdc_bck;
HBITMAP hbmScreen,hbmScrsave,hbmbck;
HBRUSH br_white,br_black,br_col1,br_col2;
HPEN pen_white,pen_black,pen_col1,pen_col2;
RECT rec;
int colorused,etat,ii,i,j,hres,vres,xorg,yorg,x0,y0;
int bmpwidth,bmpheight;
int ell1top_x,ell1top_y,ell1bot_x,ell1bot_y;
char inifile[200],msg[200];
int fullscreen,blackscreen,howmuch,waste,v_height,v_width,bl_x,bl_y;
bmpwidth=bmpheight=32; /* dimensions of the sparkle */

// retrieve params in sparkle.ini
GetCurrentDirectory(200,msg);
sprintf(inifile,"%s/sparkle.ini",msg);
blackscreen=GetPrivateProfileInt("PARAMS","blackscreen",1,inifile);
fullscreen=GetPrivateProfileInt("PARAMS","fullscreen",1,inifile);
howmuch=GetPrivateProfileInt("PARAMS","howmuch",20,inifile);
waste=GetPrivateProfileInt("PARAMS","waste",30,inifile);
v_height=GetPrivateProfileInt("PARAMS","height",200,inifile);
v_width=GetPrivateProfileInt("PARAMS","width",300,inifile);
/* get the width & height of screen */
hdcScreen=GetWindowDC(GetDesktopWindow());
hres=GetDeviceCaps(hdcScreen,HORZRES);
vres=GetDeviceCaps(hdcScreen,VERTRES);

srand((unsigned)GetTickCount());
if (!fullscreen) {
	v_width %=(hres+1);
	v_height %=(vres+1);
	bl_x=rnd(hres-v_width+1);
	bl_y=rnd(vres-v_height+1);
}
else {
	  bl_x=bl_y=0;
	  v_width=hres;v_height=vres;
}

// compute the increments for the cross coordinates with 8 drawing steps
delta_left=(7.0-13.0)/7.0;
delta_right=(25.0-18.0)/7.0;
delta_top=(3.0-11.0)/7.0;
delta_bot=(30.0-20.0)/7.0;
br_white=CreateSolidBrush(0xffffff);
br_black=CreateSolidBrush(0);
pen_black=CreatePen(PS_SOLID,1,0);
pen_white=CreatePen(PS_SOLID,1,0xffffff);


/* create a dc comp with the desktop */
hdc_work=CreateCompatibleDC(hdcScreen);
hdc_sav=CreateCompatibleDC(hdcScreen);
/* a working bmp */
hbmScreen=CreateCompatibleBitmap(hdcScreen,bmpwidth,bmpheight);
/* initial image */
hbmScrsave=CreateCompatibleBitmap(hdcScreen,bmpwidth,bmpheight);
if (!hbmScreen||!hbmScrsave) err("hbmScreen");
if (blackscreen) {
	// save original screen & fill with black
	hdc_bck=CreateCompatibleDC(hdcScreen);
	hbmbck=CreateCompatibleBitmap(hdcScreen,v_width,v_height);
	SelectObject(hdc_bck,hbmbck);
	BitBlt(hdc_bck,0,0,v_width,v_height,hdcScreen,bl_x,bl_y,SRCCOPY);
	rec.left=bl_x;rec.top=bl_y;
	rec.right=bl_x+v_width;
	rec.bottom=bl_y+v_height;
	FillRect(hdcScreen,&rec,br_black);
}
/* attaches bitmaps to their DC */
if (!SelectObject(hdc_work,hbmScreen)) err("Compatible Bitmap Selection");
if (!SelectObject(hdc_sav,hbmScrsave)) err("Compatible Bitmap Selection");

// decide how much & where & when the small sparkles will appear
while(howmuch--) {
/* choose a group of brushes for the sparkle */
colorused=rnd(maxcolors);
br_col1=CreateSolidBrush(colortab[colorused][0]);
br_col2=CreateSolidBrush(colortab[colorused][1]);

// create the pens associated with the colors
pen_col1=CreatePen(PS_SOLID,1,colortab[colorused][0]);
pen_col2=CreatePen(PS_SOLID,1,colortab[colorused][1]);

/* choose a random origin for the sparkle that fits into the screen */
xorg=rnd(v_width-bmpwidth+1)+bl_x;
yorg=rnd(v_height-bmpheight+1)+bl_y;
//xorg=400;yorg=100;

lx=13.0;rx=18.0;
ty=11.0;by=20.0;

nbsmall=rnd(MAXSMALL);
for(i=0;i<nbsmall;i++) {
	smalltab[i].step=rnd(2);
	smalltab[i].age=0;
	smalltab[i].x=rndexcl(6,13,20,25);
	smalltab[i].y=rndexcl(5,9,20,27);
}
/* save initial image */
if (!BitBlt(hdc_sav,0,0,bmpwidth,bmpheight,hdcScreen,xorg,yorg,SRCCOPY))
	err("Screen to Compat Blt Failed");


for (i=0,cur_ell=0;i<8;i++) {
	/* initial image --> working bmp */
	if (!BitBlt(hdc_work,0,0,bmpwidth,bmpheight,hdc_sav,0,0,SRCCOPY))
			err("Screen to Compat Blt Failed");
	 /* draw  into the w. bmp with selected brushes */
	for(j=0;i>0 && j<nbrell[i-1];j++) {
		switch(j) {
		case 0:
		SelectObject(hdc_work,br_col2);
		SelectObject(hdc_work,pen_col2);
		break;

		case 1:
		SelectObject(hdc_work,br_col1);
		SelectObject(hdc_work,pen_col1);
		break;

		case 2:
		SelectObject(hdc_work,br_white);
		SelectObject(hdc_work,pen_white);
		break;
		}
		ell1top_x=tabell[cur_ell][0];
		ell1top_y=tabell[cur_ell][1];
		ell1bot_x=tabell[cur_ell][2];
		ell1bot_y=tabell[cur_ell++][3];
		sprintf(msg,"1-%d %d %d %d",ell1top_x,ell1top_y,ell1bot_x,ell1bot_y);
		//err(msg);
		if(!Ellipse(hdc_work,ell1top_x,ell1top_y,ell1bot_x,ell1bot_y)) err("ellipse");

	}
	//sprintf(msg,"1-%d %d %d %d",crleftx,crrghtx,crtopy,crboty);
		//err(msg);

	crleftx=(int)lx;
	crrghtx=(int)rx;
	crtopy=(int)ty;
	crboty=(int)by;
	SelectObject(hdc_work,pen_white);
	// horizontal line of the X
	MoveToEx(hdc_work,crleftx,y_ctr,NULL);
	LineTo(hdc_work,crrghtx,y_ctr);
	// Vertical line of the X
	MoveToEx(hdc_work,x_ctr,crtopy,NULL);
	LineTo(hdc_work,x_ctr,crboty);
	lx+=delta_left;
	rx+=delta_right;
	ty+=delta_top;
	by+=delta_bot;

	if (!BitBlt(hdcScreen,xorg,yorg,bmpwidth,bmpheight,hdc_work,0,0,SRCCOPY))
			err("Comp to screen Blt Failed");
	Sleep(waste);
	err("press");
}
lx=7.0-delta_left;rx=25.0-delta_right;
ty=3.0-delta_top;by=30.0-delta_bot;

for (etat=0,i=6,cur_ell=14;i>=0;i--,etat++) {
	/* initial image --> working bmp */
	if (!BitBlt(hdc_work,0,0,bmpwidth,bmpheight,hdc_sav,0,0,SRCCOPY))
			err("Screen to Compat Blt Failed");

	// draw the small sparkles if necessary with appropriate colors
	for (ii=0;ii<nbsmall;ii++) {
		x0=smalltab[ii].x;
		y0=smalltab[ii].y;
		if (etat>=smalltab[ii].step) {
			if (smalltab[ii].age<4) SelectObject(hdc_work,pen_white);
			else SelectObject(hdc_work,pen_col1);
			switch (smalltab[ii].age++) {
			case 0:
			case 6:
				MoveToEx(hdc_work,x0,y0,NULL);
				LineTo(hdc_work,x0,y0+1);
				break;
			default:
				MoveToEx(hdc_work,x0,y0-1,NULL);
				LineTo(hdc_work,x0,y0+2);
				MoveToEx(hdc_work,x0-1,y0,NULL);
				LineTo(hdc_work,x0+2,y0);
				break;
			}
			//SetPixel(hdc_work,smalltab[ii].x,smalltab[ii].y,0xffffff);
		}
	}
	 /* draw  into the w. bmp with selected brushes */
	cur_ell-=nbrell[i];
	for(j=0;i>0 && j<nbrell[i-1];j++) {
		switch(j) {
		case 0:
		SelectObject(hdc_work,br_col2);
		SelectObject(hdc_work,pen_col2);
		break;

		case 1:
		SelectObject(hdc_work,br_col1);
		SelectObject(hdc_work,pen_col1);
		break;

		case 2:
		SelectObject(hdc_work,br_white);
		SelectObject(hdc_work,pen_white);
		break;
		}

		ell1top_x=tabell[cur_ell+j+1][0];
		ell1top_y=tabell[cur_ell+j+1][1];
		ell1bot_x=tabell[cur_ell+j+1][2];
		ell1bot_y=tabell[cur_ell+j+1][3];
		sprintf(msg,"2-%d %d %d %d",ell1top_x,ell1top_y,ell1bot_x,ell1bot_y);
		//err(msg);
		if(!Ellipse(hdc_work,ell1top_x,ell1top_y,ell1bot_x,ell1bot_y)) err("ellipse");
	}
	crleftx=(int)lx;
	crrghtx=(int)rx;
	crtopy=(int)ty;
	crboty=(int)by;
	SelectObject(hdc_work,pen_white);
	// horizontal line of the X
	MoveToEx(hdc_work,crleftx,y_ctr,NULL);
	LineTo(hdc_work,crrghtx,y_ctr);
	// Vertical line of the X
	MoveToEx(hdc_work,x_ctr,crtopy,NULL);
	LineTo(hdc_work,x_ctr,crboty);
	lx-=delta_left;
	rx-=delta_right;
	ty-=delta_top;
	by-=delta_bot;

	if (!BitBlt(hdcScreen,xorg,yorg,bmpwidth,bmpheight,hdc_work,0,0,SRCCOPY))
			err("Comp to screen Blt Failed");
	Sleep(waste);
	err("press");
}
// finally clear all
if (!BitBlt(hdcScreen,xorg,yorg,bmpwidth,bmpheight,hdc_sav,0,0,SRCCOPY))
	 err("Comp to screen Blt Failed");
DeleteObject(br_col1);
DeleteObject(br_col2);
DeleteObject(pen_col1);
DeleteObject(pen_col2);
}
if (blackscreen) BitBlt(hdcScreen,bl_x,bl_y,v_width,v_height,hdc_bck,0,0,SRCCOPY);

// free objects & DC
DeleteObject(br_white);
DeleteObject(br_black);
DeleteObject(pen_white);
DeleteObject(pen_black);
DeleteObject(hbmScrsave);
DeleteObject(hbmScreen);
DeleteObject(hbmbck);
DeleteDC(hdc_work);
DeleteDC(hdc_sav);
DeleteDC(hdc_bck);
}
void err(char *ch){
if (debug) MessageBox(0,ch,"ERROR",MB_OK|MB_APPLMODAL);
//exit (1);
}

