
;################################
;# Keymaker for terminate 5.00  #
;#    By JaZZ - June 98         #
;################################

; compile with tasm keygen
; link with tlink /t keygen

.model  small
.code
org	100h
start:          jmp     begin
;----------------------------------------------------------------

;##############################
;Variables used by the keymaker
;##############################

checksum_var1	dw 0 ; to compute the checksum
checksum_var2	dw 0

random_seed1	dw 0 ; base for the xoring generator
random_seed2	dw 0

buf_beg		dw 0 ; address of beginning in terminat_key
buf_end		dw 0 ; address of end
buf_cur		dw 0 ; the current position in a the actual buffer

; buffer for input
max		db 31h
count		db 0
user_string	db 32h dup(0)

; user's parameters
uname		db 32h dup(0)
name_ln		db 0

adr		db 32h dup(0)
adr_ln 		db 0

city		db 32h dup(0)
city_ln 	db 0

country		db 32h dup(0)
country_ln	db 0

terminat_key	db 0f36h dup (0) ; this will be the terminat.key file...
file_name	db 'terminat.key',0
handle		dw 0

;messages
name_msg	db "Terminate 5.0 keymaker for '99 strainer (c) JaZZ"
		db 0ah,0dh, 'Name :','$'
adr_msg		db 0ah,0dh,'address :','$'
city_msg	db 0ah,0dh,'City : ','$'
country_msg	db 0ah,0dh,'Country : ','$'
error_msg1	db 'Error creating terminat.key',0ah,0dh,'$'
error_msg2	db "Can't write to terminat.key",0ah,0dh,'$'
ok_msg		db 'Done !'
eol_msg		db 0ah,0dh,'$'

;####################################################################
; this 1024 bytes area is used by the routine of checksum calculation
;####################################################################



checksum_area:
db 000h, 000h, 000h, 000h, 096h, 030h, 007h, 077h, 02Ch, 061h, 00Eh, 0EEh, 0BAh, 051h, 009h, 099h 
db 019h, 0C4h, 06Dh, 007h, 08Fh, 0F4h, 06Ah, 070h, 035h, 0A5h, 063h, 0E9h, 0A3h, 095h, 064h, 09Eh 
db 032h, 088h, 0DBh, 00Eh, 0A4h, 0B8h, 0DCh, 079h, 01Eh, 0E9h, 0D5h, 0E0h, 088h, 0D9h, 0D2h, 097h 
db 02Bh, 04Ch, 0B6h, 009h, 0BDh, 07Ch, 0B1h, 07Eh, 007h, 02Dh, 0B8h, 0E7h, 091h, 01Dh, 0BFh, 090h 
db 064h, 010h, 0B7h, 01Dh, 0F2h, 020h, 0B0h, 06Ah, 048h, 071h, 0B9h, 0F3h, 0DEh, 041h, 0BEh, 084h 
db 07Dh, 0D4h, 0DAh, 01Ah, 0EBh, 0E4h, 0DDh, 06Dh, 051h, 0B5h, 0D4h, 0F4h, 0C7h, 085h, 0D3h, 083h 
db 056h, 098h, 06Ch, 013h, 0C0h, 0A8h, 06Bh, 064h, 07Ah, 0F9h, 062h, 0FDh, 0ECh, 0C9h, 065h, 08Ah 
db 04Fh, 05Ch, 001h, 014h, 0D9h, 06Ch, 006h, 063h, 063h, 03Dh, 00Fh, 0FAh, 0F5h, 00Dh, 008h, 08Dh 
db 0C8h, 020h, 06Eh, 03Bh, 05Eh, 010h, 069h, 04Ch, 0E4h, 041h, 060h, 0D5h, 072h, 071h, 067h, 0A2h 
db 0D1h, 0E4h, 003h, 03Ch, 047h, 0D4h, 004h, 04Bh, 0FDh, 085h, 00Dh, 0D2h, 06Bh, 0B5h, 00Ah, 0A5h 
db 0FAh, 0A8h, 0B5h, 035h, 06Ch, 098h, 0B2h, 042h, 0D6h, 0C9h, 0BBh, 0DBh, 040h, 0F9h, 0BCh, 0ACh 
db 0E3h, 06Ch, 0D8h, 032h, 075h, 05Ch, 0DFh, 045h, 0CFh, 00Dh, 0D6h, 0DCh, 059h, 03Dh, 0D1h, 0ABh 
db 0ACh, 030h, 0D9h, 026h, 03Ah, 000h, 0DEh, 051h, 080h, 051h, 0D7h, 0C8h, 016h, 061h, 0D0h, 0BFh 
db 0B5h, 0F4h, 0B4h, 021h, 023h, 0C4h, 0B3h, 056h, 099h, 095h, 0BAh, 0CFh, 00Fh, 0A5h, 0BDh, 0B8h 
db 09Eh, 0B8h, 002h, 028h, 008h, 088h, 005h, 05Fh, 0B2h, 0D9h, 00Ch, 0C6h, 024h, 0E9h, 00Bh, 0B1h 
db 087h, 07Ch, 06Fh, 02Fh, 011h, 04Ch, 068h, 058h, 0ABh, 01Dh, 061h, 0C1h, 03Dh, 02Dh, 066h, 0B6h 
db 090h, 041h, 0DCh, 076h, 006h, 071h, 0DBh, 001h, 0BCh, 020h, 0D2h, 098h, 02Ah, 010h, 0D5h, 0EFh 
db 089h, 085h, 0B1h, 071h, 01Fh, 0B5h, 0B6h, 006h, 0A5h, 0E4h, 0BFh, 09Fh, 033h, 0D4h, 0B8h, 0E8h 
db 0A2h, 0C9h, 007h, 078h, 034h, 0F9h, 000h, 00Fh, 08Eh, 0A8h, 009h, 096h, 018h, 098h, 00Eh, 0E1h 
db 0BBh, 00Dh, 06Ah, 07Fh, 02Dh, 03Dh, 06Dh, 008h, 097h, 06Ch, 064h, 091h, 001h, 05Ch, 063h, 0E6h 
db 0F4h, 051h, 06Bh, 06Bh, 062h, 061h, 06Ch, 01Ch, 0D8h, 030h, 065h, 085h, 04Eh, 000h, 062h, 0F2h 
db 0EDh, 095h, 006h, 06Ch, 07Bh, 0A5h, 001h, 01Bh, 0C1h, 0F4h, 008h, 082h, 057h, 0C4h, 00Fh, 0F5h 
db 0C6h, 0D9h, 0B0h, 065h, 050h, 0E9h, 0B7h, 012h, 0EAh, 0B8h, 0BEh, 08Bh, 07Ch, 088h, 0B9h, 0FCh 
db 0DFh, 01Dh, 0DDh, 062h, 049h, 02Dh, 0DAh, 015h, 0F3h, 07Ch, 0D3h, 08Ch, 065h, 04Ch, 0D4h, 0FBh 
db 058h, 061h, 0B2h, 04Dh, 0CEh, 051h, 0B5h, 03Ah, 074h, 000h, 0BCh, 0A3h, 0E2h, 030h, 0BBh, 0D4h 
db 041h, 0A5h, 0DFh, 04Ah, 0D7h, 095h, 0D8h, 03Dh, 06Dh, 0C4h, 0D1h, 0A4h, 0FBh, 0F4h, 0D6h, 0D3h 
db 06Ah, 0E9h, 069h, 043h, 0FCh, 0D9h, 06Eh, 034h, 046h, 088h, 067h, 0ADh, 0D0h, 0B8h, 060h, 0DAh 
db 073h, 02Dh, 004h, 044h, 0E5h, 01Dh, 003h, 033h, 05Fh, 04Ch, 00Ah, 0AAh, 0C9h, 07Ch, 00Dh, 0DDh 
db 03Ch, 071h, 005h, 050h, 0AAh, 041h, 002h, 027h, 010h, 010h, 00Bh, 0BEh, 086h, 020h, 00Ch, 0C9h 
db 025h, 0B5h, 068h, 057h, 0B3h, 085h, 06Fh, 020h, 009h, 0D4h, 066h, 0B9h, 09Fh, 0E4h, 061h, 0CEh 
db 00Eh, 0F9h, 0DEh, 05Eh, 098h, 0C9h, 0D9h, 029h, 022h, 098h, 0D0h, 0B0h, 0B4h, 0A8h, 0D7h, 0C7h 
db 017h, 03Dh, 0B3h, 059h, 081h, 00Dh, 0B4h, 02Eh, 03Bh, 05Ch, 0BDh, 0B7h, 0ADh, 06Ch, 0BAh, 0C0h 
db 020h, 083h, 0B8h, 0EDh, 0B6h, 0B3h, 0BFh, 09Ah, 00Ch, 0E2h, 0B6h, 003h, 09Ah, 0D2h, 0B1h, 074h 
db 039h, 047h, 0D5h, 0EAh, 0AFh, 077h, 0D2h, 09Dh, 015h, 026h, 0DBh, 004h, 083h, 016h, 0DCh, 073h 
db 012h, 00Bh, 063h, 0E3h, 084h, 03Bh, 064h, 094h, 03Eh, 06Ah, 06Dh, 00Dh, 0A8h, 05Ah, 06Ah, 07Ah 
db 00Bh, 0CFh, 00Eh, 0E4h, 09Dh, 0FFh, 009h, 093h, 027h, 0AEh, 000h, 00Ah, 0B1h, 09Eh, 007h, 07Dh 
db 044h, 093h, 00Fh, 0F0h, 0D2h, 0A3h, 008h, 087h, 068h, 0F2h, 001h, 01Eh, 0FEh, 0C2h, 006h, 069h 
db 05Dh, 057h, 062h, 0F7h, 0CBh, 067h, 065h, 080h, 071h, 036h, 06Ch, 019h, 0E7h, 006h, 06Bh, 06Eh 
db 076h, 01Bh, 0D4h, 0FEh, 0E0h, 02Bh, 0D3h, 089h, 05Ah, 07Ah, 0DAh, 010h, 0CCh, 04Ah, 0DDh, 067h 
db 06Fh, 0DFh, 0B9h, 0F9h, 0F9h, 0EFh, 0BEh, 08Eh, 043h, 0BEh, 0B7h, 017h, 0D5h, 08Eh, 0B0h, 060h 
db 0E8h, 0A3h, 0D6h, 0D6h, 07Eh, 093h, 0D1h, 0A1h, 0C4h, 0C2h, 0D8h, 038h, 052h, 0F2h, 0DFh, 04Fh 
db 0F1h, 067h, 0BBh, 0D1h, 067h, 057h, 0BCh, 0A6h, 0DDh, 006h, 0B5h, 03Fh, 04Bh, 036h, 0B2h, 048h 
db 0DAh, 02Bh, 00Dh, 0D8h, 04Ch, 01Bh, 00Ah, 0AFh, 0F6h, 04Ah, 003h, 036h, 060h, 07Ah, 004h, 041h 
db 0C3h, 0EFh, 060h, 0DFh, 055h, 0DFh, 067h, 0A8h, 0EFh, 08Eh, 06Eh, 031h, 079h, 0BEh, 069h, 046h 
db 08Ch, 0B3h, 061h, 0CBh, 01Ah, 083h, 066h, 0BCh, 0A0h, 0D2h, 06Fh, 025h, 036h, 0E2h, 068h, 052h 
db 095h, 077h, 00Ch, 0CCh, 003h, 047h, 00Bh, 0BBh, 0B9h, 016h, 002h, 022h, 02Fh, 026h, 005h, 055h 
db 0BEh, 03Bh, 0BAh, 0C5h, 028h, 00Bh, 0BDh, 0B2h, 092h, 05Ah, 0B4h, 02Bh, 004h, 06Ah, 0B3h, 05Ch 
db 0A7h, 0FFh, 0D7h, 0C2h, 031h, 0CFh, 0D0h, 0B5h, 08Bh, 09Eh, 0D9h, 02Ch, 01Dh, 0AEh, 0DEh, 05Bh 
db 0B0h, 0C2h, 064h, 09Bh, 026h, 0F2h, 063h, 0ECh, 09Ch, 0A3h, 06Ah, 075h, 00Ah, 093h, 06Dh, 002h 
db 0A9h, 006h, 009h, 09Ch, 03Fh, 036h, 00Eh, 0EBh, 085h, 067h, 007h, 072h, 013h, 057h, 000h, 005h 
db 082h, 04Ah, 0BFh, 095h, 014h, 07Ah, 0B8h, 0E2h, 0AEh, 02Bh, 0B1h, 07Bh, 038h, 01Bh, 0B6h, 00Ch 
db 09Bh, 08Eh, 0D2h, 092h, 00Dh, 0BEh, 0D5h, 0E5h, 0B7h, 0EFh, 0DCh, 07Ch, 021h, 0DFh, 0DBh, 00Bh 
db 0D4h, 0D2h, 0D3h, 086h, 042h, 0E2h, 0D4h, 0F1h, 0F8h, 0B3h, 0DDh, 068h, 06Eh, 083h, 0DAh, 01Fh 
db 0CDh, 016h, 0BEh, 081h, 05Bh, 026h, 0B9h, 0F6h, 0E1h, 077h, 0B0h, 06Fh, 077h, 047h, 0B7h, 018h 
db 0E6h, 05Ah, 008h, 088h, 070h, 06Ah, 00Fh, 0FFh, 0CAh, 03Bh, 006h, 066h, 05Ch, 00Bh, 001h, 011h 
db 0FFh, 09Eh, 065h, 08Fh, 069h, 0AEh, 062h, 0F8h, 0D3h, 0FFh, 06Bh, 061h, 045h, 0CFh, 06Ch, 016h 
db 078h, 0E2h, 00Ah, 0A0h, 0EEh, 0D2h, 00Dh, 0D7h, 054h, 083h, 004h, 04Eh, 0C2h, 0B3h, 003h, 039h 
db 061h, 026h, 067h, 0A7h, 0F7h, 016h, 060h, 0D0h, 04Dh, 047h, 069h, 049h, 0DBh, 077h, 06Eh, 03Eh 
db 04Ah, 06Ah, 0D1h, 0AEh, 0DCh, 05Ah, 0D6h, 0D9h, 066h, 00Bh, 0DFh, 040h, 0F0h, 03Bh, 0D8h, 037h 
db 053h, 0AEh, 0BCh, 0A9h, 0C5h, 09Eh, 0BBh, 0DEh, 07Fh, 0CFh, 0B2h, 047h, 0E9h, 0FFh, 0B5h, 030h 
db 01Ch, 0F2h, 0BDh, 0BDh, 08Ah, 0C2h, 0BAh, 0CAh, 030h, 093h, 0B3h, 053h, 0A6h, 0A3h, 0B4h, 024h 
db 005h, 036h, 0D0h, 0BAh, 093h, 006h, 0D7h, 0CDh, 029h, 057h, 0DEh, 054h, 0BFh, 067h, 0D9h, 023h 
db 02Eh, 07Ah, 066h, 0B3h, 0B8h, 04Ah, 061h, 0C4h, 002h, 01Bh, 068h, 05Dh, 094h, 02Bh, 06Fh, 02Ah 
db 037h, 0BEh, 00Bh, 0B4h, 0A1h, 08Eh, 00Ch, 0C3h, 01Bh, 0DFh, 005h, 05Ah, 08Dh, 0EFh, 002h, 02Dh 

;####################
; end of data section
;####################

;----------------------------------------------------------------

;####################################
; this routine , from terminat.exe,
; computes the checksum
; from buf_beg to buf_end included
; (does not init checksum_vars)
;####################################
check_buf	    proc near

		    mov di, buf_beg ; init the beginning position
next_char:		    
		    mov	    al,[di]   ; read char
		    push    ax
		    push    checksum_var2
		    push    checksum_var1
		    pop	    bx
		    pop	    dx
		    pop	    cx
		    push    dx
		    push    bx
		    xor	    bx,	cx
		    xor	    bh,	bh
		    shl	    bx,	1
		    shl	    bx,	1
                    add     bx, offset checksum_area
		    mov	    ax,	[bx]
		    mov	    cx,	[bx+2]
		    pop	    bx
		    pop	    dx
		    push    cx
		    mov	    cx,	8
 shift_again:			    
		    shr	    dx,	1
		    rcr	    bx,	1
		    loop    shift_again
		    and	    dx,	0FFh
		    pop	    cx
		    xor	    ax,	bx
		    mov	    bx,	cx
		    xor	    dx,	bx
		    mov	    checksum_var1, ax
		    mov	    checksum_var2, dx
		    inc     di
		    cmp     di,buf_end
		    jbe	    next_char
		    ret
check_buf	endp

;----------------------------------------------------------------

;#######################################
; this routine calculates a "random" byte
; (extracted from terminat.exe)
;#######################################

random_byte	    proc near		    
		    mov	    ax,	random_seed1
		    mov	    bx,	random_seed2
		    mov	    cx,	ax
		    mov	    dx, 8405h
		    mul	    dx
		    shl	    cx,	1
		    shl	    cx,	1
		    shl	    cx,	1
		    add	    ch,	cl
		    add	    dx,	cx
		    add	    dx,	bx
		    shl	    bx,	1
		    shl	    bx,	1
		    add	    dx,	bx
		    add	    dh,	bl
		    mov	    cl,	5
		    shl	    bx,	cl
		    add	    dh,	bl
		    add	    ax,	1
		    adc	    dx,	0
		    mov	    random_seed1, ax
		    mov	    random_seed2, dx
		    xor	    ax,	ax
		    mov	    bx, 100h
		    or	    bx,	bx
		    jz	    no_zero_div
		    xchg    ax,	dx
		    div	    bx
		    xchg    ax,	dx 
no_zero_div:			    
		    ret
random_byte	    endp

;----------------------------------------------------------------

;##############################
; fill terminat.key with random
; to avoid the pattern checking
; of the author
;##############################

fill_with_rand  proc 	near	
		mov 	ah,2Ch ; get time
		int 	21h
		mov 	random_seed1,cx ; init generator
		mov 	random_seed2,dx ; with seconds & hundredths
		mov 	cx, 0f36h       ; terminat.key size
		mov	di, offset terminat_key
fill_again:
		push	cx
		call	random_byte	; result in al
		pop 	cx
		mov 	[di], al
		inc	di
		loop 	fill_again
		ret
fill_with_rand	endp	

;----------------------------------------------------------------

input_user_data proc near
empty_name:
		mov     ah,09H                  ; input user name
		mov	dx,offset name_msg
		INT     21H
		mov	ah,0Ah
		mov	dx,offset max
		int	21h
		mov 	cl,count
		xor	ch,ch
		or 	cx,cx
		je 	empty_name
		mov 	name_ln,cl
		mov 	si,offset user_string
		mov 	di,offset uname
		cld
		repnz 	movsb
empty_adr:
		mov     ah,09H                  ; input user adr
		mov	dx,offset adr_msg
		INT     21H
		mov	ah,0Ah
		mov	dx,offset max
		int	21h
		mov 	cl,count
		xor	ch,ch
		or 	cx,cx
		je 	empty_adr
		mov	adr_ln, cl
		mov 	si,offset user_string
		mov 	di,offset adr
		repnz 	movsb
empty_city:
		mov     ah,09H                  ; input user city
		mov	dx,offset city_msg
		INT     21H
		mov	ah,0Ah
		mov	dx,offset max
		int	21h
		mov 	cl,count
		xor	ch,ch
		or 	cx,cx
		je 	empty_city
		mov 	city_ln, cl
		mov 	si,offset user_string
		mov 	di,offset city
		repnz 	movsb
empty_country:
		mov     ah,09H                  ; input user country
		mov	dx,offset country_msg
		int     21h		
		mov	ah,0Ah
		mov	dx,offset max
		int	21h
		mov 	cl,count
		xor	ch,ch
		or 	cx,cx
		je 	empty_country
		mov 	country_ln, cl
		mov 	si,offset user_string
		mov 	di,offset country
		repnz 	movsb
		mov     ah,09H                  ; input user country
		mov	dx,offset eol_msg
		int     21h		
		ret
input_user_data endp

;----------------------------------------------------------------
; copy the user data at the right place in terminat.key
;----------------------------------------------------------------
copy_user_data	proc near
		mov	di,426h ; beginning of 4th buffer in terminat_key
		add 	di,offset terminat_key
; name to 426+7A
		mov	cl,name_ln
		xor 	ch,ch
		mov	[di+7ah],cl
		push 	di
		add	di,7Bh
		mov	si, offset uname
		repnz	movsb
		pop 	di
; adr to 426+AE
		mov	cl,adr_ln
		xor 	ch,ch
		mov	[di+0ADh],cl
		push 	di
		add	di,0AEh
		mov	si, offset adr
		repnz	movsb
		pop 	di
; city to 426+E1
		mov	cl,city_ln
		xor 	ch,ch
		mov	[di+0E0h],cl
		push 	di
		add	di,0E1h
		mov	si, offset city
		repnz	movsb
		pop 	di
; country to 426+114
		mov	cl,country_ln
		xor 	ch,ch
		mov	[di+113h],cl
		push 	di
		add	di,114h
		mov	si, offset country
		repnz	movsb
		pop 	di		
		ret						
copy_user_data  endp

;----------------------------------------------------------------
; put a correct checksum in buf #4 before encrypting.
; besides, this checksum is also used to set the last two
; bytes of buffer #5 to their right value.
;----------------------------------------------------------------
 
checksum_4	proc near
		mov	di,0426h ; beg. of 4th buffer
		add 	di,offset terminat_key
		push 	di
		add	di,5Bh	 ; the "sensible" area starts here
		mov	buf_beg,di
		add	di,102h
		mov	buf_end,di
		mov	checksum_var2,0FFFFh
		mov	checksum_var1,0FFFFh		
		call	check_buf ; result in the above vars
		pop	di
		mov 	ax, checksum_var1
		mov	[di+15Eh], ax
		mov 	bx, checksum_var2
		mov	[di+160h], bx
		add	di,162h   ; fseek to  buffer#5
		sub	ax,0ah
		mov	[di+15Eh], ax ; set these IMPORTANT values...
		mov	[di+160h], bx
		ret
checksum_4	endp

;----------------------------------------------------------------
; initialize the "xoring value generator" then encrypt
; successively  four times
;----------------------------------------------------------------
encrypt_4_times proc near
		mov 	ax,904h
		mov	random_seed1, ax
		mov 	ax,33EEh
		mov	random_seed2, ax
		call 	encrypt_one_buf
		mov 	ax,325Ch
		mov	random_seed1, ax
		mov 	ax,0
		mov	random_seed2, ax
		call 	encrypt_one_buf
		mov 	ax,7
		mov	random_seed1, ax
		mov 	ax,0
		mov	random_seed2, ax
		call 	encrypt_one_buf
; finally xor the area with 0ffh
		mov	di,0426h ; beg. of 4th buffer
		add 	di,offset terminat_key
		add	di,5Bh	 ; the "sensible" area starts here
		mov	cx,107h  ; only the range [5B,161] is xored
xor_again:		
		mov	al,[di]
		xor	al,0ffh
		mov	[di], al
		inc 	di
		loop	xor_again
		ret		
encrypt_4_times endp
;----------------------------------------------------------------

encrypt_one_buf	proc near
		mov	di,0426h ; beg. of 4th buffer
		add 	di,offset terminat_key
		add	di,5Bh	
		mov	cx,107h  ; only the range [5B,161] is xored
encore:		
		push	cx
		call 	random_byte  ; generates the next xoring value
		pop 	cx
		mov 	bx,[di]
		xor	ax,bx
		mov	[di],ax
		inc di
		loop encore
		ret		
encrypt_one_buf	endp

;-----------------------------------------------------------------------
; performs the checksum on bytes [0,15D] ( length=15Eh) on all 0B buffers
; then store it in 15E relative address of the last buffer
;-----------------------------------------------------------------------

general_check	proc near
		mov	cx,0bh ; nbr of buffer to work on.
		mov 	di,offset terminat_key
		mov	checksum_var2,0FFFFh
		mov	checksum_var1,0FFFFh		
next_one:		
		push 	di
		push	cx
		mov	buf_beg,di
		add	di,15Dh
		mov	buf_end,di
		call	check_buf ; result in the above vars
		pop 	cx
		pop	di
		add	di,162h ; buffer size
		loop	next_one
		mov 	ax,checksum_var2
		mov	[di-2],ax
		mov 	ax,checksum_var1
		mov	[di-4],ax
		ret
general_check	endp

;----------------------------------------------------------------
; copy terminat_key to terminat.key on the HD
;----------------------------------------------------------------

save_keyfile	proc near
		mov 	dx,offset file_name
		mov 	ah,3ch
		xor	cx,cx
		int 	21h ; open the file for writing
		jc	error_open
		mov	bx,ax
		mov 	handle, ax
		mov	ah,40h
		mov	cx, 0f36h
		mov	dx, offset terminat_key
		int 	21h    ; write it!
		jc 	error_write
		cmp	ax,cx
		jne	error_write
		mov 	bx, handle
		mov	ah,3eh
		int 	21h   ; close handle
		mov     ah,09H
		mov	dx,offset ok_msg  ; if everything 's OK...
		int     21h		
		ret
error_open:		
		mov     ah,09H
		mov	dx,offset error_msg1
		int     21h		
		ret
error_write:		
		mov     ah,09H                
		mov	dx,offset error_msg2
		int     21h		
		ret
save_keyfile	endp
;----------------------------------------------------------------

;##############################
;#     - main program -       #
;##############################
begin           PROC    near
		mov 	ax,cs ; init ds....
		mov	ds,ax
		mov 	es,ax
		call 	fill_with_rand
		call 	input_user_data
		call	copy_user_data
		call	checksum_4
		call	encrypt_4_times
		call	general_check
		call	save_keyfile
		mov	ax,4c00h
		int 	21h ; quit to dos
begin           ENDP
		END     START  
;----------------------------------------------------------------
		              
	              
