def clock(): return time_time()
def time(): return time_time()
def gmtime(fsecs): return time_gmtime(fsecs)
def localtime(fsecs): return time_localtime(fsecs)
def mktime(tm): return time_mktime(tm)
def sleep(isecs): return time_sleep(isecs)
def asctime(tm): return time_asctime(tm)
def ctime(fsecs): return asctime(localtime(fsecs))
daylight=0 # cheat
altzone=0
timezone=0
tzname=("UTC","UTC")

# Warning: this data requires internationalisation
_abbrev_weekday = ("Sun","Mon","Tue","Wed","Thu","Fri","Sat")
_weekday = ("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday")
_abbrev_month = (
  "Jan", "Feb","Mar","Apr","May","Jun",
  "Jul","Aug","Sep","Oct","Nov","Dec")
_month = (
  "January", "February","March","April","May","June",
  "July","August","September","October","November","December")

def _digits(x): return ("00"+str(x))[-2:]

def _twelve_hour(hour):
  x = hour % 12
  if x == 0: x = 12
  return x

def _ampm(hour):
  if hour < 12: return "am"
  else: return "pm"

def _AMPM(hour):
  if hour < 12: return "AM"
  else: return "PM"
  
def strftime(fmt,tm):
  year, month, day, hour, min, sec, weekday,julian,daylight = tm
  s = ""
  i=0
  while i< len(fmt):
    if fmt[i]<>'%': 
      s = s + fmt[i]
      i = i + 1
      continue
    i = i + 1
    if i==len(fmt):
      raise ValueError,"strftime bad format"
    c = fmt[i]
    i = i + 1
    if c == 'a': s = s + _abbrev_weekday[weekday]
    elif c == 'A': s = s + _weekday[weekday]
    elif c == 'b': s = s + _abbrev_month[month-1]
    elif c == 'B': s = s + _month[month-1]
    elif c == 'c': s = s + str(hour)+":"+str(min)+":"+str(sec)+" "+str(day)+"/"+str(month)+"/"+str(year)
    elif c == 'd': s = s + _digits(day)
    elif c == 'H': s = s + _digits(hour)
    elif c == 'I': s = s + _twelve_hour(hour)
    elif c == 'j': s = s + str(julian)
    elif c == 'm': s = s + _digits(month)
    elif c == 'M': s = s + _digits(min)
    elif c == 'p': s = s + _ampm(hour)
    elif c == 'P': s = s + _AMPM(hour)
    elif c == 'S': s = s + _digits(sec)
    elif c == 'U': s = s + str((julian-weekday)/7)
    elif c == 'w': s = s + str(weekday)
    elif c == 'W': s = s + str((julian-weekday+1)/7)
    elif c == 'x': s = s + _digits(day) + " " + _abbrev_month[month]+ ", " + str(year)
    elif c == 'X': s = s + _digits(hour) + ":"+_digits(min)+":"+_digits(sec)
    elif c == 'y': s = s + str(year)[-2:]
    elif c == 'Y': s = s + str(year)
    elif c == 'Z': s = s + "UTC"
    elif c == '%': s = s + "%"
    else: raise ValueError,"time.strftime bad format code"
  return s

#strptime not defined :-(

