# test viper lexer and parser: none of the code will execute!
x = 0
x = 1
x = 123

x = 0b1000
x = 0xFF
x = 0d99
x = 0o77
x = 077
x = 1_2_3
x = 0x_100

x = 1L
x = 0b1000L
x = 0xFFL
x = 0d99L
x = 0o77L
x = 077L
x = 1_2_3L
x = 0x_100L

x = (1,2)
x = (1,)
x
x = 1
x = y = 1
x = 1,2
x = a,b = 3,4
x = 1, = 2
#a comment
  #another comment

  #more
 #comments

#are here with weird (!@#$%^&*()) characters
/* now test C comments */
/* they can flow over lines too
   like this, we should check
   that line counting is done right by incluing lots of lines
   here */
if /* but be careful */ 1:
  /* indented THREE spaces */ x = 1
   x = 1 /* C comments are elided completely */

/* Now we check /* nested comments */ are handled */
'doc string'
"doc string"

x = "" # a null string
x = '' # a null string
x = """""" # null string
x = '''''' # null string

x = "a string"
x = 'a string'
x = ''' a 
string '''
x = """ a
string """
z = """ problem finding longest match!! """
x = '\n'
x = '\t\r\n'
x = '\t\n\r\v\f'

signifiedoctal = '\o101' # A
signfieddecimal = '\d66' # B
signifiedhex = '\x43'    # C
defaultoctal = '\104'    # D
unicode = '\u0045'       # E
iso10646 = '\U00000046'  # F
all = '\o101\d66\x43\104\u0045\U00000046'

x = 'ab\'cd'
x = r'ab\'cd'

class X:
	""" 
 
	with some indentation! 
   
and funny stuff ...
   """

	" and more appended in a token (but not a pre-token? "

# expression statements (Assign)
x = 1; x = 1
x = 1; x = 1   
x = 1; x = 1   # comment
x = 1; x = 1;
x = 1; x = 1;     
x = a ** b
x = a and b or c + d * e / x & q << l
del x
del x[...]

del x[x:x:x]
del x[x:x:]
del x[x::x]
del x[:x:x]
del x[x::]
del x[:x:]
del x[::x]
del x[::]

del x[x:x]
del x[x:]
del x[:x]
del x[:]
del x[x]

# tuples, lists and dictionaries
x = [1,2,3]
x = (1,2,3)
x = {1:1,2:2,3:3}

x = [1,2,3,]
x = (1,2,3,)
x = {1:1,2:2,3:3,}

x = [1,
 2,3,]
x = (1,
 2,3,)
x = {1:1,
 2:2,3:3,}

x = [1,
 2,3,
 ]
x = (1,
 2,3,
 )
x = {1:1,
 2:2,3:3,
 }

# expressions
x = 1; x = 1;     # comment
x = (y,)
x = a ** v ** a
x = a ** (v ** a)
x = (a ** v) ** a
x = a << b >> c & d << s
#x = y,
(x,y,) = (1,2)

(x,y,) = (1,2)
# comment
  # comment
t = \
  1
r = \   
  1
(x,y,) = (1,2)
x = 2
x = z or b and c and u == 1
a and b or c and d
a and (b or c) and d
a or b and c or d
a or (b and c) or d

# ---------------------------------------
# small statements

# pass statement
pass

# del statement
del x
del x,x
del x,x,x

# raise statement
raise
raise x
raise x,x
raise x,x,x

# return statement
return x
return x,x
return x,x,x

# import statement
import x
import x.x
from x import x
from x import x,x
from x.x import x
from x.x import x,x
from x import *

# global statement
global x
global x,x

# exec statement
exec x
exec x in x
exec x in x,x

# print statement
print x
print x,

# continue statement
continue

# break
break

# assert statement
assert x
assert x, y

# -----------------------------
# compound statements

# while statement
while 1 : pass 
while 1 : x = 1
while 2:
  x = 2

while a: pass
else: pass

# if statement
if x:
  pass

if x:
  pass
else:
  pass

if x:
  pass
elif x:
  pass
else:
  pass

if x == 1 or y == 2:
  x = 1

# for statement
for a in b: pass
for a,b in b: pass
for a, in b: pass
for a,b, in b: pass
for (a) in b: pass
for (a,) in b: pass
for (a,b) in b: pass
for (a,b,) in b: pass

for x in a : pass
for x in a,b: pass
for x in a,: pass
for x in a,b,: pass
for x in (a): pass
for x in (a,): pass
for x in (a,b): pass
for x in (a,b,): pass

for a in b: pass
else: pass


# try statement
try:
  pass
except x:
  pass
except y:
  pass
except x,x:
  pass
except:
  pass
else:
  pass

try:
  pass
else:
  pass

try:
  pass
except:
  pass

try:
  pass
finally:
  pass


# def statement
def f(x): pass
def f(x,y,z): 
  pass

def f(x,y,): pass
def f(*a): pass
def f(**a): pass
def f(x=1, y=2): pass

def f(x,**a): pass
def f(x,*a): pass
def f(x,*a, **a): pass

# class statement
class X:
  x = 1

class Y(X):
  x = 1

class Y(X,Y,x+y):
  x = 1

# ----------------------------
# more complex mixtures

while 1:
  for i in y:
    del x

pass

import sgmllib
import re
import string
import os
import copy_reg 
import dbhash
import exceptions
import dump
import tokenize
import traceback
import getopt

