import sys
try:
  import types
  print "types imported"
except:
  print "Error importing module types"
  print sys.exc_info()

print "abs"
assert abs(-1) == 1
assert abs(-1.0) == 1.0
assert abs (1j) == 1.0

print "apply"
def f(x,y): return x+y
assert apply(f,(1,2)) == 3
assert apply(abs, (-1,)) == 1

print "callable"
assert callable (f)
assert not callable (1)

print "chr"
assert chr(65) == "A"

print "cmp"
assert cmp(1,2) < 0
assert cmp("Hello", "HELLO") > 0
assert cmp(f,f) == 0
assert cmp(1,1) ==0
assert cmp("x","x") ==0
class X: pass 
class Y: pass
x = X()
y = Y()
assert cmp(x,y) != 0
assert cmp(x,y) == -cmp(y,x)

print "coerce"
assert coerce(1, 2.0, 3, 4.0) == (1.0,2.0,3.0,4.0)

print "compile"
print "compile - exec form"
s = """x = 1; y = 2; print x,y
"""
cs = compile(s,"dummy","exec")
print cs

print "compile - eval form"
s = "1+2"
cs = compile(s,"dummy","eval")
print cs

print "complex"
z = complex(1,1)
print complex(1), complex(1.0), complex (z,z)
assert complex(1) == 1

print "delattr"
class F:
  x = 1
  q = "q"
f = F()
f.y = 2
f.qq = "qq"

delattr(F,"x")
delattr(f,"y")

print "dir"
print dir()
print dir(F)
print dir(f)

print "divmod"
assert divmod(9,4) == (2,1)
assert divmod(9.0,4.0) , (2.0,1.0)
result = divmod(9.0,4.1)
assert result[0] == 2.0 
assert result[1] - 0.8 < 1E-10

print "eval"
assert eval("1") == 1
x = 1
y = 2
assert eval("x+y") == 3
# eval won't take a code object yet

print "execfile"
execfile("tests/t_builtins2.py")

print "filter"
seq = [1,2,3,4,0]
print seq
print filter(None, seq)
assert filter(None,seq)==[1,2,3,4]
assert filter(None,tuple(seq))==tuple([1,2,3,4])
assert filter(None,"Hello") == "Hello"
def iseven(x): return (x % 2) == 0
assert filter(iseven,seq)==[2,4,0]
def isupper(x): return x >= "A" and x <= "Z"
assert filter(isupper,"HellO") == "HO"

print "float"
assert float("1.2")==1.2
assert float(1)==1.0
assert float(1.2)==1.2

print "getattr"
class Q: 
  x = 1
assert getattr(Q,"x") == 1
assert getattr(Q,"y",2) == 2


print "globals- not implemented"

print "hasattr"
assert hasattr(Q,"x")
assert not hasattr(Q,"y")

print "hash"
print hash (1)
print hash (Q)

print "hex"
print hex(22)
print hex(-22)

print "id- not implemented"
print "input- not implemented"
print "intern- not implemented"

print "int"
assert int("1")==1
assert int(1.0)==1

print "isinstance- not implemented"
class Y: pass
y = Y()
assert isinstance (y, Y)

print "issubclass"
class B: pass
class D(B): pass
assert issubclass(D,B)

print "len"
assert len ([1,2,3]) == 3
assert len (xrange(0,10)) == 10
assert len (xrange(0,10,2)) == 5
assert len (xrange(10,0,-2)) == 5

print "list"
assert list((1,2,3)) == [1,2,3]
assert list ("Hello") == ["H","e","l","l","o"]

print "locals"
print locals()
def f(x):
  y = 2
  return locals()
assert f(1) == {"x":1,  "y":2 }

print "long- not implemented"

print "map"
def f(x): return x + 1
assert map(f, [1,2,3]) == [2,3,4]

print "max"
assert max((1,2,200,32,4,-3,77)) == 200 
print "min"
assert min((1,2,32,4,-3,77)) == -3

print "oct"
print oct(22)
print oct(-22)
print oct(-1)

print "open"
f = open("tests/t_builtins.py","r")
print f
print f.readline()
f.close()

print "--------------- readline ------------"
f = open("tests/t_builtins.py","r")
lineno = 1
try:
  try:
    while lineno < 10: 
      print lineno,f.readline()[0:-1]
      lineno = lineno + 1
    while f.readline(): pass
  except:
    print "Unexpected error"
    print sys.exc_info()[0]
    print sys.exc_info()[1]
    print sys.exc_info()[2]
finally:
  f.close()
print "--------------- readlines ------------"
f = open("tests/t_builtins.py","r")
try:
  print f.readlines()[0:10]
finally:
  f.close()

print "ord"
for i in xrange(0,255):
  assert ord(chr(i)) == i

print "pow- not implemented"

print "range"
assert range(3)[0]==0
assert range(3,10)[1]==4
print range(3,10,2)
print range(3,10,2)[1]
assert range(3,10,2)[1]==5
assert range(1,-2,-1) == [1,0,-1]
assert range(1,10)[2:4] == [3,4]

print "raw_input- not implemented"
print "reduce"
x = [1,2,3,4]
def add(x,y): return x + y
assert reduce(add, x) == 10
assert reduce(add, x, 20) == 30
assert reduce(add, [], 20) == 20
assert reduce(add, [1], 20) == 21
assert reduce(add, [1]) == 1

print "repr"
print "Repr ('hello')=",repr('hello')

print "round"
eps = 2.0 ** (-10)
def zero(x): return abs(x) < eps

assert zero(round(1.2)-1)
assert zero(round(-1.2)+1)
assert zero(round(1.21,1)-1.2)
assert zero(round(-1.21,1)+1.2)

print "setattr"
class Q: pass
setattr(Q,"a",1)
assert Q.a == 1
q = Q()
setattr(q,"b",1)
assert q.b == 1
assert q.a == 1

print "slice- not implemented"

print "str"
print "str (1) =",str(1)

print "tuple"
assert tuple([1,2,3]) == (1,2,3)
assert tuple("Hello") == ("H","e","l","l","o")

print "type"
assert type(1) is types.IntType

print "uchr and uord"
for i in xrange(0,2500):
  assert uord(uchr(i)) == i

print "vars"
d = {1:1, 2:2}
class VarTest:
  vt1 = 1
vt2 = VarTest()
vt2.vt3 = 3
assert vars(d) == d
assert vars(VarTest) == {"vt1":1}
assert vars(vt2) == {"vt3":3}

print "xrange"
assert xrange(3)[0]==0
assert xrange(3,10)[1]==4
assert xrange(3,10,2)[1]==5
assert list(xrange(1,-2,-1)) == [1,0,-1]
assert list(xrange(1,10)[2:4]) == [3,4]
j = 1
for i in xrange(1,4): assert i == i; j = j + 1

print "VIPER EXTENSIONS"
print erepr(compile("x+y","dummy","eval"))

print dir()
print vars()

print "builtins OK"

