#print "EXECUTING PY_TYPES.PY"

# This module is exclusive to Viper
# It is a builtin module, defining classes for all
# the Python types.
#
# Methods and attributes for objects can be found in the
# class dictionary of the typing class, even when the object
# is not a PyInstance of the class.
import string
import sys

# datum types
class PyIntType : 
  def succ(x): return x + 1
  def pred(x): return x - 1

class PyFloatType : pass
class PyComplexType : pass
class PyLongType : pass
class PyRationalType : pass
class PyStringType: pass

# Sequence types
class PyNoneType: pass
class PyTupleType : pass
class PyListType : 
  append = list_append
  extend = list_extend
  count= list_count
  index = list_index
  insert = list_insert 
  sort = list_sort

# Others 
class PyClassType: pass
PyTypeType = PyClassType # an alias in Viper
class PyInstanceType: pass

# Viper doesn't currently support execution frames, so tb_frame is set to None
class PyTracebackType:
  tb_frame = None

class PyFunctionType: pass
class PyModuleType: pass
class PyNativeFunctionType: pass
class PyBoundMethodType: pass
class PyDictionaryType:
  items = dictionary_items
  clear = dictionary_clear
  copy = dictionary_copy
  has_key = dictionary_has_key
  keys = dictionary_keys
  update = dictionary_update
  values = dictionary_values
  get = dictionary_get

class PyExpressionType: pass
class PyEnvironmentType: pass
class PyXrangeType: pass

# this is type of _native_ files
class PyFileType:
  def close(f): file_close(f)
  def write(f,s): file_write(f,s)
  def flush(f): file_flush(f)

  # note: never raises an exception, does nothing at EOF
  def read(f,amt=None):
    try:
      if amt is None:
        s = ""
        while 1:
          b = file_read(f,8096)
          s = s + b
          if len(b) < 8096: break
        return s 
      else:
        s= file_read(f,amt)
        return s
    except: print "EXCEPTION: IOERROR"

# this is the class used for _client_ files
# we use a class, to support easy subtyping
class PyFileClass: 
  def __init__(self): 
    self.buffer = ""
  
  def read(self,amt=None): 
    return self.native_file.read(amt)
  
  def write(self,s): 
    return self.native_file.write(s)
  def close(self): 
    self.closed = 1
    self.native_file.close()

  # note: returns '' on end of file (no exception raised)
  def readline(self):
    eolpos = string.find(self.buffer, "\n")
    while eolpos == -1:
      n = len(self.buffer)
      data = self.read(1024)
      self.buffer = self.buffer + data
      eolpos = string.find(self.buffer, "\n", n)
      if len(data) == 0: break
    if eolpos == -1: eolpos = len(self.buffer)-1
    line = self.buffer[0:eolpos+1] # include the eol
    self.buffer = self.buffer[eolpos+1:]
    return line

  def readlines(self, hint=None):
    data = self.native_file.read()
    return string.split(data,'\n')

# this function opens a file
def open(filename, mode="r"):
  try:
    native_file = file_open(filename, mode)
    python_file = PyFileClass()
    python_file.native_file = native_file
    python_file.name = filename
    python_file.mode = mode 
    python_file.closed = 0
    return python_file
  except OSError, object:
    exc = IOError(object.errno, object.strerror, filename)
    raise exc

def make_file_object(native_file, filename, mode):
  python_file = PyFileClass()
  python_file.native_file = native_file
  python_file.filename = filename
  python_file.mode = mode
  python_file.closed = 0
  return python_file

# these functions return _native_ files, not client ones!
def get_native_stdin(): return file_get_std_files()[0]
def get_native_stdout(): return file_get_std_files()[1]
def get_native_stderr(): return file_get_std_files()[2]

# these functions return _client_ files!
def get_client_stdin(): return make_file_object(get_native_stdin(),"stdin","r")
def get_client_stdout(): return make_file_object(get_native_stdout(),"stdout","w")
def get_client_stderr(): return make_file_object(get_native_stderr(),"stderr","w")

# this is a hack!
def set_std_files():
  sys.stdin = sys.__stdin__ = get_client_stdin()
  sys.stdout = sys.__stdout__ = get_client_stdout()
  sys.stderr = sys.__stderr__ = get_client_stderr()

# this is a sucky hack!
def type(x): 
  typename = getattr(x,"__typename__")
  return eval (typename)

