open Py_types

let bindarg f a = 
  let g () = f a in g
;;

(* get every variable name used in an expression *)
let get_variables e =
  let rec get e' : string list  = 
    let get_comparator_variables c = match c with 
    | Less x -> get x
    | Greater x -> get x
    | LessEqual x -> get x 
    | GreaterEqual  x -> get x 
    | Equal x -> get x 
    | NotEqual x -> get x 
    | Is x -> get x 
    | IsNot x -> get x 
    | In x -> get x 
    | NotIn x -> get x 
    and get binop_variables b = match b with
    | Sub x -> get x
    | Mul x -> get x
    | Div x -> get x
    | Mod x -> get x
    | Asl x -> get x
    | Lsr x -> get x
    | Pow x -> get x

    in match e' with 
    | PyName name -> print_endline ("Variable " ^ name); [name]
    | PyTuple x -> List.concat (List.map get x)
    | PyList x -> List.concat (List.map get x) 
    | PyDict x -> print_endline "DICT?"; []
    | Or x -> List.concat (List.map get x )
    | And x -> List.concat (List.map get x )
    | Not x -> get x 
    | Neg x -> get x
    | Compare (x, cl) -> List.concat ((get x) :: (List.map get_comparator_variables cl))
    | BitOr x -> List.concat (List.map get x ) 
    | BitAnd x -> List.concat (List.map get x ) 
    | BitXor x -> List.concat (List.map get x ) 
    | Complement x -> get x
    | Eval (x, bl) -> List.concat ((get x) :: (List.map get_binop_variables cl)) 
    | Lambda (p,x) -> [] (* Note lambda variables are not visible!?? *)
    | AtomWithTrailers (ee, tr) -> 
      print_string  "WHAT TO DO? ";
      Py_print.print_expression 0 e';
      print_endline "??"; []
    | _ -> (* raise (SemanticError "Assign to Non variable") *)
      print_string "WHAT IS THIS? ";
      Py_print.print_expression 0 e';
      print_endline "??"; []
  in get e
;;

let list_sub l start n = 
  let x = ref [] in
  for i=start to (start + n - 1) do
    x :=!x @ [(List.nth l i)]
  done;
  !x
;;

let rec get_parameters_from_param_name (pn:param_name_t) = 
  match pn with
  | Param s -> [s]
  | Paramtuple ps' -> List.concat (List.map get_parameters_from_param_name ps')
;;

let get_parameters_from_parameter (p:parameter_t) = 
  get_parameters_from_param_name 
    begin match p with
    | Parameter2 (pn, _) -> pn
    | Parameter1 pn -> pn
    end
;;

let get_parameters_from_parameter_list (ps:parameter_t list) = 
  List.concat 
    (List.map get_parameters_from_parameter ps)
;;

let get_parameters_from_parameters (ps:parameters_t) = 
match ps with (pl, star, star2) ->
  (get_parameters_from_parameter_list pl)
  @ (match star with | StarParam n -> [n] | _ -> [])
  @ (match star2 with | StarStarParam n -> [n] | _ -> [])
;;


let rec check_assignment (env: (string, Py_types.expr_t) Hashtbl.t list) s =
  let pe = Py_print.print_expression 0 in
  let p' s = bindarg print_string s in
  let pcommalist pv x = Py_print.plist (p' "") (p' ", ") (p' "") pv x in
  let pes = pcommalist pe in
  let nl = bindarg print_endline "" in
  let rec ca s : unit =
    match s with
    | While (_, s1, s2)      -> (ca s1) ; (ca s2)
    | For (tl1, _, s1, s2)  ->
       ca 
    | TryFinally ( s1, s2)  -> (ca s1) ; (ca s2)
    | TryElse ( s1, hl, s2) -> (ca s1) ; (ca s2)
    | Suite ( ss1 )         -> List.iter  ca ss1
    | If (ess, s2)       -> 
      List.iter (fun x -> ca (snd x)) ess; 
      ca s2 
    | Class (n,e,st) -> 
      let __dict__ = Hashtbl.create 97 in
        check_assignment (__dict__ :: env) st;
        Hashtbl.add (List.hd env) n (PyClass (n,e,__dict__))
    | Def (n,ps,st) -> 
      let __dict__ = Hashtbl.create 97 in
        List.iter 
          (fun x -> Hashtbl.add __dict__ x Unknown)
          (get_parameters_from_parameters ps)
        ; 
        check_assignment (__dict__ :: env) st;
        Hashtbl.add (List.hd env) n (PyFunction (n,ps,__dict__, st))

    | Assign ( l ) ->
      let n = List.length l in 
      begin 
        let rhs = List.nth l (n-1) in
          let value = 
            try Py_eval.py_eval env rhs 
            with 
            | Py_eval.AttributeError _ -> rhs
            | Py_eval.UnknownError _ -> rhs
          in

          List.iter 
          begin fun x ->
            match x with
            | PyName n -> 
              Hashtbl.add (List.hd env) n value
            | _ -> print_endline "COMPLEX LHS (s).."
          end
          (list_sub l 0 (n-1))
      end
    | Del ( tl ) ->
      print_string "DEL "; pe tl; nl(); 
    | _ -> ()
  in ca s
;;


