open Py_parse;;
open Py_types;;

(* THIS MODULE WILL BE DEPRECATED: use repr, erepr, or str
  to convert an expression or statement to a strig,
  then print it. We need to first soup up these functions,
  to allow for indentation
*)

let plist before between after element x =
  before();
  begin match x with
  [] -> () 
  | h :: t ->
    element h;
    let f x = between(); element x in
      List.iter f t
  end;
  after()
;;

let indent = ref 0;;
let atlinestart = ref true;;
let reset () =
  indent :=0;
  atlinestart := true;;

let pi indent x = 
  if !atlinestart then begin 
    for i=1 to indent do print_string "  " done
  end;
  atlinestart := false;
  print_string x 
let nl() = print_endline ""; flush stdout; atlinestart := true;;

let rec print_parameters level ps = 
  let p = pi level in
  let p' x () = p x  in
  let pe e = print_expression level e in
  let rec pparam_name n = match n with
  | Param s -> p s
  | Paramtuple tup ->
    p "(";
    List.iter (fun x -> pparam_name x; p ", ") tup;
    p ")"
  in 
  let pparam x = match x with
  | Parameter2 (pn,e) -> pparam_name pn; p " = "; pe e
  | Parameter1 pn -> pparam_name pn
  in
    match ps with (op, sp, ssp) ->
    plist (p' "") (p' ", ") (p' "") pparam op;
    let comma_needed = ref ((List.length op) <> 0) in
      begin match sp with
      | NoStarParam -> ()
      | StarParam s -> 
        if !comma_needed then p ", ";
        p "*"; p s; 
        comma_needed := true
      end;
      begin match ssp with
      | NoStarStarParam -> ()
      | StarStarParam s -> 
        if !comma_needed then p ", ";
        p "*"; p s; 
      end

and print_expression level e = 
  let pe = print_expression level in
  let p = pi level in
  let p' x () = p x  in
  let pparameters ps = print_parameters level ps in 
  let psubentry x = match x with 
  | Defsub -> ()
  | Pos e -> pe e
  in let psub x = 
  match x with
  | Ellipsis -> p "[...]"
  | Subscript2 (a,b,c) -> 
    p "["; 
    psubentry a; 
    p ":"; 
    psubentry b; 
    p ":"; 
    psubentry c; 
    p "]"
  | Subscript1 (a,b) -> 
    p "["; 
    psubentry a; 
    p ":"; 
    psubentry b; 
    p "]"
  | Subscript0 a -> 
    p "["; 
    psubentry a; 
    p "]"
  in let pcomparator x = 
    match x with 
    | Less e   -> p " < "; pe e
    | Greater e -> p " > "; pe e
    | LessEqual e -> p " <= "; pe e
    | GreaterEqual e-> p " >= "; pe e
    | Equal e-> p " == "; pe e
    | NotEqual e -> p " != "; pe e
    | Is e -> p " is "; pe e
    | IsNot e-> p " is not "; pe e
    | In e -> p " in "; pe e
    | NotIn e -> p " not in "; pe e

  in let pbinop x = 
    match x with 
    | Add e   -> p " + "; pe e
    | Sub e -> p " - "; pe e
    | Mul e -> p " * "; pe e
    | Div e-> p " / "; pe e
    | Mod e-> p " % "; pe e
    | Asl e -> p " << "; pe e
    | Lsr e -> p " >> "; pe e
    | Pow e -> p " ** "; pe e
  
  and pdictent x = 
    match x with DictEnt (k,v) -> pe k; p ":"; pe v 
  in let parg x =
    match x with 
    | Argument1 v -> pe v
    | Argument2 (n,v) -> p n; p " = "; pe v
  in let ptrailer x = 
    begin match x with
    | Arglist aa -> plist (p' "(") (p' ", ") (p' ")") parg aa
    | Dotname n -> p "."; p n 
    | Sublist uu -> List.iter psub uu
    end
  in match e with 
  | PyName s -> p s
  | PyVarIndex (level,i) -> p ("<#" ^ (string_of_int level) ^ "." ^ (string_of_int i) ^ ">")
  | PyDict dd ->
     plist (p' "{") (p' ", ") (p' "}") pdictent dd
  | PyRepr e -> p "`"; pe e; p "`" 
  | Or ee ->
    plist (p' "") (p' " or ")  (p' "") pe ee
  | And ee ->
    plist (p' "(") (p' ") and (")  (p' ")") pe ee
  | Not e -> p "not ("; pe e; p")" 
  | Neg e -> p "-("; pe e; p")"  
  | Compare (e, cl) ->
    pe e; List.iter pcomparator cl
  | BitOr ee ->
    plist (p' "(") (p' ") | (")  (p' ")") pe ee
  | BitAnd ee ->
    plist (p' "(") (p' ") & (")  (p' ")") pe ee
  | BitXor ee -> 
    plist (p' "(") (p' ") ^ (")  (p' ")") pe ee
  | Complement e -> p "~("; pe e; p ")"
  | Eval (e, bs) ->
    p "("; pe e; List.iter pbinop bs; p ")"
  | AtomWithTrailers (e, tt) ->
    pe e; List.iter ptrailer tt
  | Lambda (pas, e) ->
    p "lambda ";
    pparameters pas;
    p ": ";
    pe e

  (* print objects using repr *)
  | PyNone
  | PyTerminal
  | PyInitial
  | PyString _ 
  | PyInt _ 
  | PyLong _ 
  | PyRational _ 
  | PyFloat _ 
  | PyComplex _
  | PyRegexp _
  | PyTuple _ 
  | PyList _ 
  | PyMutableList _ 
  | PyDictionary _ 
  | PyFunction _ 
  | PyNativeFunction _
  | PyNativeMacro _
  | PyBoundMethod _ 
  | PyClass _ 
  | PyModule _  
  | PyRegexp _
  | PyWidget _
  | PyClosure _
  | PyEnv _
  | PyInstance _ -> p (Py_functions.repr e) 
  | PyStatement st -> print_statement level st
  | Unknown -> p "Unknown"

  | _ -> p " UNKNOWN EXPRESSION"

and print_statement level st =
  let p = pi level in
  let ps = print_statement (level+1) in
  let pe = print_expression level in
  let psref sr = p ( "<@" ^ (string_of_int (fst sr)) ^ ">") in
  let pparameters ps = print_parameters level ps in 
  let p' x () = p x in
  let ph h = 
    match h with
    Except0 -> p "except:"; nl()
    | Except1 (sr, e) -> psref sr; p "except "; pe e; p ":"; nl()
    | Except2 (sr, e1, e2) ->
      psref sr; 
      p "except "; 
      pe e1; 
      p ", "; 
      pe e2; 
      p ":"; 
      nl()
  in
  let phc hc = match hc with (h, s) -> ph h; ps s in
  let phcs hcs = List.iter phc hcs in
  let ptestlist x = plist (p' "") (p' ", ") (p' "") pe x in
  begin match st with
  | Empty -> p "pass # empty"; nl()
  | While (sr, e, s1, s2) -> 
    psref sr;  p "while "; pe e; p ":"; nl(); 
    ps s1; 
    begin match s2 with
    | Empty -> ()
    | _ -> 
      p "else: # of while "; nl();
      ps s2
    end
  | For (sr, e1, e2, s1, s2) -> 
    psref sr; p "for "; pe e1; p " in "; pe e2; p ":"; nl();
    ps s1;
    begin match s2 with
    | Empty -> ()
    | _ -> 
      p "else: # of for"; nl();
      ps s2
    end
  | Def (sr,n, p1, s) -> 
    psref sr; p "def "; p n; p "("; pparameters p1; p "):"; nl();
    ps s 
  | Class (sr, n, bb, s) ->  
    psref sr; p "class ";
    p n;
    begin match  bb with
    | PyNone -> ()
    | _ -> p "("; pe bb; p ")"
    end;
    p ":"; nl(); 
    ps s
  | TryFinally (s1, s2) -> 
    p "try:"; nl();
    ps s1; 
    p "finally:"; nl(); 
    ps s2
  | TryElse (s1, h, s2) ->
    p "try:"; nl();
    ps s1; 
    phcs h;
    begin match s2 with
    | Empty -> ()
    | _ ->
      p "else: # of try "; nl();
      ps s2
    end
  | Global (sr, ss) -> 
    psref sr;
    p "<global> "; 
    plist (p' "") (p' ", ") (p' "") p ss;
    nl()
  | Break sr-> psref sr; p "break"; nl()
  | Continue sr -> psref sr; p "continue"; nl()
  | Return (sr,e) -> psref sr; p "return "; flush stdout; pe e; nl() 
  | Raise0 sr -> psref sr; p "raise"; nl()
  | Raise1 (sr,e) -> psref sr; p "raise "; pe e; nl() 
  | Raise2 (sr, e1, e2) -> psref sr; p "raise "; pe e1; p ", "; pe e2; nl()
  | Raise3 (sr, e1, e2, e3) -> psref sr; p "raise "; pe e1; p ", "; pe e2; p ", "; pe e3; nl() 
  | Print (sr,tl) -> psref sr; p "print "; ptestlist tl; nl()
  | PrintComma (sr,tl) -> psref sr; p "print "; ptestlist tl; p ", "; nl()
  | Pass -> p "pass"; nl()
  | Exec1 (sr,e) -> psref sr; p "exec "; pe e; nl()
  | Exec2 (sr,e1, e2) -> psref sr; p "exec "; pe e1; p " in "; pe e2; nl()
  | Exec3 (sr,e1, e2, e3) -> psref sr; p "exec "; pe e1; p " in "; pe e2; p ", "; pe e3; nl() 
  | Assert2  (sr,e1, e2) -> psref sr; p "assert "; pe e1; p ", "; pe e2; nl()
  | Assert1 (sr,e) -> psref sr; p "assert "; pe e; nl()
  | Suite ss -> List.iter (print_statement level) ss 
  | Import (sr,sss) ->
    psref sr;
    p "import ";
    plist (p' "") (p' ",") (p' "")
      (plist (p' "") (p' ".") (p' "") p)
      sss;
    nl()
  | ImportAll (sr,ss) ->
    psref sr; p "from ";
    plist (p' "") (p' ".") (p' "") p ss;
    p " import *";
    nl()
  | ImportFrom (sr,ms, ns) ->
     psref sr;
     plist (p' "from ") (p' ".") (p' " ") p ms;
     plist (p' "import ") (p' ", ") (p' "") p ns;
     nl()
  | If (ess, s) ->
    let pcond cs =
      match cs with (sr, e,s') -> psref sr; pe e; p ":"; nl(); ps s'
    in
    plist (p' "if ") (p' "elif ") (p' "") pcond ess;
    begin match s with
    | Empty -> ()
    | _ -> 
        p "else: # of if"; nl();
        ps s
    end
  | Assign (sr, tt) -> 
    psref sr;
    plist (p' "") (p' " = ") (p' "") pe tt;
    nl()

  | ColonEqual (sr, v, e) -> psref sr; pe v; p " := "; pe e
  | PlusEqual (sr, v, e) -> psref sr; pe v; p " += "; pe e
  | MinusEqual (sr, v, e) -> psref sr; pe v; p " -= "; pe e
  | StarEqual (sr, v, e) -> psref sr; pe v; p " *= "; pe e
  | SlashEqual (sr, v, e) -> psref sr; pe v; p " /= "; pe e
  | PercentEqual (sr, v, e) -> psref sr; pe v; p " %= "; pe e
  | AmperEqual (sr, v, e) -> psref sr; pe v; p " &= "; pe e
  | VbarEqual (sr, v, e) -> psref sr; pe v; p " |= "; pe e
  | CaretEqual (sr, v, e) -> psref sr; pe v; p " ^= "; pe e
  | LeftShiftEqual (sr, v, e) -> psref sr; pe v; p " <<= "; pe e
  | RightShiftEqual (sr, v, e) -> psref sr; pe v; p " >>= "; pe e
  | PlusPlus (sr, v) -> psref sr; pe v; p " ++ "
  | MinusMinus (sr, v) -> psref sr; pe v; p "-- "

  | Del (sr,e) -> 
    psref sr;
    p "del "; 
    pe e;
    nl() 
  | Expr (sr,tt) ->
    psref sr;
    pe tt;
    nl()
    
  (* | _ -> p "UNKNOWN STATEMENT"; nl() *)
  end;
  flush stdout
;;
 

