open Py_types
open Util

let rec repair_list sts =
  match sts with
  | h :: t ->
    begin match h with
    (* -------------------------------------------------------------- *)
    | Suite ls -> repair_list (ls @ t) (* suite flattening *)

    (* -------------------------------------------------------------- *)
    | Def (name, params, body) ->
      begin match body with 
      | Suite sts' -> 
        let sts2 = repair_list sts' in
        begin match list_last sts2 with
        | SetLine (count, file) -> 
          Def (name, params, Suite (list_all_but_last sts2)) ::
          SetLine (count, file) ::
          repair_list t
        | _ -> h :: repair_list t
        end
      | _ -> h :: repair_list t
      end

    (* -------------------------------------------------------------- *)
    | Class (name, params, body) ->
      begin match body with 
      | Suite sts' -> 
        let sts2 = repair_list sts' in
        begin match list_last sts2 with
        | SetLine (count, file) -> 
          Class (name, params, Suite (list_all_but_last sts2)) ::
          SetLine (count, file) ::
          repair_list t
        | _ -> h :: repair_list t
        end
      | _ -> h :: repair_list t
      end

    (* -------------------------------------------------------------- *)
    (* We need to fix this to lift the first body of the while
      when the second body is not empty *)
    | While (sref, e, body1, body2) ->
      begin match body2 with 
      | Empty ->
        begin match body1 with 
        | Suite sts' -> 
          let sts2 = repair_list sts' in
          begin match list_last sts2 with
          | SetLine (count, file) -> 
            While (sref, e , Suite (list_all_but_last sts2), Empty ) ::
            SetLine (count, file) ::
            repair_list t
          | _ -> h :: repair_list t
          end
        | _ -> h :: repair_list t
        end
      | Suite sts' -> 
        let sts2 = repair_list sts' in
        begin match list_last sts2 with
        | SetLine (count, file) -> 
          (* lift body1 here *)
          While (sref, e, body1, Suite (list_all_but_last sts2)) ::
          SetLine (count, file) ::
          repair_list t
        | _ -> h :: repair_list t
        end
      | _ -> h :: repair_list t
      end

    (* -------------------------------------------------------------- *)
    | _ -> h :: repair_list t
    end
  | [] -> []
;;

let fix_newlines st =
match st with 
| Suite ls -> Suite (repair_list ls)
| _ -> raise (Failure "Suite expected in fix_newlines")
;;

