type token =
    NONE
  | ENDMARKER
  | NAME of (string)
  | INTEGER of (int)
  | LONG of (Big_int.big_int)
  | FLOAT of (float)
  | COMPLEX of (float * float)
  | STRING of (string)
  | NEWLINE of (int * string)
  | SETLINE of (int * string)
  | INDENT
  | DEDENT
  | LPAR
  | RPAR
  | LSQB
  | RSQB
  | COLON
  | COMMA
  | SEMI
  | PLUS
  | MINUS
  | STAR
  | SLASH
  | VBAR
  | AMPER
  | LESS
  | GREATER
  | EQUAL
  | DOT
  | PERCENT
  | BACKQUOTE
  | LBRACE
  | RBRACE
  | EQEQUAL
  | NOTEQUAL
  | LESSEQUAL
  | GREATEREQUAL
  | TILDE
  | CIRCUMFLEX
  | LEFTSHIFT
  | RIGHTSHIFT
  | DOUBLESTAR
  | TRAILING_COMMA
  | POWER
  | PLUSPLUS
  | MINUSMINUS
  | PLUSEQUAL
  | MINUSEQUAL
  | STAREQUAL
  | SLASHEQUAL
  | PERCENTEQUAL
  | CARETEQUAL
  | VBAREQUAL
  | AMPEREQUAL
  | TILDEEQUAL
  | COLONEQUAL
  | LEFTSHIFTEQUAL
  | RIGHTSHIFTEQUAL
  | LEFTARROW
  | RIGHTARROW
  | KEYVALSEP
  | SLICESEP
  | CTRL
  | LOC of (Py_types.sref)
  | RARR
  | AND
  | ASSERT
  | BREAK
  | CLASS
  | CONTINUE
  | DEF
  | DEL
  | ELIF
  | ELSE
  | EXCEPT
  | EXEC
  | FINALLY
  | FOR
  | FROM
  | GLOBAL
  | IF
  | IMPORT
  | IN
  | IS
  | LAMBDA
  | NOT
  | OR
  | PASS
  | PRINT
  | RAISE
  | RETURN
  | TRY
  | WHILE
  | LOC_ELIF of (Py_types.sref)
  | LOC_ELSE of (Py_types.sref)
  | LOC_FINALLY of (Py_types.sref)
  | LOC_EXCEPT of (Py_types.sref)
  | LOC_IF of (Py_types.sref)
  | SLOSH
  | BLANK_LINE
  | COMMENT of (string)
  | COMMENT_NEWLINE of ((int * string) * string)
  | WHITE of (int)
  | ERRORTOKEN of (string)

val file_input :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Py_types.statement_t
val eval_input :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Py_types.expr_t
