open Py_types
open Py_exceptions
open Py_builtins_util

let py_list_append
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 2;
  begin match arg e 0 with 
  | PyMutableList ls -> 
    Varray.append_element ls (arg e 1)
  | _ -> raise (TypeError "list_append method requires list object")
  end;
  PyNone

let py_list_extend
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 2;
  begin match arg e 0 with 
  | PyMutableList ls ->
    begin match arg e 1 with 
    | PyMutableList e' -> Varray.append ls e'
    | e' -> Varray.append ls (Varray.of_list (Py_util.list_of_sequence e'))
    end
  | _ -> raise (TypeError "list_extend method requires list object")
  end;
  PyNone

let py_list_count
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 2;
  let value = arg e 1 in
  begin match arg e 0 with 
  | PyMutableList ls ->
    let count = ref 0 in
    Varray.iter
    (fun x -> if Py_datum.py_equal value x then incr count)
    ls
    ;
    PyInt !count
  | _ -> raise (TypeError "list_count method requires list object")
  end

exception FoundIt

let py_list_index
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 2;
  let value = arg e 1 in
  begin match arg e 0 with 
  | PyMutableList ls ->
    let count = ref 0 in
    begin try
      Varray.iter
      (fun x -> if Py_datum.py_equal value x then raise FoundIt; incr count)
      ls
      ;
      raise (ValueError ("list.index("^(Py_functions.repr value)^") not in list"))
    with FoundIt -> PyInt !count;
    end
  | _ -> raise (TypeError "list_index method requires list object")
  end

let py_list_insert
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 3;
  let lst,index,value = 
    begin match arg e 0 with
    | PyMutableList ls -> ls
    | _ -> raise (TypeError "list_insert requires list argument")
    end
  ,
    begin match arg e 1 with
    | PyInt i -> i
    | _ -> raise (TypeError "list_insert requires integer index")
    end
  ,
    arg e 2
  in
   Varray.insert lst index value
   ;
   PyNone

let py_list_sort
  (interp:interpreter_t) 
  (e:expr_t list) 
  (d:dictionary_t): expr_t  = 
  empty_dict d;
  exactly e 1;
  let x = 
    begin match arg e 0 with
    | PyMutableList ls -> ls
    | _ -> raise (TypeError "list_insert requires list argument")
    end
  in 
    Varray.sort Py_datum.py_less_equal x
    ;
    PyNone

