class py_interpreter :
  Py_types.module_t ->
  object
    (* trace control *)
    method incr_tracecount : unit
    method decr_tracecount : unit
    method get_tracecount : int

    (* source line tracking *)
    method pop_line : unit
    method push_line : unit
    method set_line : Py_types.sref -> unit

    (* exception handling *)
    method set_exc_info :
      Py_types.expr_t -> Py_types.expr_t -> Py_types.expr_t -> unit
    method get_exc_info : Py_types.expr_t
    method clear_exc_info : unit
    method get_traceback : Py_types.sref list
    method print_exc_tb : unit
    method print_tb : unit
    method py_raise : exn -> unit

    (* module loading *)
    method get_builtin_modules : Py_types.dictionary_t
    method get_loaded_modules : Py_types.dictionary_t
    method get_path : string list
      (* these method provided for debug info *)

    (* execution *)
    method import: 
      Py_types.module_t -> 
      string list -> 
      Py_types.module_t * Py_types.module_t
      (* import m [x;y;z] returns module x, module y *)

    (* execute a file or string in a fresh environment *)
    method run_file : string -> int
    method run_string : string -> int

    (* type control *)
    method type_of_object : Py_types.expr_t -> Py_types.expr_t
    method type_with_name : string -> Py_types.expr_t

    (* system access *)
    method get_sys : Py_types.module_t
    method get_builtins_environment: Py_types.environment_t
    method get_builtins_dictionary : Py_types.dictionary_t
      (* these are _functions_, not modules! *)
  end

