open Py_types
open Py_exceptions
(* this module is used by Py_eval but does not depend on it *)

(* WARNING: the functions in this module are STRICT with respect to
   trailing newlines! They're mandatory!
*)

let parse_file (filename:string) = 
  let pre_tokens  = Py_pretok.pre_tokens_of_filename filename in
  let tokens  = Py_lex1.translate pre_tokens in
    begin
      let toker = (new Py_tok.tokeniser tokens) in
      let parse_tree = 
      try 
        Py_parse.file_input 
        (toker#token_src) 
        (Lexing.from_string "dummy" )
      with _ -> begin
        toker#report_syntax_error;
        raise (Py_exceptions.ParseError "Parsing File")
      end
      in parse_tree
    end
;; 

let parse_string (data:string) (filename:string) = 
  let pre_tokens  = Py_pretok.pre_tokens_of_string data filename in
  let tokens  = Py_lex1.translate pre_tokens in
    begin
      let toker = (new Py_tok.tokeniser tokens) in
      try 
        Py_parse.file_input 
        (toker#token_src) 
        (Lexing.from_string "dummy" )
      with _ -> begin
        toker#report_syntax_error;
        raise (Py_exceptions.ParseError "Parsing String")
      end
    end
;; 

let parse_string_as_expr (data:string) (filename:string) = 
  let pre_tokens  = Py_pretok.pre_tokens_of_string data filename in
  let tokens  = Py_lex1.translate_for_expr pre_tokens in
    begin
      let toker = (new Py_tok.tokeniser tokens) in
      try 
        Py_parse.eval_input 
        (toker#token_src) 
        (Lexing.from_string "dummy" )
      with _ -> begin
        toker#report_syntax_error;
        raise (Py_exceptions.ParseError "Parsing String")
      end
    end
;; 

(* we have to pass the evaluator as an argument to get
   around a deficiency in ocaml regarding circular dependencies
   between modules 
*)

(* to use this routine, pass py_eval bound to an
   environment, with an empty top dictionary,
   this will fill the dictionary 
*)

let exec_file interp (exec:Py_types.statement_t -> unit) (filename:string) = 
  let parse_tree = 
    try parse_file filename 
    with x -> 
      print_endline ("!! ERROR PARSING FILE" ^ filename); 
      raise x
  in
    try exec parse_tree
    with x -> 
      print_endline ("|| ERROR EXECUTING FILE " ^ filename); 
      print_endline ("!! EXCEPTION: " ^ (Py_functions.string_of_exception x));
      interp#print_tb;
      raise x
;;

let exec_string interp (exec:Py_types.statement_t -> unit) (data:string) (filename:string) = 
  let parse_tree = 
    try parse_string data filename
    with x -> 
      print_endline ("!! ERROR PARSING STRING\n" ^ data); 
      raise x
  in
    try exec parse_tree
    with x -> 
      print_endline ("|| ERROR EXECUTING STRING\n" ^ data); 
      raise x
;;

