open Py_types
open Py_mtypes
open Py_exceptions


class virtual py_environment = 
  object (self)
    val oldenv = env'
    val mutable env:  Py_dict.py_dictionary list = []
    method push = env <- ((new Py_dict.py_dictionary) :: env )
    method push_dictionary d = env <- d :: env
    method pop = (* temporarily, forget about destructors *)
      env <- List.tl env

    method set_attr k v = (List.hd env) # set_item k v
    method del_attr k = (List.hd env) # del_item k
    method has_attr k = 
      match self#get_attr k with 
      | Some _ -> true 
      | None -> false

    method can_get_attr k = self#has_attr k
    method can_set_attr (k:expr_t) (v:expr_t) = true
    method can_set_any_attr (k:expr_t) = true
    method can_del_attr k = (List.hd env) # has_item k
    
    method get_attr k =
      let rec lookup' (g':Py_dict.py_dictionary list) : expr_t option = 
        match g' with 
        | h :: t -> 
          begin match h#get_item k with 
          | Some x as y ->  y
          | None -> lookup' t 
          end
        | [] -> match oldenv with Some x -> x#get_attr k | None -> None
      in lookup' env 

    method get_dicts = env
    method set_dicts ds = env <- ds
    method top = 
      if List.length env > 0 
      then List.hd env
      else raise (ViperError "Environment has no dictionaries in 'top'")

    method keys = 
      if List.length env > 0
      then (List.hd env)#keys
      else []

    method locals =
      if List.length env > 0
      then (List.hd env)
      else new Py_dict.py_dictionary 

    method virtual get_indexed: int -> int -> expr_t
    method virtual set_indexed: int -> int) -> expr_t -> unit
  end


