open Py_types
open Py_exceptions
open Util

class py_dictionary =
  object(self)
    val d:(expr_t, expr_t) Hashtbl.t=  Hashtbl.create 97
    val mutable count: int = 0

    method has_item k = Hashtbl.mem d k
    method get_item k = 
      try Some (Hashtbl.find d k)
      with Not_found -> None 

    method set_item k v = 
        if Hashtbl.mem d k 
        then (Hashtbl.remove d k; count <- count - 1) (* execute destructors? *); 
        Hashtbl.add d k v; count <- count + 1;
        true

    method del_item k = 
        if Hashtbl.mem d k
        then (Hashtbl.remove d k; count <- count -1; true) (* execute destructors? *)
        else false 

    method clear = Hashtbl.clear d
    method len = count
    method iter f = Hashtbl.iter f d
    method keys =
      let kl = ref [] in
      Hashtbl.iter 
      (fun k v -> kl := k :: !kl)
      d;
      !kl

    method sorted_keys comparator = Sort.list comparator self#keys

    (* equality test *)
    (* we have to pass in the comparator because it is defined
       in py_eval, which depends on py_objects *)
    method cmp (comparator:comparison_t) (d':dictionary_t) = 
      if count = d'#len
      then 
        try Hashtbl.iter 
          begin fun k v -> 
            match d'#get_item k with
            | Some x -> 
              if not (comparator v x )
              then raise (Failure "Dummy")
            | None -> raise (Failure "Dummy")
          end 
          d;
          true
        with _ -> false
      else false
  end


