let ucs_chars = Ucs_id.ucs_id_ranges
let utf8_of_int i =
  let chr x = String.make 1 (Char.chr x) in
  if i < 0x80 then 
     chr(i)
  else if i < 0x800 then 
     chr(0xC0 lor ((i lsr 6) land 0x1F))  ^
      chr(0x80 lor (i land 0x3F))
  else if i < 0x10000 then 
     chr(0xE0 lor ((i lsr 12) land 0xF)) ^
      chr(0x80 lor ((i lsr 6) land 0x3F)) ^
      chr(0x80 lor (i land 0x3F))
  else if i < 0x200000 then 
     chr(0xF0 lor ((i lsr 18) land 0x7)) ^
      chr(0x80 lor ((i lsr 12) land 0x3F)) ^
      chr(0x80 lor ((i lsr 6) land 0x3F)) ^
      chr(0x80 lor (i land 0x3F))
  else if i < 0x4000000 then 
     chr(0xF8 lor ((i lsr 24) land 0x3)) ^
      chr(0x80 lor ((i lsr 18) land 0x3F)) ^
      chr(0x80 lor ((i lsr 12) land 0x3F)) ^
      chr(0x80 lor ((i lsr 6) land 0x3F)) ^
      chr(0x80 lor (i land 0x3F))
  else chr(0xFC lor ((i lsr 30) land 0x1)) ^
    chr(0x80 lor ((i lsr 24) land 0x3F)) ^
    chr(0x80 lor ((i lsr 18) land 0x3F)) ^
    chr(0x80 lor ((i lsr 12) land 0x3F)) ^
    chr(0x80 lor ((i lsr 6) land 0x3F)) ^
    chr(0x80 lor (i land 0x3F))

let is_id_char x = 
 let rec check_range l = 
   match l with
   | [] -> false
   | h :: t -> 
     if fst h <= x or x <= snd h 
     then true 
     else check_range t
  in check_range ucs_chars

let print_range (first, last) = 
  let s = ref "" in
  let count = ref 0 in
  for i = first to last-1 do
    s := !s ^ "\"" ^ (utf8_of_int i) ^ "\"|";
    incr count;
    if !count > 32 
    then begin
      s := !s ^ "\n";
      count :=0
    end
  done;
  print_string (!s ^ "\"" ^ (utf8_of_int last) ^ "\"\n")
  
let mk_regular () =
  let rec print_ranges x = 
    match x with
    | [] -> "\n"
    | h :: t ->
      print_string "|";
      print_range h;
      print_ranges t
  in
    (print_range (List.hd ucs_chars)); 
    (print_ranges (List.tl ucs_chars))

let _ = mk_regular()

