# initialise the GUI subsystem
from types import InstanceType
# Bases
class GUIError(Exception): pass

class GUI:
  __implementation__ = "gtk1.2"
  def __init__(self, **args): self.args = args
  def quit(self): qui_quit()
  def mainloop(self): gui_mainloop()

class Widget:
  __callback_mapping__ = {
    'on_click':'clicked',
    'on_delete':'delete_event',
    'on_enter':'enter',
    'on_leave':'leave',
  }
  __callback_mapping_keys__ = __callback_mapping__.keys()

  def realize(self): widget_realize(self.widget)
  def unrealize(self): widget_unrealize(self.widget)
  def show(self): widget_show(self.widget)
  def hide(self): widget_hide(self.widget)
  def set_usize(self, x, y): widget_set_usize(self.widget, x, y)

  def connect(self, signal, callback): 
    if callback: signal_connect(self.widget, signal, callback)

  def get_widget(self): return self.widget
  def _auto_callbacks(self,args):
    for key in args.keys():
      if key in Widget.__callback_mapping_keys__:
        callback = args.get(key)
        name = Widget.__callback_mapping__.get(key)
        signal_connect(self.widget, name, callback)

  def create(self,name, args):
    self.widget = apply(widget_create,(name,), args)
    self._auto_callbacks(args)
    if args.get('show',0): self.show()

class Container(Widget):
  def create(self,kind,args):
    Widget.create(self,kind,args)
    child = args.get("child",None)
    if child: self.add(child)
    
  def add(self,child): 
    if type(child) == InstanceType: child = child.widget
    container_add(self.widget, child)

  def remove(self,child): 
    if type(child) == InstanceType: child = child.widget
    container_add(self.widget, child)

class Window(Container):
  __window_types__ = [
    'toplevel',
    'dialog',
    'popup'
  ]
  def create(self, kind, args):
    new_args = args.copy()
    new_args['type']=kind
    Container.create(self,"window",new_args)

# orientation is horizontal or vertical
class Oriented(Widget):
  orientations = ['vertical','horizontal']

  def create(self,name,args):
    self.orientation = args.get("orientation","vertical")
    if not self.orientation in orientations:
      raise ValueError, "orientation in "+repr(orientations)+" required for "+name+"."
    Widget.create(self,self.orientation[0]+name, args)

class Labelled(Widget):
  def create(self,name,args):
    Widget.create(self,name,args)
 
# widgets

class Alignment(Widget): pass
class Arrow(Widget): pass
class AspectFrame(Widget): pass
class Box(Oriented): pass
    
class Button(Labelled):
  def __init__(self,**args): Labelled.create(self, "button", args)

class ButtonBox(Oriented): pass
class CheckButton(Labelled):
  def __init__(self,**args): Labelled.create(self, "check_button", args)
class CheckMenuItem(Labelled):
  def __init__(self,**args): Labelled.create(self, "check_menu_item", args)

class Clist(Widget): 
  def __init__(self,**args): Widget.create(self, "clist", args)

class ColorSelection(Widget): pass
class Combo(Widget): pass
class Curve(Widget): pass
class GammaCurve(Widget): pass
class Dialog(Window): pass
class DrawingArea(Widget): pass
class Entry(Widget): pass

class FileSelection(Window):
  def __getattr__(self, attr):
    return file_selection_getattr(self.widget, attr)

class Frame(Widget): pass
class Label(Labelled):
  def __init__(self,**args): Labelled.create(self, "label", args)
class List(Widget): pass
class ListItem(Widget): pass
class Menu(Widget): pass
class MenuBar(Widget): pass
class MenuItem(Widget): pass
class NoteBook(Widget):
  def __init__(self,**args):
    Widget.create(self,"notebook", args)
  def add(self,widget,label,position):
    if type(widget) == InstanceType: widget = widget.widget
    if type(label) == InstanceType: label = label.widget
    notebook_insert_page(self.widget, widget, label, position)
  def setattr(self,**args):
    for k in args.keys():
      notebook_setattr(self.widget, k, args[k])

class Pixmap(Widget): pass

class Paned(Container, Oriented):
  def __init__(self,**args):
    Oriented.create(self,"paned", args)

  def add(self,child,**args):
    if type(child) == InstanceType: child = child.widget
    paneno = args.get('pane',1)
    pane_add(self.widget,child,paneno)

class ProgressBar(Widget): pass
class RadioButton(Widget): pass
class RadioMenuItem(Widget): pass
class Scrollbar(Oriented):
  def __init__(self,**args):
    Oriented.create(self,"srollbar", args)
  def get_vadj(self):
    scrollvar_get_vadj(self.widget)
  def get_hadj(self):
    scrollvar_get_hadj(self.widget)

class Separator(Oriented): pass
class ScrolledWindow(Container):
  def __init__(self,**args):
    Container.create(self,"scrolled_window",args)
  def add(self, child):
    if type(child) == InstanceType: child = child.widget
    scrolled_window_add_with_viewport(self.widget, child)

class StatusBar(Widget): pass
class Table(Widget): pass

class Text(Widget):
  def __init__(self,**args):
    Widget.create(self,"text",args)

class ToggleButton(Widget): pass
class Tooltips(Widget): pass

class TopLevel(Window):
  def __init__(self,**args): Window.create(self,"toplevel", args)


