val default_log_mesg : string -> unit
val log_mesg_opt : (string -> unit) option ref
val log_mesg : string -> unit
val log_mesg_set : (string -> unit) -> unit
val log_mesg_remove : unit -> unit
exception No_pixmap
val get_pixmap : < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> 'a
val free_pixmap : < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> bool
val set_pixmap :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  int -> int -> int -> Gdk.pixmap
val drawingarea_configure :
  ((< get_gtkobject : Gtk.Unsafe.gtkobject; .. > as 'a) ->
   'b -> 'c -> int -> int -> unit) ->
  'a -> 'b -> 'c -> int -> int -> bool
val empty_c : 'a -> 'b -> 'c -> 'd -> 'e -> unit
val drawingarea_expose :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  int -> int -> int -> int -> bool
val drawingarea_button_pressed :
  ('a -> 'b -> 'c -> 'd -> 'e -> unit) -> 'a -> 'b -> 'c -> 'd -> 'e -> bool
val empty_b : 'a -> 'b -> 'c -> 'd -> 'e -> unit
val drawingarea_motion_notify :
  ('a -> 'b -> 'c -> 'd -> 'e -> unit) -> 'a -> 'b -> 'c -> 'd -> 'e -> bool
val empty_m : 'a -> 'b -> 'c -> 'd -> 'e -> unit
val drawingarea_key_pressed :
  ('a -> 'b -> 'c -> unit) -> 'a -> 'b -> 'c -> bool
val empty_k : 'a -> 'b -> 'c -> unit
exception Graphic_failure of string
val make_drawing_area :
  (GtkObj.gtkobject -> int -> int -> int -> int -> unit) ->
  (GtkObj.gtkobject -> int -> int -> int -> int -> unit) ->
  (GtkObj.gtkobject -> int -> int -> bool -> int -> unit) ->
  (GtkObj.gtkobject -> int -> int -> unit) ->
  int -> int -> GtkObj.drawing_area
val make_drawing_area_empty : 'a -> 'b -> int -> int -> GtkObj.drawing_area
val rect_of_drawingarea :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> Gdk.rectangle
val clear_graph : < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> unit
val size_x : < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> int
val size_y : < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> int
val trans :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> int * int -> int * int
val trans' :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> int * int -> int * int
type color = Gtk.Unsafe.gtkobject -> Gdk.gc
val gc_of_rgb : Gtk.Unsafe.gtkobject -> Gdk.color -> Gdk.gc
val rgb : int -> int -> int -> Gtk.Unsafe.gtkobject -> Gdk.gc
val black : Gtk.Unsafe.gtkobject -> Gdk.gc
val white : Gtk.Unsafe.gtkobject -> Gdk.gc
val red : Gtk.Unsafe.gtkobject -> Gdk.gc
val green : Gtk.Unsafe.gtkobject -> Gdk.gc
val blue : Gtk.Unsafe.gtkobject -> Gdk.gc
val yellow : Gtk.Unsafe.gtkobject -> Gdk.gc
val cyan : Gtk.Unsafe.gtkobject -> Gdk.gc
val magenta : Gtk.Unsafe.gtkobject -> Gdk.gc
val foreground : Gtk.Unsafe.gtkobject -> Gdk.gc
val background : Gtk.Unsafe.gtkobject -> Gdk.gc
val plot :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> unit
val point_color :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > -> int * int -> Gdk.color
val line :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> int * int -> unit
val draw_rect_full :
  bool ->
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int -> int -> int -> int -> unit
val draw_rect :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int -> int -> int -> int -> unit
val fill_rect :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int -> int -> int -> int -> unit
val draw_arc_full :
  bool ->
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) ->
  int * int -> int -> int -> int -> int -> unit
val draw_arc :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) ->
  int * int -> int -> int -> int -> int -> unit
val fill_arc :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) ->
  int * int -> int -> int -> int -> int -> unit
val draw_ellipse :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> int -> int -> unit
val fill_ellipse :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> int -> int -> unit
val draw_circle :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> int -> unit
val fill_circle :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> int -> unit
val draw_poly_full :
  bool ->
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> (int * int) array -> unit
val draw_poly :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> (int * int) array -> unit
val fill_poly :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  (Gtk.Unsafe.gtkobject -> Gdk.gc) -> (int * int) array -> unit
val default_font : Gdk.font
val text_size : Gdk.font -> string -> int * int
val draw_string :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  Gdk.font -> (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> string -> unit
val draw_char :
  < get_gtkobject : Gtk.Unsafe.gtkobject; .. > ->
  Gdk.font -> (Gtk.Unsafe.gtkobject -> Gdk.gc) -> int * int -> char -> unit
val set_font : Gdk.gc -> Gdk.font -> Gdk.gc
type image = Gdk.image
val transp : Gtk.Unsafe.gtkobject -> Gdk.gc
val make_image : 'a -> unit
val dump_image : 'a -> 'b array array
val draw_image : 'a -> 'b -> 'c -> 'd -> unit
val get_image : 'a -> 'b -> 'c -> 'd -> unit
val create_image : 'a -> 'b -> unit
val blit_image : 'a -> 'b -> 'c -> unit
type status =
  { mouse_x: int;
    mouse_y: int;
    button: bool;
    button_number: int;
    keypressed: bool;
    key: char }
and event = | Button_down | Button_up | Key_pressed | Mouse_motion | Poll
val wait_next_event : event list -> status
val mouse_pos : unit -> int * int
val button_down : unit -> bool
val button_number : unit -> int
val read_key : unit -> char
val key_pressed : unit -> bool
val sound : 'a -> 'b -> unit
module Compatibility :
  sig
    exception Graphic_failure of string
    exception Graphics_unitialized
    val drawingarea : GtkObj.drawing_area option ref
    val open_graph : 'a -> unit
    val close_graph : unit -> unit
    val clear_graph : unit -> unit
    val size_x : unit -> int
    val size_y : unit -> int
    type color = Gtk.Unsafe.gtkobject -> Gdk.gc
    val black : Gtk.Unsafe.gtkobject -> Gdk.gc
    val white : Gtk.Unsafe.gtkobject -> Gdk.gc
    val red : Gtk.Unsafe.gtkobject -> Gdk.gc
    val green : Gtk.Unsafe.gtkobject -> Gdk.gc
    val blue : Gtk.Unsafe.gtkobject -> Gdk.gc
    val yellow : Gtk.Unsafe.gtkobject -> Gdk.gc
    val cyan : Gtk.Unsafe.gtkobject -> Gdk.gc
    val magenta : Gtk.Unsafe.gtkobject -> Gdk.gc
    val foreground : Gtk.Unsafe.gtkobject -> Gdk.gc
    val background : Gtk.Unsafe.gtkobject -> Gdk.gc
    val rgb : int -> int -> int -> Gtk.Unsafe.gtkobject -> Gdk.gc
    val cur_color : (Gtk.Unsafe.gtkobject -> Gdk.gc) ref
    val set_color : (Gtk.Unsafe.gtkobject -> Gdk.gc) -> unit
    val cur_p : (int * int) ref
    val plot : int -> int -> unit
    val point_color : 'a -> 'b -> Gtk.Unsafe.gtkobject -> Gdk.gc
    val moveto : int -> int -> unit
    val current_point : unit -> int * int
    val lineto : int -> int -> unit
    val draw_arc : int -> int -> int -> int -> int -> int -> unit
    val draw_ellipse : int -> int -> int -> int -> unit
    val draw_circle : int -> int -> int -> unit
    val set_line_width : int -> unit
    val cur_font : Gdk.font ref
    val draw_char : char -> unit
    val draw_string : string -> unit
    val set_font : string -> unit
    val set_text_size : 'a -> 'b
    val text_size : string -> int * int
    val fill_rect : int -> int -> int -> int -> unit
    val fill_poly : (int * int) array -> unit
    val fill_arc : int -> int -> int -> int -> int -> int -> unit
    val fill_ellipse : int -> int -> int -> int -> unit
    val fill_circle : int -> int -> int -> unit
    type image = | Not_done
    val transp : Gtk.Unsafe.gtkobject -> Gdk.gc
    val make_image : 'a -> image
    val dump_image : 'a -> 'b array array
    val draw_image : 'a -> 'b -> 'c -> unit
    val get_image : 'a -> 'b -> 'c -> 'd -> image
    val create_image : 'a -> 'b -> image
    val blit_image : 'a -> 'b -> 'c -> unit
    type status =
      { mouse_x: int;
        mouse_y: int;
        button: bool;
        button_number: int;
        keypressed: bool;
        key: char }
    and event = | Button_down | Button_up | Key_pressed | Mouse_motion | Poll
    val wait_next_event : event list -> status
    val mouse_pos : unit -> int * int
    val button_down : unit -> bool
    val button_number : unit -> int
    val read_key : unit -> char
    val key_pressed : unit -> bool
    val sound : 'a -> 'b -> unit
  end
