type window
and visual
and gc
and drawable
and pixmap
and bitmap
and colormap
and font
and image
and imagetype = | GDK_IMAGE_NORMAL | GDK_IMAGE_SHARED | GDK_IMAGE_FASTEST
and point = { x: int; y: int }
and rectangle = { x: int; y: int; width: int; height: int }
and extents =
  { lbearing: int;
    rbearing: int;
    e_width: int;
    ascent: int;
    descent: int }
and color = { mutable pixel: int; red: int; green: int; blue: int }
module Style :
  sig
    type operation =
      | GDK_COPY
      | GDK_INVERT
      | GDK_XOR
      | GDK_CLEAR
      | GDK_AND
      | GDK_AND_REVERSE
      | GDK_AND_INVERT
      | GDK_NOOP
      | GDK_OR
      | GDK_EQUIV
      | GDK_OR_REVERSE
      | GDK_COPY_INVERT
      | GDK_OR_INVERT
      | GDK_NAND
      | GDK_SET
    and fill = | SOLID | TILED | STIPPLED | OPAQUE_STIPPLED
    and line = | LINE_SOLID | LINE_ON_OFF_DASH | LINE_DOUBLE_DASH
    and cap = | CAP_NOT_LAST | CAP_BUTT | CAP_ROUND | CAP_PROJECTING
    and join = | JOIN_MITER | JOIN_ROUND | JOIN_BEVEL
    and filterreturn = | FILTER_CONTINUE | FILTER_TRANSLATE | FILTER_REMOVE
    and visibilitystate =
      | VISIBILITY_UNOBSCURED
      | VISIBILITY_PARTIAL
      | VISIBILITY_FULLY_OBSCURED
  end
exception Not_available
module Event :
  sig
    type mask =
      | EXPOSURE_MASK
      | POINTER_MOTION_MASK
      | POINTER_MOTION_HINT_MASK
      | BUTTON_MOTION_MASK
      | BUTTON1_MOTION_MASK
      | BUTTON2_MOTION_MASK
      | BUTTON3_MOTION_MASK
      | BUTTON_PRESS_MASK
      | BUTTON_RELEASE_MASK
      | KEY_PRESS_MASK
      | KEY_RELEASE_MASK
      | ENTER_NOTIFY_MASK
      | LEAVE_NOTIFY_MASK
      | FOCUS_CHANGE_MASK
      | STRUCTURE_MASK
      | PROPERTY_CHANGE_MASK
      | VISIBILITY_NOTIFY_MASK
      | PROXIMITY_IN_MASK
      | PROXIMITY_OUT_MASK
      | SUBSTRUCTURE_MASK
    module Extract :
      sig
        external expose_x : Glib.Pointer.t -> int
          = "mlgdk_expose_event_extract_x"
        external expose_y : Glib.Pointer.t -> int
          = "mlgdk_expose_event_extract_y"
        external expose_w : Glib.Pointer.t -> int
          = "mlgdk_expose_event_extract_width"
        external expose_h : Glib.Pointer.t -> int
          = "mlgdk_expose_event_extract_height"
        external configure_x : Glib.Pointer.t -> int
          = "mlgdk_configure_event_extract_x"
        external configure_y : Glib.Pointer.t -> int
          = "mlgdk_configure_event_extract_y"
        external configure_w : Glib.Pointer.t -> int
          = "mlgdk_configure_event_extract_width"
        external configure_h : Glib.Pointer.t -> int
          = "mlgdk_configure_event_extract_height"
        external key_string : Glib.Pointer.t -> string
          = "mlgdk_key_event_extract_string"
        external key_keyval : Glib.Pointer.t -> int
          = "mlgdk_key_event_extract_keyval"
        external key_state : Glib.Pointer.t -> int
          = "mlgdk_key_event_extract_state"
        external button_button : Glib.Pointer.t -> int
          = "mlgdk_button_event_extract_button"
        external button_state : Glib.Pointer.t -> int
          = "mlgdk_button_event_extract_state"
        external button_x : Glib.Pointer.t -> int
          = "mlgdk_button_event_extract_x"
        external button_y : Glib.Pointer.t -> int
          = "mlgdk_button_event_extract_y"
        external motion_is_hint : Glib.Pointer.t -> bool
          = "mlgdk_motion_event_extract_is_hint"
        external motion_state : Glib.Pointer.t -> int
          = "mlgdk_motion_event_extract_state"
        external motion_x : Glib.Pointer.t -> int
          = "mlgdk_motion_event_extract_x"
        external motion_y : Glib.Pointer.t -> int
          = "mlgdk_motion_event_extract_y"
      end
  end
external visual_from_window : window -> visual = "mlgdk_visual_from_window"
external drawable_from_window : window -> drawable = "%identity"
external drawable_from_pixmap : pixmap -> drawable = "%identity"
external drawable_from_bitmap : bitmap -> drawable = "%identity"
external window_from_drawable : drawable -> window = "%identity"
external window_from_pixmap : pixmap -> window = "%identity"
external window_from_bitmap : bitmap -> window = "%identity"
external gc_new : window -> gc = "mlgdk_gc_new"
external gc_destroy : gc -> unit = "mlgdk_gc_destroy"
external gc_set_clip_rectangle : gc -> int -> int -> int -> int -> unit
  = "mlgdk_gc_set_clip_rectangle"
external gc_set_foreground : gc -> color -> unit = "mlgdk_gc_set_foreground"
external gc_set_background : gc -> color -> unit = "mlgdk_gc_set_background"
external gc_set_font : gc -> font -> unit = "mlgdk_gc_set_font"
external gc_set_function : gc -> Style.operation -> unit
  = "mlgdk_gc_set_function"
external gc_set_fill : gc -> Style.fill -> unit = "mlgdk_gc_set_fill"
external gc_set_tile : gc -> pixmap -> unit = "mlgdk_gc_set_tile"
external gc_set_stipple : gc -> pixmap -> unit = "mlgdk_gc_set_stipple"
external gc_set_line_attributes :
  gc -> int -> Style.line -> Style.cap -> Style.join -> unit
  = "mlgdk_gc_set_line_attributes"
external pixmap_new : window -> int -> int -> int -> pixmap
  = "mlgdk_pixmap_new"
external pixmap_unref : pixmap -> unit = "mlgdk_pixmap_unref"
external pixmap_create_from_xpm : window -> string -> pixmap * color * bitmap
  = "mlgdk_pixmap_create_from_xpm"
external image_new : imagetype -> visual -> int -> int -> image
  = "mlgdk_image_new"
external image_get : window -> int -> int -> int -> int -> image
  = "mlgdk_image_get"
external image_put_pixel : image -> int -> int -> int -> unit
  = "mlgdk_image_put_pixel"
external image_get_pixel : image -> int -> int -> int
  = "mlgdk_image_get_pixel"
external image_destroy : image -> unit = "mlgdk_image_destroy"
external colormap_alloc_color : colormap -> color -> bool -> bool -> color
  = "mlgdk_colormap_alloc_color"
external colormap_change : colormap -> color -> unit
  = "mlgdk_colormap_change"
external colormap_get_color : colormap -> int -> color
  = "mlgdk_colormap_get_color"
external font_load : string -> font = "mlgdk_font_load"
external string_extents : font -> string -> extents = "mlgdk_string_extents"
external string_width : font -> string -> int = "mlgdk_string_width"
external string_height : font -> string -> int = "mlgdk_string_height"
external string_measure : font -> string -> int = "mlgdk_string_measure"
external draw_point : drawable -> gc -> int -> int -> unit
  = "mlgdk_draw_point"
external draw_line : drawable -> gc -> int -> int -> int -> int -> unit
  = "mlgdk_draw_line" "mlgdk_draw_line_native"
external draw_rectangle :
  drawable -> gc -> bool -> int -> int -> int -> int -> unit
  = "mlgdk_draw_rectangle" "mlgdk_draw_rectangle_native"
external draw_arc :
  drawable -> gc -> bool -> int -> int -> int -> int -> int -> int -> unit
  = "mlgdk_draw_arc" "mlgdk_draw_arc_native"
external draw_polygon : drawable -> gc -> bool -> (int * int) array -> unit
  = "mlgdk_draw_polygon"
external draw_string : drawable -> font -> gc -> int -> int -> string -> unit
  = "mlgdk_draw_string" "mlgdk_draw_string_native"
external draw_pixmap :
  drawable -> gc -> pixmap -> int -> int -> int -> int -> int -> int -> unit
  = "mlgdk_draw_pixmap" "mlgdk_draw_pixmap_native"
external draw_points : drawable -> gc -> (int * int) array -> unit
  = "mlgdk_draw_points"
external draw_segments :
  drawable -> gc -> (int * int * int * int) array -> unit
  = "mlgdk_draw_points"
external draw_lines : drawable -> gc -> (int * int) array -> unit
  = "mlgdk_draw_points"
external window_get_colormap : window -> colormap
  = "mlgdk_window_get_colormap"
external window_get_pointer : window -> int * int * int
  = "mlgdk_window_get_pointer"
external events_pending : unit -> bool = "mlgdk_events_pending"
