/*#include <zlib.h>*/
#include <string.h>

static char *NullStr = "";


#if 0

/* zlib compression routines */
extern int compress(Bytef *dest, uLongf *destlen, const Bytef *source, uLong sourceLen);
extern int uncompress(Bytef *dest,uLongf *destLen,const Bytef *source, uLong sourceLen);


int zerror(int ecode)
{
	switch( ecode )
	{
	case Z_MEM_ERROR:
		PyErr_SetString( PyExc_MemoryError, "Out of memory using zlib");
		break;
	case Z_STREAM_ERROR:
		PyErr_SetString( PyExc_SystemError, "zlib stream error");
		break;
	case Z_VERSION_ERROR:
		PyErr_SetString( PyExc_SystemError, "zlib wrong version");
		break;
	default:
		{
		char msg[81];
		sprintf(msg,"zlib returned an unknown error code %d",ecode);
		PyErr_SetString( PyExc_SystemError, msg);
		}		
	}

	return ecode;
} 


/* Compress string. If compression yields inflates original than null is
   returned.
*/
int zcompress(unsigned char **cptr, long *clen, unsigned char *ptr, long len)
{
	int err;
	long c_len;

	/* maximum size will be 1.1 times the original plus 12 bytes */ 
	*cptr = malloc( (len*1.1) + 12 );

	*clen = 0;
	err = compress( (Bytef *) *cptr, &c_len, ptr, len);
	*clen = c_len;

	if (err || *clen >= len) {
		free( *cptr );
		*cptr = NULL;
		return zerror( err );
		}
	
	return 0;	
}

int zuncompress(char *ptr, long *len, char *cptr, long clen)
{
	long o_len;
		
	zerror( uncompress( (Bytef *)ptr, &o_len, cptr, clen) );
	*len = o_len;
	
	return 0;
}
#endif

PyObject *decode_pystring(datagram *d)
{
	char *sptr;
	long slen;
	PyObject *o;
	
	if (_decode_pystring(d, &sptr, &slen)) 
		Return_None
	
	o = PyString_FromStringAndSize(sptr, slen);
	Py_INCREF(o);
	return o;	
}

int _decode_pystring(datagram *d, char **sptr, long *slen)
{
	char hdr, *cptr;
	long len, clen, i;
	
	hdr = datagram_get(d);
	if( check(hdr, DT_STRING) ) {
		Error("Expected string in _decode_pystring\n");
		*slen = 0;
		*sptr = NullStr;		
		datagram_err(d);
		return -1;
		}
	
	if (hdr & DT_STRING_HASLEN) {
		len = (hdr & DT_STRING_LEN);
		} else {
		_decode_pyint(d, &len);
		}

	if (hdr & DT_STRING_COMPRESS) {	
		
		/* len was the compressed length */
		clen = len;

		/* get the original length */
		_decode_pyint(d, &len);

/*printf("decoding clen = %d, len = %d\n", clen, len);		*/
		*sptr = malloc(len);
		cptr = malloc(clen);
		
		for(i = 0; i < clen; i++)
			cptr[i] = datagram_get(d);
		
/*		zuncompress((unsigned char *) *sptr, slen, cptr, clen);*/
		return 0;
		}	
		
	/* allocate memory and get the */	
	*sptr = malloc(len);
	*slen = len;
	
	for(i = 0; i < len; i++)
		(*sptr)[i] = datagram_get(d);		
		
	return 0;	
}

int encode_pystring(datagram *d, PyObject *o)
{
	long len;
	char *ptr;	
	
	len = PyString_Size(o);
	ptr = PyString_AsString(o);
	
	return _encode_pystring(d, ptr, len);
}


int _encode_pystring(datagram *d, char *ptr, long len)
{
	char hdr;
	char *cptr=NULL;
	long clen;
	long i;
		
	hdr = DT_STRING;
	
	/* try to compress if allowed */
/*	if (d->allow_string_compression)
		zcompress((unsigned char **) &cptr, &clen, ptr, len);*/
		
	/* test to see if we are storing an umcompressed string */	
	if (cptr == NULL || d->allow_string_compression == 0) {
		/* uncompressed string */
		if (len < DT_STRING_LEN) {
			/* if the length was small enough store it in the header */
			hdr |= DT_STRING_HASLEN;
			hdr |= (len & DT_STRING_LEN);
			datagram_put(d, hdr);
			} else {
			datagram_put(d, hdr);
			_encode_pyint(d, (long) len);
			}
		for(i = 0; i < len; i++)
			datagram_put(d, ptr[i]);		
		return 0;	
		} 	
		
	/* compressed string */
	hdr |= DT_STRING_COMPRESS;
	
	/* store compressed length */
	if (clen < DT_STRING_LEN) {

		hdr |= DT_STRING_HASLEN;
		hdr |= (clen & DT_STRING_LEN);

		datagram_put(d, hdr);			
	        } else {

	        datagram_put(d, hdr);
	        _encode_pyint(d, (long) clen);
	        }
	/* store old length */
	_encode_pyint(d, len);
	
	/* store compressed string */
	for(i = 0; i < clen; i++)
		datagram_put(d, cptr[i]);

	return 0;		           				
}
	
