#ifndef SERIALIZE_H
#define SERIALIZE_H

/*
	Author: David Schere
	Date:  October, 1999 
	Abstract: An alternative to cPickle and pcikle which yields 
	        a highly compressed format better suited for network
	        transmission. 
		       
	Algorithms:
	
	
	All data typeshave a one byte header used to denote what type of data is being encoded.
	The format of this byte will change depending on the data type. 
	
	encoding integers:
	
	header:[1][ <value> ][ V ][ V ] [ M/V ][ M/V ][ M/V ][ M/V ]
	
		If the value bit is set than bits 1-5 contain the actual value of the integer
		within the header.
		
		If clear than the lower nibble contains a mask. 
		The integer value is analyzed in byte wise format to
		see if there are any zero bytes. A clear bit in the mask
		means that the byte is zero and need not be encoded.
	
		Example:
		
		Given a number 0x10 00 7F 00
		
		The header would be:
			[1][0][0][0] [1][0][1][0] 
			The lower nibble mask means that we only need 
			two bytes to store this value. Thus the next two
			byte would be 0x10 and 0x7F.
			
			Result: 0x10007f00 is stored in 3 bytes including the header.
			
	encoding strings:
	
		[0][1][ <compression> ][ <has len> ] [ optional length ]
		
		If the compression is allowed this module will try to
		compress the string. If there is a savings in size as a result of the
		compression the compress bit will be set. If the length of the
		string is less than 16 than the lower nibble is used to store 
		the string lengh, else the length will be encoded as an integer
		following this field and then the value of the string following
		that.
		
	list/tuple/dict encoding:
	
		In each case the header may or may not contain the size of the container. In the case of the
		dict the size is assumed to be the number of pairs of items.
		The lower nibbles will contain the length if its small enough
		else, like the string, size of the container encoded as an integer.

	instance:
	
		Any object instance will be encoded as follows:
		
		encode string value of module
		encode string value of class name
		encode __dict__ value
		
	None:
		none is encoded as a zero byte header.			
		
				
		
	
			        
	        
	        
	        
	        
	        
	         


This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.
 */


#include <Python.h>
#include <datagram.h>


/* header formats */
/*
int    [1]LM VVVV
string [01]LC VVVV
list   [001]L VVVV
tuple  [0001] LVVV
dict   [0000 1]LVV
object [0000 01]xx string (module) string (class name) dict( __dict__ values )
double [0000 001]M [VVVV VVVV]
None   [0000 0001]
*/

#define DT_INT				0x80
#define		DT_INT_HASVAL		0x40
#define		DT_INT_MASK		0x0F
#define 	DT_INT_VAL		0x2F

#define DT_STRING		 	0x40
#define		DT_STRING_HASLEN 	0x20
#define		DT_STRING_COMPRESS	0x10
#define		DT_STRING_LEN		0x0F

#define DT_LIST				0x20
#define 	DT_LIST_HASLEN		0x10
#define		DT_LIST_LEN		0x0F

#define DT_TUPLE			0x10
#define 	DT_TUPLE_HASLEN		0x08
#define 	DT_TUPLE_LEN		0x07

#define DT_DICT				0x08
#define		DT_DICT_HASLEN		0x04
#define		DT_DICT_LEN		0x03

#define	DT_OBJECT			0x04

#define DT_DOUBLE			0x02
#define		DT_DOUBLE_BMASK		0x01

#define DT_NONE				0x01



extern void Error(char *msg);
extern int  check(char, char);
extern int _create_bmask(char *mask, int numbytes, char *val);
extern int _decode_bmask(datagram *d, char mask, int numbytes, char *val);



extern int _encode_len(datagram *d, char hdr, char has_len, char lenmask, long len);
extern int _decode_len(datagram *d, char hdr, char has_len, char lenmask, long *len);

#define E( p ) if (p) return -1;

#define Return_None 		\
	{			\
	Py_INCREF( Py_None );	\
	return Py_None;		\
	}

/* test byte ordering  - this will yield 1 if little endian, zero if big endian */

char little_endian();

#define LITTLE_ENDIAN little_endian()

#endif