#include <obj.h>
#include <string.h>
#include <int.h>
#include <dict.h>





/*

	Equivilant python pseudo code:
	
	c = o.__class__
	m = c.__module__
	n = c.__name__
	d = o.__dict__
	
	encode m
	encode n
	encode d

*/
int encode_pyobj(datagram *d, PyObject *o)
{
	char hdr = DT_OBJECT;
	PyObject *__class__,
		 *__name__,
		 *__dict__,
		 *__module__;

/*printf("entering encode_pyobj\n");*/

	__class__ = PyObject_GetAttrString(o,"__class__");
	if ( __class__ == NULL ) {
		Error("Can't encode instance, no __dict__ attribute\n");
		return -1;
		}
	Py_INCREF( __class__ );	

	__name__ = PyObject_GetAttrString(__class__,"__name__");
	if ( __name__ == NULL ) {
		Error("__class__ doesn't have attribute __name__ ");
		Py_DECREF( __class__ );
		return -1;
		}
	Py_INCREF( __name__ );	
	
	__module__ = PyObject_GetAttrString(__class__,"__module__");
	if ( __name__ == NULL ) {
	        Error("__class__ doesn't have attribute __module__ ");
	        Py_DECREF( __class__ );
	        Py_DECREF( __name__ );
	        return -1;
	        }
	Py_INCREF( __module__ );        
	                                                
	__dict__ = PyObject_GetAttrString(o,"__dict__");
	if ( __dict__ == NULL) {
		Error("Instance doesn't have a __dict__ attribute");
	        Py_DECREF( __class__ );
	        Py_DECREF( __name__ );
		Py_DECREF( __module__ );		
		return -1;
		}
	Py_INCREF( __dict__ );


/*printf("encode_pyobj 2\n");*/
	datagram_put(d, hdr);
	/* module encode */
	encode_pystring(d, __module__);
	/* encode name */
	encode_pystring(d, __name__);
	/* encode var dictionary */
	encode_pydict(d,__dict__);
	
        Py_DECREF( __class__ );
        Py_DECREF( __name__ );
	Py_DECREF( __module__ );		
	Py_DECREF( __dict__ );
	
/*printf("leaving encode_pyobj\n");	*/
	return 0;	
}

PyObject *decode_pyobj(datagram *d)
{
	char hdr;
	char msg[81];
	PyObject *mod, *obj, *inst, *dict, *keys, *k, *v;
	PyObject *modname, *objname;
	long len, i;
	
	hdr = datagram_get(d);
	if (hdr != DT_OBJECT) {
		sprintf(msg,"Expected header for object, received: %X\n",
			hdr);
		Error(msg);
		Return_None	
		}

	/* get the module name */
	modname = decode_pystring(d);
	if (modname == NULL)
		Return_None
	Py_INCREF( modname );

	/* get the class name  */
	objname = decode_pystring(d); 		
	if (objname == NULL) {
		Py_DECREF( modname );
		Return_None
		}
		
	/* get the object data dictionary */
	/* get the __dict__ dictionary for the object */
	dict = decode_pydict(d);
	if (dict == NULL) {
		Py_DECREF( modname );
		Py_DECREF( objname );
		Return_None
		}	

	/* import module */
	mod = PyImport_Import( modname );

	if (mod == NULL) {
		sprintf(msg,"Unable to import module '%s'\n",
			PyString_AsString(modname));
		Error(msg);
		
		Py_DECREF( objname );
		Py_DECREF( modname );
		Return_None	
		}		

	/* get the class object */		
	obj = PyObject_GetAttr( mod, objname );
	if (obj == NULL) {
		Py_DECREF( modname );
		Py_DECREF( objname );
		Py_DECREF( mod );
		Return_None
		}
						
	/* instantiate object */
	inst = PyObject_CallObject(obj,NULL);
	
	/* now loop through dictionary and inject values into the instance */
	keys = PyDict_Keys(dict);
	for( i = 0; i < PyDict_Size(dict); i++) {
		k = PyList_GetItem(keys, i);
		v = PyDict_GetItem(dict, k);
		PyObject_SetAttr(inst,k,v);
		}	
	
	/* make sure the object doesn't die because of cleanup */
	Py_INCREF( inst );
		
	/* cleanup */	
	Py_DECREF(modname);
	Py_DECREF(objname);		
	Py_DECREF( dict );
	Py_DECREF( mod );
	Py_DECREF( obj );
	
	return inst;	
}