#include <list.h>
#include <serialize.h>
#include <decode.h>

PyObject *decode_series(datagram *d, char hdr, char lenbit, char lenmask)
{
	PyObject *o;
	long i, len;
	
	if (_decode_len(d, hdr, lenbit, lenmask, &len) )
		return NULL;
	
	if (hdr & DT_LIST)
		o = PyList_New( len );
	else
		o = PyTuple_New( len );
		
	for (i = 0; i < len; i++)
		if (hdr & DT_LIST)
			PyList_SetItem(o, i, decode(d));
		else
			PyTuple_SetItem(o, i, decode(d));			
	
	Py_INCREF( o );
	return o;
}

int encode_series(datagram *d, char cbit, char lenbit, char lenmask,  PyObject *o)
{
	char hdr;
	long i;
	long size;
	
	hdr = cbit;
	if (cbit == DT_LIST)
		size = PyList_Size(o);
	else
		size = PyTuple_Size(o);	

	/* encode the length of the list or tuple */
	_encode_len(d, hdr, lenbit, lenmask, size);

	for (i = 0; i < size; i++)
		if (cbit == DT_TUPLE)
			encode(d, PyTuple_GetItem(o,i));
		else
			encode(d, PyList_GetItem(o,i));
	
	return 0;
}


int encode_pylist(datagram *d, PyObject *o)
{
	return encode_series(d, DT_LIST, DT_LIST_HASLEN, DT_LIST_LEN, o);
}

PyObject *decode_pylist(datagram *d)
{
	char hdr;
	
	hdr = datagram_get(d);
	return decode_series(d, hdr, DT_LIST_HASLEN, DT_LIST_LEN);
}

int encode_pytuple(datagram *d, PyObject *o)
{
	return encode_series(d, DT_TUPLE, DT_TUPLE_HASLEN, DT_TUPLE_LEN, o);
}

PyObject *decode_pytuple(datagram *d)
{
	char hdr;
	
	hdr = datagram_get(d);
	return decode_series(d, hdr, DT_TUPLE_HASLEN, DT_TUPLE_LEN);
}

