#include <int.h>


int encode_pyint(datagram *d, PyObject *val)
{
	return _encode_pyint(d, PyInt_AsLong(val) );
}

PyObject *decode_pyint(datagram *d)
{
	long val;
	PyObject *o;	

	if ( _decode_pyint(d, &val) == -1 )
		Return_None
		
	o = PyInt_FromLong(val);
	Py_INCREF(o);
	return o;
}


int _encode_pyint(datagram *d, long v)
{
	char hdr;
	char *cval;
	int i;

	hdr = DT_INT;
	if (v >= 0 && v < DT_INT_VAL) {
			hdr |= DT_INT_HASVAL;
		hdr |= (v & DT_INT_VAL);
		datagram_put(d, hdr);
		return 0;
		}
		
	cval = (char *)  &v;	
	_create_bmask(&hdr, 4, cval);
	datagram_put(d, hdr);
	for(i = 0; i < 4; i++)
		if (cval[i])
			datagram_put(d, cval[i]);
	return 0;		
}

int _decode_pyint(datagram *d, long *val)
{
	char hdr;
	int i;
	
	hdr = datagram_get(d);

	if ( (hdr & DT_INT) == 0 ) {
		Error("In _decode_pyint non int header detected");
		return -1;
		}

	/* zero out bytes */
	*val = 0;
	
	if(hdr & DT_INT_HASVAL){
		*val = (DT_INT_VAL & hdr);
		return 0;
		}
		
	_decode_bmask(d, hdr, sizeof(long), (char *) val);
	datagram_adjust_endian(d, (char *) val, sizeof(long));
	return 0;			
}
