#include <double.h>


PyObject *decode_pydouble(datagram *d)
{
	char hdr;
	double p = 0;
	char *ptr;
	PyObject *o;
	
	/* fetch the header */
	hdr = datagram_get(d);
	
	/* map the memory for a double to a char array */
	ptr = (char *) &p;
	
	/* test to see that there was justification for a byte mask */
	if (hdr & DT_DOUBLE_BMASK) {
		char mask;
	
		/* get the mask */
		mask = datagram_get(d);
		/* extract the value */
		_decode_bmask(d, mask, sizeof(double), ptr);
		} else {
		int i;
		
		for(i=0;i<sizeof(double);i++)
			ptr[i] = datagram_get(d);
		}
	
	/* adjust for endian byte ordering */
	datagram_adjust_endian(d, ptr, sizeof(double));

	/* convert into a python data type */	
	o = PyFloat_FromDouble(p);
	
	Py_INCREF(o);
	
	return o;
}

int encode_pydouble(datagram *d, PyObject *p)
{
	char hdr, *ptr, bmask=0;
	double q;
	int i, cnt;
	
	q = PyFloat_AsDouble(p);
	ptr = (char *) &q;
	
	hdr = DT_DOUBLE;
	cnt = _create_bmask(&bmask, sizeof(double), ptr);
		
	if (cnt < (sizeof(double)-1) ) {

		hdr |= DT_DOUBLE_BMASK;
		/* encode header */
		datagram_put(d,hdr);
		/* encode mask */
		datagram_put(d,bmask);
		/* encode value */
		for(i=0;i<sizeof(double);i++)
			if (bmask & (1 << i))
				datagram_put(d, ptr[i]);		
		} else {

		/* encode header */
		datagram_put(d,hdr);
		/* encode value */
		for(i=0;i<sizeof(double);i++)
			datagram_put(d, ptr[i]);
		}
		
	return 0;	
}

