#include <serialize.h>
#include <decode.h>
#include <string.h>
#include <int.h>

PyObject *decode_pydict(datagram *d)
{
	char hdr;
	long len=0, i;
	PyObject *o;

	/* get the header */	
	hdr = datagram_get(d);

	/* get the number of items (key,value pairs) */
	_decode_pyint(d, &len);

	o = PyDict_New();
	for (i = 0; i < len; i++) {
		PyObject *k, *v;

		k = decode(d);
		v = decode(d);
		
		PyDict_SetItem(o,k,v);
		}
		
	Py_INCREF( o );
	return o;	
}

int encode_pydict(datagram *d, PyObject *o)
{
	char hdr;
	long len, i;
	PyObject *keys;
	
	/* get the header */
/*	hdr = datagram_get(d);*/

	/* set id bit */
	hdr = DT_DICT;
	
	datagram_put(d, hdr);
	
	/* get the size of the dictionary */
	len = PyDict_Size(o);

	/* encode long */
	_encode_pyint(d, len);

	if (len == 0) {
		return 0; /* zero length dictionary */
		}
	
	keys = PyDict_Keys(o);
	for(i = 0; i < len; i++){
		PyObject *val, *key;
		
		key = PyList_GetItem(keys, i);
		val = PyDict_GetItem(o,key);
/*printf("encode_pydict 3\n");*/
		
		encode(d, key);
		encode(d, val );
		
		}
	
	return 0;
}
