#include <decode.h>
#include <string.h>
#include <int.h>
#include <dict.h>
#include <list.h>
#include <obj.h>
#include <none.h>
#include <double.h>

int last = 0;

void log(datagram *d, PyObject *o)
{
	long i;
	
	if (d->buffer == NULL) return;

	for(i = last; i < d->index; i++)
		printf("[%X] '%c'\n",d->buffer[i]);
	last = d->index;	
	printf("d->index = %ld, ", d->index);

        if      (PyInt_Check(o))
                printf("int\n");
        else if (PyString_Check(o))
                printf("string\n");
        else if (PyList_Check(o))
                printf("list\n");
        else if (PyTuple_Check(o))
                printf("tuple\n");
        else if (PyDict_Check(o))
                printf("dict\n");
        else if (PyInstance_Check(o))
                printf("instance\n");
        else if (PyFloat_Check(o))
                printf("double\n");
        else if (o == Py_None)
                printf("none\n");
	else
		printf("Illegal !!\n");		
}


PyObject *decode(datagram *d) 
{ 
	char hdr;

	hdr = datagram_peek(d);

	if 	(hdr & DT_INT)
		return decode_pyint(d);
	else if (hdr & DT_STRING)
		return decode_pystring(d);
	else if (hdr & DT_LIST)
		return decode_pylist(d);
	else if (hdr & DT_TUPLE)
		return decode_pytuple(d);
	else if (hdr & DT_DICT)
		return decode_pydict(d);
	else if (hdr & DT_OBJECT) 
		return decode_pyobj(d);		
	else if (hdr & DT_DOUBLE)
		return decode_pydouble(d);
	else if (hdr & DT_NONE)
		return decode_pynone(d);
	
	{
	char msg[81];
						
	sprintf(msg,"Unable to decode python type hdr=0x%X\n", hdr); 
	printf(msg);
	Error( msg );
	Return_None
	}
}

int encode(datagram *d, PyObject *o)
{
/*log(d,o);	*/
	if	(PyInt_Check(o))
		return encode_pyint(d,o);
	else if (PyString_Check(o))
		return encode_pystring(d,o);
	else if (PyList_Check(o))
		return encode_pylist(d,o);
	else if (PyTuple_Check(o))
		return encode_pytuple(d,o);
	else if (PyDict_Check(o))
		return encode_pydict(d,o);
	else if (PyInstance_Check(o))
		return encode_pyobj(d,o);
	else if (PyFloat_Check(o)) 
		return encode_pydouble(d,o);		
	else if (o == Py_None)
		return encode_pynone(d);
						
	{
	char msg[81];
						
	sprintf(msg,"Unable to encode python object"); 
	printf(msg);
	Error( msg );
	return -1;
	}
}



