#ifndef DATAGRAM_H
#define DATAGRAM_H


typedef struct
{
	char *buffer;
	long  index, size;
	char allow_string_compression;
	char little_endian;
	char remote_endian;
}datagram;

void datagram_init(datagram *d);

int datagram_put(datagram *d, char ch);
char datagram_get(datagram *d);
char datagram_peek(datagram *d);

void datagram_adjust_endian(datagram *d, char *ptr, int len);
void datagram_err(datagram *d);

#endif