#include <datagram.h>
#include <serialize.h>

void datagram_adjust_endian(datagram *d, char *ptr, int len)
{
	int i;
	
	/* did a big endian machine encode and we are a little
		or visa versa ? */
	if (d->little_endian != d->remote_endian) {
		/* byte ordering reversal */
		for(i=0;i<len/2;i++){
			char temp;
			
			temp = ptr[i];
			ptr[i] = ptr[len-1-i];
			ptr[len-1-i] = temp;
			}
		}
}

void datagram_init(datagram *d)
{
	d->buffer = NULL;
	d->index = d->size = 0;
	d->allow_string_compression = 1;
	/* little endian -> 1 else 0 */
	d->little_endian = LITTLE_ENDIAN;
}


int datagram_put(datagram *d, char ch)
{
	if (d->buffer){
		if (d->index >= d->size) {
			Error("datagram index out of range!");
			return -1;
			}
		d->buffer[ d->index++ ] = ch;
		}
	else	
		d->size++;
		
	return 0;	
}

char datagram_peek(datagram *d)
{
	if (d->index >= d->size) {
		Error("datagram index out of range");
		return '\0';
		}

	return d->buffer[ d->index ];
}

char datagram_get(datagram *d)
{
	if (d->index >= d->size) {
		Error("datagram index out of range");
		return '\0';
		}

	return d->buffer[ d->index++ ];
}

void datagram_err(datagram *d)
{
	long i;
	printf("d->index = %ld, d->size = %ld\n",
		d->index, d->size);
		
	for(i=0; i < d->size; i++) {
		if (i == d->index)
			printf("**** error position ***, index = %ld\n", d->index);
		printf("[%X] '%c'\n",(int) d->buffer[ i ] & 0xFF,
			d->buffer[ i ]);	
		}	
}