#include <serialize.h>
#include <int.h>
#include <string.h>

void initserialize();

char little_endian()
{
	long p = 0x00000001;
	char *ptr;
	
	ptr = (char *) &p;
	return ptr[0];	
}

/* statics */
static PyObject *ErrorObject;
static char 	*NullStr = "";


void Error(char *msg) {
	PyErr_SetString(ErrorObject,msg);
	}

int check(char hdr, char expected)
{
	char msg[81];

	if (hdr & expected)
		return 0;	
	sprintf(msg,"Corruption detected expected '%X' received '%X'",
		expected, hdr);
	Error(msg);
	return -1;		
}


	


int _create_bmask(char *mask, int numbytes, char *val)
{
	int i, cnt = 0;
	
	for(i = 0; i < numbytes; i++)
		if (val[i]) {
			*mask |= (1 << i);
			cnt++;
			} else {
			*mask &= ~(1 << i);
			}
	return cnt;			
}

int _decode_bmask(datagram *d, char mask, int numbytes, char *val)
{
	int i;
	
	for(i = 0; i < numbytes; i++)
		if (mask & (1 << i))
			val[i] = datagram_get(d);
		else
			val[i] = 0;
	return 0;
}


int _encode_len(datagram *d, char hdr, char has_len, char lenmask, long len)
{
	if (len >= 0 && len < lenmask) {
		hdr |= has_len;
		hdr |= (len & lenmask);
		datagram_put(d, hdr);
		} else {
		datagram_put(d, hdr);
		_encode_pyint(d, len);
		}
	return 0;	
}

int _decode_len(datagram *d, char hdr, char has_len, char lenmask, long *len)
{

	if (hdr & has_len) {
		*len = (hdr & lenmask);
		return 0;
		}
	*len = 0;
	
	return  _decode_pyint(d, len);	
}	


#include <decode.h>

#define PACKET_ID     0xFE
#define PACKET_ENDIAN 0x01


PyObject *loads(PyObject *self, PyObject *args)
{
	datagram d;
	char hdr;
	PyObject *o;
/*	long dummy;*/
	
	if ( !PyArg_ParseTuple(args,"O",  &o) )
		return NULL;
	
	Py_INCREF( o );
	
	d.size = PyString_Size(o);
	d.buffer = PyString_AsString(o);
	d.index = 0;
	
	
	
	hdr = datagram_get(&d);
		
	/* decode packet size, not used for string loads  */
/*	_decode_pyint(&d, &dummy );*/

	if (hdr & PACKET_ID) {

		d.remote_endian = hdr & PACKET_ENDIAN;
		d.little_endian = LITTLE_ENDIAN;
		
		/* decode objects */
		return decode(&d);
		} else {
		char msg[81];
		
		sprintf(msg,"Currupt packet, hdr = %X\n", hdr );
		Error(msg);
		}
	Return_None		
}

PyObject *dumps(PyObject *self, PyObject *args)
{
	datagram d;
	PyObject *o;
	char hdr;
	int with_string_compr=1;
	long len=0x7FFFFFFF;
	
/*printf("Entering dumps\n");	*/
	if ( !PyArg_ParseTuple(args, "O|i",&o, &with_string_compr) ) {
	  	printf("Invalid arguments\n");
		Error("Invalid arguments");
			Return_None
		}

	datagram_init(&d);
	/* allow user to switch of string compression */
	d.allow_string_compression = with_string_compr;	
	/* create header */
	hdr = PACKET_ID | LITTLE_ENDIAN;

/*printf("dumps 1\n");	*/
	/* first time through generates the length */
	if (encode(&d, o)) {
		Error("Failed to encode");
		Return_None
		}
/*printf("dumps 2\n");	*/

	/* Encode the size of the packet */
	if (_encode_pyint(&d, d.size)) {
		Error("Unable to encode size of packet");
		Return_None
		}
	len = d.size; /* save the size value */	
/*printf("dumps 3\n");	*/
		
	if (datagram_put(&d, hdr) ) {
		Error("Unable to encode header"); 
		Return_None	
		}

	/* now we allocate a buffer and run through again */
	d.buffer = (char *) malloc(d.size);
	d.index = 0;
/*printf("dumps 4\n");	*/
	
	/* encode header for real */	
	datagram_put(&d, hdr);
	/* encode how many bytes beyond this pyint */
	/* _encode_pyint(&d,d.size);*/
	/* encode object */ 
	encode(&d,o);
	
	o = PyString_FromStringAndSize(d.buffer, d.size);
	
	free(d.buffer);
	
	Py_INCREF(o);
	return o;
}



/* Python/C interface
*/
	
	
static PyMethodDef serialize_methods[] = {
	{ "loads", loads, 1 },
	{ "dumps", dumps, 1 },
	{ NULL, NULL } /* sentinel value */
	};	


void
initcserialize()
{
        PyObject *m, *d;
        
        /* Create the module and add the functions */
        m = Py_InitModule("cserialize", serialize_methods);
                        
        /* Add some symbolic constants to the module */
        d = PyModule_GetDict(m);
        ErrorObject = PyErr_NewException("cserialize.error", NULL, NULL);
        PyDict_SetItemString(d, "error", ErrorObject);
}


