
import _expect

class popen2:
    def __init__ (self, *args):
	self.p = apply (_expect.popen2, args)
	self.command = _expect.get_command (self.p)

    def read (self, *args):
	return apply (_expect.read, (self.p,) + args)

    def read_error (self, *args):
	r = apply (_expect.read_stderr, (self.p,) + args)
	return r

    def write (self, *args):
	return apply (_expect.write, (self.p,) + args)

    def close (self):
	return _expect.close (self.p)

    def flush (self):
	pass

    def isatty (self):
	return 0

    def readline (self):
	return _expect.read (self.p, '\n')

    def readlines (self):
	r = []
	while 1:
	    l = _expect.read (self.p, '\n')
	    if not l:
		return r
	    r.append (l)

    def seek (self, offset, whence):
	if whence != 1:
	    raise ValueError, "seek: third arg must be 1"
	while offset > 0:
	    if offset > 65536:
		offset = offset - len (_expect.read (self.p, 65536))
	    else:
		offset = offset - len (_expect.read (self.p, offset))

    def tell (self):
	return _expect.get_count (self.p)

    def pid (self):
	return _expect.get_pid (self.p)

    def setblocking (self, block):
	_expect.set_blocking (self.p, block)

    def writelines (self, t):
	for l in t:
	    return _expect.write (self.p, l)

    def __repr__ (self):
	return _expect.read (self.p)

class popen (popen2):
    def __init__ (self, *args):
	self.p = apply (_expect.popen, args)
	self.command = _expect.get_command (self.p)

class popen3 (popen2):
    def __init__ (self, *args):
	self.p = apply (_expect.popen3, args)
	self.command = _expect.get_command (self.p)


