/**********************************************************************
Copyright 1999 by ITG Australia.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of ITG Australia or ITGA
not be used in advertising or publicity pertaining to distribution of
the software without specific, written prior permission.

ITG AUSTRALIA DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
EVENT SHALL ITG AUSTRALIA BE LIABLE FOR ANY SPECIAL, INDIRECT OR
CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
**********************************************************************/
#include "Sybase.h"

/* Global database context
 */
static CS_CONTEXT *ctx;

/* Verify that a Sybase connection structure exists.  Return non-zero
 * if OK.  Raise a Python exception and return 0 if it does not exist.
 */
int conn_check(ConnInfo *conn_info)
{
    if (conn_info != NULL && conn_info->conn != NULL)
	return 1;
    raise_exception_string(InternalError, "connection is not open");
    return 0;
}

/* Allocate and initialise the CS_CONNECTION, then connect to the
 * server.
 *
 * Return non-zero on success.  Return zero on failure and perform
 * cleanup.
 */
int conn_init(ConnInfo *conn_info,
	      char *dsn, char *user, char *passwd, int bulkcopy, int debug)
{
    conn_info->conn = NULL;
    conn_info->is_conn_ok = 0;
    conn_info->is_bulkcopy = bulkcopy;
    conn_info->debug = debug;

    if (ctx == NULL) {
	CS_INT netio_type = CS_SYNC_IO;

	debug_msg(conn_info->debug, "cs_ctx_alloc\n");
	if (cs_ctx_alloc(CS_VERSION_100, &ctx) != CS_SUCCEED) {
	    raise_exception_string(InterfaceError, "cs_ctx_alloc failed");
	    return 0;
	}
	debug_msg(conn_info->debug, "ct_init\n");
	if (ct_init(ctx, CS_VERSION_100) != CS_SUCCEED) {
	    raise_exception_string(InterfaceError, "ct_init failed");
	    return 0;
	}
	debug_msg(conn_info->debug, "ct_config\n");
	if (ct_config(ctx, CS_SET, CS_NETIO, &netio_type, 
		      CS_UNUSED, NULL) != CS_SUCCEED) {
	    raise_exception_string(InterfaceError, "ct_config(netio) failed");
	    return 0;
	}
    }

    debug_msg(conn_info->debug, "ct_con_alloc()\n");
    if (ct_con_alloc(ctx, &conn_info->conn) != CS_SUCCEED) {
	raise_exception(conn_info, "ct_con_alloc failed");
	return 0;
    }
    debug_msg(conn_info->debug, "ct_diag()\n");
    if (ct_diag(conn_info->conn,
		CS_INIT, CS_UNUSED, CS_UNUSED, NULL) != CS_SUCCEED) {
	raise_exception(conn_info, "ct_diag(CS_INIT) failed"); 
	goto error;
    }
    debug_msg(conn_info->debug, "ct_con_props(CS_USERNAME)\n");
    if (ct_con_props(conn_info->conn, CS_SET, CS_USERNAME, 
		     user, CS_NULLTERM, NULL) != CS_SUCCEED) {
	raise_exception(conn_info, "ct_con_props(CS_USERNAME) failed"); 
	goto error;
    }
    debug_msg(conn_info->debug, "ct_con_props(CS_PASSWORD)\n");
    if (ct_con_props(conn_info->conn, CS_SET, CS_PASSWORD, 
		     passwd, CS_NULLTERM, NULL) != CS_SUCCEED) {
	raise_exception(conn_info, "ct_con_props(CS_PASSWORD) failed");
	goto error;
    }
    debug_msg(conn_info->debug, "ct_con_props(CS_APPNAME)\n");
    if (ct_con_props(conn_info->conn, CS_SET, CS_APPNAME,
		     "python", CS_NULLTERM, NULL) != CS_SUCCEED) {
	raise_exception(conn_info, "ct_con_props(CS_APPNAME) failed");
	goto error;
    }

    if (conn_info->is_bulkcopy) {
	CS_BOOL bool = CS_TRUE;

	debug_msg(conn_info->debug, "ct_con_props(CS_BULK_LOGIN)\n");
	if (ct_con_props(conn_info->conn, CS_SET, CS_BULK_LOGIN,
			 (CS_VOID *)&bool, CS_UNUSED, NULL) != CS_SUCCEED) {
	    raise_exception(conn_info, "ct_con_props(CS_BULK_LOGIN) failed");
	    goto error;
	}
    }

    debug_msg(conn_info->debug, "ct_connect()\n");
    if (ct_connect(conn_info->conn, dsn, CS_NULLTERM) != CS_SUCCEED) {
	raise_exception(conn_info, "ct_connect failed");
	goto error;
    }

    conn_info->is_conn_ok = 1;
    return 1;

error:
    ct_con_drop(conn_info->conn);
    conn_info->conn = NULL;
    return 0;
}

/* Close and free a Sybase connection
 */
void conn_free(ConnInfo *conn_info)
{
    if (conn_info->conn != NULL) {
	if (conn_info->is_conn_ok)
	    ct_close(conn_info->conn, CS_UNUSED);
	conn_info->is_conn_ok = 0;
	ct_con_drop(conn_info->conn);
	conn_info->conn = NULL;
    }
}

/* Clear all messages on a Sybase connection.  This should be done
 * whenever possible to avoid Sybase discarding messages.
 */
void conn_clear_messages(ConnInfo *conn_info)
{
    ct_diag(conn_info->conn, CS_CLEAR, CS_ALLMSG_TYPE, CS_UNUSED, NULL);
}

