#! /usr/local/bin/python

from Opengl import *

class Fog:
  def __init__(self):
    self.o = Opengl(width = 250, height = 140, double = 1)
    self.o.redraw = self.redraw
    self.o.pack(side = 'top', expand = 1, fill = 'both')
    self.mode = IntVar(self.o)
    self.mode.set(GL_EXP)
    r1 = Radiobutton(text='GL_LINEAR', anchor=W, variable=self.mode,
                     value=GL_LINEAR, command=self.selectFog)
    r1.pack(side = 'top', expand = 1, fill = 'both')
    r2 = Radiobutton(text='GL_EXP', anchor=W, variable=self.mode,
                     value=GL_EXP, command=self.selectFog)
    r2.pack(side = 'top', expand = 1, fill = 'both')

  def run(self):
    self.init()
    self.o.mainloop()

  def selectFog(self):
    val = self.mode.get()
    if val == GL_LINEAR:
      gl.Fogf(GL_FOG_START, 1.0)
      gl.Fogf(GL_FOG_END, 5.0)
      gl.Fogi(GL_FOG_MODE, val)  
    elif val == GL_EXP:
      gl.Fogi(GL_FOG_MODE, val)
    self.o.tkRedraw()

  def init(self):
    gl.Disable(GL_DITHER)
    gl.Enable(GL_DEPTH_TEST)
    gl.DepthFunc(GL_LESS)
    gl.Lightf(GL_LIGHT0, GL_POSITION, [0.0, 3.0, 3.0, 0.0])
    gl.LightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER, [0.0])
    gl.FrontFace(GL_CW)
    gl.Enable(GL_LIGHTING)
    gl.Enable(GL_LIGHT0)
    gl.Enable(GL_AUTO_NORMAL)
    gl.Enable(GL_NORMALIZE)
    gl.Enable(GL_FOG)
    fogColor = [0.5, 0.5, 0.5, 1.0]
    gl.Fogi(GL_FOG_MODE, GL_EXP)
    gl.Fogf(GL_FOG_COLOR, fogColor)
    gl.Fogf(GL_FOG_DENSITY, 0.35)
    gl.Hint(GL_FOG_HINT, GL_DONT_CARE)
    gl.ClearColor(0.5, 0.5, 0.5, 1.0)
  
  def drawTorus(self, x, y, z):
    gl.PushMatrix();
    gl.Translatef(x, y, z);
    gl.Materialf(GL_FRONT, GL_AMBIENT, [0.1745, 0.01175, 0.01175, 1.0])
    gl.Materialf(GL_FRONT, GL_DIFFUSE, [0.61424, 0.04136, 0.04136, 1.0])
    gl.Materialf(GL_FRONT, GL_SPECULAR, [0.727811, 0.626959, 0.626959, 1.0])
    gl.Materialf(GL_FRONT, GL_SHININESS, 0.6 * 128.0)
    gl.SolidTorus(0.275, 0.85, 20, 20)
    gl.PopMatrix()

  def redraw(self, o):
    gl.Clear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
    self.drawTorus(-4.0, -0.5, -1.0)
    self.drawTorus(-2.0, -0.5, -2.0)
    self.drawTorus(0.0, -0.5, -3.0)
    self.drawTorus(2.0, -0.5, -4.0)
    self.drawTorus(4.0, -0.5, -5.0)

def main():
  f = Fog()
  f.run()

main()
