#! /usr/local/bin/python

from Opengl import *
import sys

def redraw_checker(o):
  gl.ClearColor(1, 0, 1, 0)
  gl.Clear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
  gl.Color3f(0, 1, 0)
  #draw checkerboard
  N = 4
  gl.Disable(GL_LIGHTING)
  for x in range(-N, N):
    for y in range(-N, N):
      if (x + y) % 2 == 0:
	gl.Color3f(1, 1, 0)
      else:
	gl.Color3f(0, 0, 0)	
      gl.Rectf(x, y, x + 1, y + 1)
  gl.Enable(GL_LIGHTING)

  gl.PushMatrix()
  gl.Translatef(0., 0., 1.)
  gl.SolidSphere(1.0)
  gl.PopMatrix()

def init():
  gl.Material(GL_FRONT, GL_AMBIENT, [0.2, 0.2, 0.2, 1.0])
  gl.Material(GL_FRONT, GL_DIFFUSE, [0.8, 0.8, 0.8, 1.0])
  gl.Material(GL_FRONT, GL_SPECULAR, [1.0, 0.0, 1.0, 1.0])
  gl.Material(GL_FRONT, GL_SHININESS, 50.0)
  gl.Light(GL_LIGHT0, GL_AMBIENT, [0.0, 1.0, 0.0, 1.0])
  gl.Light(GL_LIGHT0, GL_DIFFUSE, [1.0, 1.0, 1.0, 1.0])
  gl.Light(GL_LIGHT0, GL_SPECULAR, [1.0, 1.0, 1.0, 1.0])
  gl.Light(GL_LIGHT0, GL_POSITION, [1.0, 1.0, 1.0, 0.0]);   
  gl.LightModel(GL_LIGHT_MODEL_AMBIENT, [0.2, 0.2, 0.2, 1.0])
  gl.Enable(GL_LIGHTING)
  gl.Enable(GL_LIGHT0)
  gl.DepthFunc(GL_LESS)
  gl.Enable(GL_DEPTH_TEST)


def redraw_cone(o):
  gl.Clear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
  gl.PushMatrix()
  gl.Translate(0, -1, 0)
  gl.Rotate(250, 1, 0, 0)
  gl.SolidCone(1, 2, 50, 10)
  gl.PopMatrix()

def main():
  f = Frame()
  f.pack(side = TOP)
  o1 = Opengl(width = 200, height = 200, double = 1)
  o1.redraw = redraw_checker
  quit = Button(f, text = 'Quit', command = sys.exit)
  quit.pack(side = TOP, expand=YES, fill=BOTH)
  o1.pack(side = TOP, expand = YES, fill = BOTH)
  o1.set_eyepoint(20.)

  o2 = Opengl(width = 200, height = 200, double = 1)
  o2.redraw = redraw_cone
  o2.autospin_allowed = 1
  o2.pack(side = TOP, expand = YES, fill = BOTH)
  init()

  o1.mainloop()

main()




