#line 6 "felix_stdcat.ipk"
from interscript.felix.model.basecat import category

#line 10 "felix_stdcat.ipk"
class cat_empty(category):
  def is_arrow(self, arrow): return 0
  is_object = is_arrow

#line 16 "felix_stdcat.ipk"
class cat_all(category):
  def is_arrow(self, arrow): return 1
  is_object = is_arrow
  def can_compose(self, left, right): return 0

#line 24 "felix_stdcat.ipk"

class cat_monoid(category):
  def __init__(self, unit): self.unit = unit

  def can_compose(self, left, right): return 1

  def domain(self, arrow): return self.unit
  def codomain(self, arrow): return self.unit
  def get_unit(self): return self.unit

  def __call__(self, *args):
    return reduce(self.compose, args, self.get_unit())

  def is_object(self, object): return object == self.unit

#line 49 "felix_stdcat.ipk"
class int_add(cat_monoid):
  def __init__(self, modulus=0):
    cat_monoid.__init__(self,0)
    self.modulus = abs(modulus)

  def compose(self, left, right):
    sum = long(left) + long(right)
    if self.modulus: return sum % self.modulus
    else: return sum

  def is_arrow(self, object):
    try:
      as_long = long(object)
      return 1
    except: return 0

  def inverse(self, object):
    if self.modulus: return self.modulus - object
    else: return - object

#line 74 "felix_stdcat.ipk"
class int_mul(cat_monoid):
  def __init__(self, modulus=0):
    cat_monoid.__init__(self,1)
    self.modulus = abs(modulus)

  def compose(self, left, right):
    prod = long(left) * long(right)
    if self.modulus: return prod % self.modulus
    else: return prod

  def is_arrow(self, object):
    try:
      as_long = long(object)
      return 1
    except: return 0

#line 92 "felix_stdcat.ipk"
class cat_sequence(cat_monoid):
  def compose(self, left, right): return left + right

  def is_arrow(self, object):
    return interscript.core.protocols.has_protocol(object,'sequence')

  def is_object(self, object):
    return self.is_arrow(object) and len(object)==0

#line 103 "felix_stdcat.ipk"
class cat_tuple(cat_sequence):
  def __init__(self): cat_monoid.__init__(self,())

  def is_arrow(self, object):
    return type(object) is types.TupleType

#line 111 "felix_stdcat.ipk"
class cat_list(cat_sequence):
  def __init__(self): cat_monoid.__init__(self,[])

  def is_arrow(self, object):
    return type(object) is types.ListType

#line 119 "felix_stdcat.ipk"
class cat_string(cat_sequence):
  def __init__(self): cat_monoid.__init__(self,'')

  def is_arrow(self, object):
    return type(object) is types.StringType


