#line 104 "ms_codepages.ipk"
import string
import re
from array import array

local_file_head = 'interscript/ftp/ftp.unicode.org/public/unidata/Mappings/Vendors/Micsft/'
files =[
  ['Ebcdic_Cp037','Ebcdic'],
  ['Ebcdic_Cp1026','Ebcdic'],
  ['Ebcdic_Cp500','Ebcdic 500V3'],
  ['Ebcdic_Cp875','Ebcdic'],
  ['Mac_Cyrillic','10007'],
  ['Mac_Greek','10006'],
  ['Mac_Iceland','10079'],
  ['Mac_Latin2','10029'],
  ['Mac_Roman','10000'],
  ['Mac_Turkish','10081'],
  ['PC_Cp437','Latin US'],
  ['PC_Cp737','Greek'],
  ['PC_Cp775','Baltic Rim'],
  ['PC_Cp850','Latin 1'],
  ['PC_Cp852','Latin 2'],
  ['PC_Cp855','Cyrillic'],
  ['PC_Cp857','Turkish'],
  ['PC_Cp860','Portuguese'],
  ['PC_Cp861','Icelandic'],
  ['PC_Cp862','Hebrew'],
  ['PC_Cp863','French Canada'],
  ['PC_Cp864','Arabic'],
  ['PC_Cp865','Nordic'],
  ['PC_Cp866','Cyrillic CIS 1'],
  ['PC_Cp869','Greek 2'],
  ['PC_Cp874','Thai'],
  ['Windows_Cp1250','Central Europe'],
  ['Windows_Cp1251','Cyrillic (Slavic)'],
  ['Windows_Cp1252','Latin 1 (ANSI)'],
  ['Windows_Cp1253','Greek'],
  ['Windows_Cp1254','Latin 5 (Turkish)'],
  ['Windows_Cp1255','Hebrew'],
  ['Windows_Cp1256','Arabic'],
  ['Windows_Cp1257','Baltic Rim'],
  ['Windows_Cp1258','?'],
  ['Windows_Cp874','Thai']
  ]

tou = {}
for file, descr in files:
  tou[file] = array('H')
  filename = 'interscript/encoding/'+file+'.dat'
  f = open(filename,'rb')
  tou[file].fromfile(f,256)
  f.close()

def microsoft_to_unicode(x,ch):
  return tou[x][ch]

def microsoft_to_utf8(x,s):
  u = ''
  d = tou[x]
  for ch in s:
    u = a + utf8(d[ch])
  return u

