#line 188 "utf8.ipk"
from array import array

# encoding
def ucs2le(i):
  return chr(i & 0xFF)+ chr(i >> 8)

def seq_to_ucs2le(a):
  s = ''
  for ch in a: s = s + ucs2le(ch)
  return s

# decoding
def parse_ucs2le(s, i):
  return ord(s[i]) + ord(s[i+1]) << 8, i+2

def ucs2le_to_array(s):
  n = len(s)
  a = array('H',(0,)*n/2)
  i = 0
  while i < n:
    a[i/2],i = parse_ucs2le(s,i)

def ucs2le_to_utf8(s):
  return seq_to_utf8(ucs2le_to_array(s))

