#line 77 "johab.ipk"
from array import array

lead_first1 = 0x81
lead_last1 = 0xC6
lead_first2 = 0xC7
lead_last2 = 0xFD
trail_first1 = 0x41
trail_first2 = 0xA1
trail_last = 0xFE
width1 = trail_last - trail_first1 + 1
width2 = trail_last - trail_first2 + 1
size1 = (lead_last1 - lead_first1 + 1) * width1
size2 = (lead_last2 - lead_first1 + 1) * width2
kscsize = size1 + size2

tou = array('H')
filename = 'interscript/encoding/ksc5601-1992.dat'
f = open(filename,'rb')
tou.fromfile(f,kscsize)
f.close()

def ksc5601_1992_to_unicode(ch):
  hi = ch >> 8
  lo = ch & 0xFF
  if ch<=0x7F:
    return ch
  elif lead_first1 <= hi <= lead_last1 and trail_first1 <= lo <= trail_last:
    return tou[(hi-lead_first1)*width1+lo-trail_first1]
  elif lead_first2 <= hi <= lead_last2 and trail_first2 <= lo <= trail_last:
    return tou[(hi-lead_first2)*width2+lo-trail_first2+size1]
  else:
    return 0xFFFF

def ksc5601_1992_to_utf8(s):
  u = ''
  i = 0
  n = len(s)
  while 1:
    ch = s[i]
    i = i + 1
    ch = ch << 8 | s[i]
    u = u + utf8(ksc5601_1992_to_unicode(ch))
    i = i + 1
    if i==n: break
  return u

