#line 8 "weavers.ipk"
class weaver_base:
  __class_protocols = ['weaver']
  def __init__(self, pass_frame):
    self.enabled = 1
    self.translating = 1
    self.tags = []
    self.pass_frame = pass_frame
    self.master = pass_frame.master

    self.sequence = self.pass_frame.get_new_sequence_number()
    self.persistent_frame = self.master.get_persistent_frame(self.sequence)

  def enable(self): self.enabled = 1
  def disable(self): self.enabled = 0
  def translate(self): self.translating = 1
  def raw(self): self.translating = 0
  def add_tag(self,tag): self.tags.append(tag)
  def rawif(self,tag):
    if tag in self.tags: self.raw()
    else: self.disable()

  def writeline(self,line=''):
    self.write(line + '\n')

  def write(self,line):
    self.sink.write(line)


