#line 21 "lalr1_parser.ipk"
import sets
import stacks
set = sets.set
gstack = stacks.stack

#line 42 "lalr1_parser.ipk"
EPS = "<EPS>"
EOF = "<EOF>"

#line 67 "lalr1_parser.ipk"
class Production:
  def __init__(self, LHS, RHS, **kwds):
    self.LHS = LHS
    self.RHS = RHS
    for k in kwds.keys():
      setattr(self,k,kwds[k])

  def __len__(self):
    return len(self.RHS)

  def __repr__(self):
    d = self.__dict__.copy()
    del d['LHS']
    del d['RHS']
    return `self.LHS` + " -> " + `self.RHS`+' '+`d`

#line 154 "lalr1_parser.ipk"
class Grammar:
  DummyLA = -1

#line 159 "lalr1_parser.ipk"
  def __init__(self, prods, start,verbosity=0):
    self.verbosity = verbosity
    self.start = start
    self.productions = prods[:]

    if verbosity>1:
      for i in range(len(self.productions)):
        print i,':',self.productions[i]

    # calculate set of symbols, nonterminals, terminals
    # and non-terminals directly deriving epsilon
    self.symbols = set()
    self.nonterms = set()
    self.epslhs = set()
    self.lhsprods = {}
    for p in self.productions:
      if not self.lhsprods.has_key(p.LHS): self.lhsprods[p.LHS]=set()
      self.lhsprods[p.LHS].insert(p)
      self.nonterms.insert(p.LHS)
      if len(p.RHS)==1:
        if p.RHS[0] is EPS: self.epslhs.insert(p.LHS)
      elif len(p.RHS)==0: self.epslhs.insert(p.LHS)

      for sym in p.RHS:
        if sym != EPS: self.symbols.insert(sym)

    self.terms = self.symbols - self.nonterms

    if verbosity>1:
      print 'Symbols',self.symbols
      print 'Terminals',self.terms
      print 'NonTerminals',self.nonterms
      print 'Directly Derive epsilon',self.epslhs

    self.calc_lhsdereps()
    if verbosity>1:
      print 'Derive epsilon',self.lhsdereps

    self.calc_firstmap()
    if verbosity>1:
      print 'First Sets:'
      for nt in self.firstmap.keys():
        print nt,'->',self.firstmap[nt]

    self.calc_followmap()
    if verbosity>1:
      print 'Follow Sets:'
      for nt in self.followmap.keys():
        print nt,'->',self.followmap[nt]


#line 213 "lalr1_parser.ipk"
  def calc_lhsdereps(self):
    res = self.epslhs.copy()
    wnts = self.nonterms - res

    converged = 0
    while not converged:
      converged = 1
      for nt in wnts:
        for p in self.lhsprods[nt]:
          p_nullable = 1
          for sym in p.RHS:
            if not res.contains(sym):
              p_nullable = 0
              break
          if p_nullable:
            res.insert(nt)
            wnts = wnts.remove(nt)
            converged = 0
            break
        if not converged: break
    self.lhsdereps = res


#line 240 "lalr1_parser.ipk"
  def calc_firstmap(self):
      res = {}
      for sym in self.terms + [EPS, EOF, Grammar.DummyLA]:
          res[sym] = set(sym)
      while 1:
          added = 0
          for nt in self.nonterms:
              firsts = res.get(nt, set())
              for p in self.lhsprods[nt]:
                  if not p.RHS:
                      if not firsts.contains(EPS):
                          added = 1
                          firsts.insert(EPS)
                      continue
                  i = 0
                  while i < len(p.RHS):
                      f = res.get(p.RHS[i], set())
                      for t in f:
                          if not firsts.contains(t):
                              added = 1
                              firsts.insert(t)
                      if self.lhsdereps.contains(p.RHS[i]):
                          i = i + 1
                      else: break
              res[nt] = firsts
          if not added:
              break
      self.firstmap = res


  #
  # these function are used as the grammar produces the tables (or writes them
  # to a file)
  #
  def firstofstring(self, gs_list):
    tmpres = {}
    allhaveeps = 1
    for x in range(len(gs_list)):
      tmp = self.firstmap[gs_list[x]]
      for s in tmp: tmpres[s] = 1
      if EPS in tmp: del tmpres[EPS]
      else:
          allhaveeps = 0
          break
    if allhaveeps: tmpres[EPS] = 1
    return tmpres.keys()


#line 292 "lalr1_parser.ipk"
  def augment(self):
    lhss = map(lambda x: x.LHS, self.productions)
    newsym = self.start
    while newsym in lhss: newsym = newsym + "'"
    self.productions.insert(0, Production(newsym, [self.start]))

  def unaugment(self):
    del self.productions[0]

#line 304 "lalr1_parser.ipk"
  def calc_followmap(self):
      eof = EOF
      follow = {}
      startsym = self.productions[0].LHS
      follow[startsym] = set(eof)
      nts = self.nonterms
      for p in self.productions:
          cutoff = range(len(p.RHS))
          cutoff.reverse()
          for c in cutoff[:-1]:  # all but the first of the RHS elements
              f = self.firstmap[p.RHS[c]].copy()
              f.excise(EPS)
              if follow.has_key(p.RHS[c - 1]):
                  if p.RHS[c -1] in nts:
                      follow[p.RHS[c -1]] = follow[p.RHS[c - 1]] + f[:]
              else:
                  if p.RHS[c -1] in nts:
                      follow[p.RHS[c - 1]] = f[:]
      for p in self.productions:
          if not p.RHS: continue
          cutoff = range(len(p.RHS))
          cutoff.reverse()
          if p.RHS[-1] in nts:
              if follow.has_key(p.LHS):
                  add = follow[p.LHS]
              else:
                  add = []

              if follow.has_key(p.RHS[-1]):
                  follow[p.RHS[-1]] = follow[p.RHS[-1]] + add
              else:
                  follow[p.RHS[-1]] = add
          for c in cutoff[:-1]:
              f = self.firstmap[p.RHS[c]].copy()
              if EPS in f:
                  if follow.has_key(p.LHS):
                      add = follow[p.LHS]
                  else:
                      add = set()
                  if follow.has_key(p.RHS[c-1]):
                      follow[p.RHS[c-1]] = follow[p.RHS[c-1]] + add
                  elif add:
                      follow[p.RHS[c - 1]] = add
      for k in follow.keys():
          d = set()
          for i in follow[k]: d.insert(i)
          follow[k] = d
      self.followmap = follow

#line 360 "lalr1_parser.ipk"
  def closure(self, items):
      res = items[:]
      todo = items[:]
      while 1:
          more = []
          for (prodind, rhsind), term in todo:
              if rhsind >= len(self.productions[prodind].RHS):
                  continue
              for p in self.lhsprods.get(self.productions[prodind].RHS[rhsind], []):
                  try:
                      newpart = self.productions[prodind].RHS[rhsind + 1]
                  except IndexError:
                      newpart = EPS
                  stringofsyms = [newpart, term]
                  for t in self.firstofstring(stringofsyms):
                      if ((self.productions.index(p), 0), t) not in res:
                          more.append(((self.productions.index(p), 0), t))
                  if term == EOF and newpart == EPS:
                      if ((self.productions.index(p), 0), EOF) not in res:
                          more.append(((self.productions.index(p), 0), EOF))
          if more:
              res = res + more
              todo = more
          else:
              break
      return res


#  def goto(self, items, sym):
#      itemset = []
#      for (prodind, rhsind), term in items:
#          try:
#              if self.productions[prodind].RHS[rhsind] == sym and ((prodind, rhsind+1), term) not in itemset:
#                  itemset.append( ((prodind, rhsind +1), term))
#          except IndexError:
#              pass
#      return self.closure(itemset)

#line 401 "lalr1_parser.ipk"
class LALRGrammar(Grammar):

  def __init__(self, prods, start, verbosity=0):
    Grammar.__init__(self, prods, start, verbosity)
    self.calc_ntfirstmap()
    self.calc_tfirstmap()
    self.augment()
    self.calc_LALR1items()
    self.calc_action_table()
    self.calc_goto_table()
    self.unaugment()

#line 422 "lalr1_parser.ipk"
  def calc_ntfirstmap(self):
    res = {}
    for p in self.productions:
      if p.RHS and p.RHS[0] in self.nonterms:
        fos = self.firstofstring(p.RHS[1:])
        fos.sort()
        if not res.has_key(p.LHS):
          res[p.LHS] = {}
        if not res[p.LHS].has_key(p.RHS[0]):
          res[p.LHS][p.RHS[0]] = []
        for i in fos:
          if i not in res[p.LHS].get(p.RHS[0], []):
            res[p.LHS][p.RHS[0]] = fos

    while 1:
      foundmore = 0
      reskeys = res.keys()
      for nt in reskeys:
        rhsdict = res[nt]
        for rnt in rhsdict.keys():
          if rnt in reskeys:
            d = res[rnt]
            for k in d.keys():
              if not res[nt].has_key(k):
                fos = self.firstofstring(d[k]+ res[nt][rnt])
                foundmore = 1
                fos.sort()
                res[nt][k] = fos
              else:
                fos = self.firstofstring(d[k] + res[nt][rnt])
                fos.sort()
                if fos != res[nt][k]:  # then res[nt][k] is contained in fos
                  foundmore = 1
                  res[nt][k] = fos
      if not foundmore: break
    #
    # this part accounts for the fact that a nonterminal will
    # produce exactly itself in zero steps
    #
    for p in self.productions:
      if res.has_key(p.LHS):
        res[p.LHS][p.LHS] = [EPS]
      else:
        res[p.LHS] = {p.LHS: [EPS]}
    self.ntfirstmap = res

#line 473 "lalr1_parser.ipk"
  def newmkntfirstmap(self):
    res = {}
    pi = 0
    for p in self.productions:
      if p.RHS and p.RHS[0] in self.nonterms:
        if not res.has_key(p.LHS):
          res[p.LHS] = {}
        if not res[p.LHS].has_key(p.RHS[0]):
          res[p.LHS][p.RHS[0]] = 1

    while 1:
      foundmore = 0
      reskeys = res.keys()
      for nt in reskeys:
        rhsdict = res[nt]
        for rnt in rhsdict.keys():
          if rnt in reskeys:
            d = res[rnt]
            for k in d.keys():
              if not res[nt].has_key(k):
                foundmore = 1
                res[nt][k] = 1
      if not foundmore:
        break
    #
    # this part accounts for the fact that a nonterminal will
    # produce exactly itself in zero steps
    #
    for p in self.productions:
      if res.has_key(p.LHS):
        res[p.LHS][p.LHS] = 1
      else:
        res[p.LHS] = {p.LHS: 1}
    self.ntfirstmap = res

#line 517 "lalr1_parser.ipk"
  def calc_tfirstmap(self):
    res = {}
    for p in self.productions:
      if not res.has_key(p.LHS):
        res[p.LHS] = []
      if p.RHS and p.RHS[0] in self.terms:
        res[p.LHS].append(p.RHS[0])
    while 1:
      foundmore = 0
      reskeys = res.keys()
      for nt in self.ntfirstmap.keys():
        arrows = self.ntfirstmap[nt]
        for k in arrows.keys():
          for t in res[k]:
            if t not in res[nt]:
              foundmore = 1
              res[nt].append(t)
      if not foundmore: break
    self.tfirstmap = res


#line 540 "lalr1_parser.ipk"
  def goto(self, itemset, sym):
    res = []
    for (pi, ri) in itemset:
      if ri == len(self.productions[pi].RHS):
        continue
      s = self.productions[pi].RHS[ri]
      if s == sym:
        res.append((pi, ri+1))
      d = self.ntfirstmap.get(s, {})
      for k in d.keys():
        for p in self.lhsprods[k]:
          if p.RHS and p.RHS[0] == sym:
            i = self.productions.index(p)
            if (i, 1) not in res: res.append((i, 1))
    res.sort()
    return res

#line 559 "lalr1_parser.ipk"
  def lookaheads(self, itemset):
    setsofitems = kernels = self.kernelitems
    spontaneous = []
    propagates = {}
    gotomap = {}
    for (kpi, kri) in itemset:
      C = self.closure([((kpi, kri), Grammar.DummyLA)])
      for (cpi, cri), t in C:
        if (cri) == len(self.productions[cpi].RHS):
          continue
        s = self.productions[cpi].RHS[cri]
        if gotomap.has_key(s):
          newstate = gotomap[s]
        else:
          newstate = setsofitems.index(self.goto(itemset, s))
          gotomap[s] = newstate
        if t != Grammar.DummyLA:
          spontaneous.append((newstate, (cpi, cri+1), t))
        else:
          if propagates.has_key((kpi, kri)):
            propagates[(kpi, kri)].append((newstate, (cpi, cri+1)))
          else:
            propagates[(kpi, kri)]=[(newstate, (cpi, cri+1))]
    return spontaneous, propagates


#line 587 "lalr1_parser.ipk"
  def kernelsoflalr1items(self):
    res = [[(0, 0)]]
    todo = [[(0, 0)]]
    while 1:
      newtodo = []
      for items in todo:
        for s in self.terms + self.nonterms + [EOF]:
          g = self.goto(items, s)
          if g and g not in res:
            newtodo.append(g)
      if not newtodo:
        break
      else:
        if self.verbosity>1:
          print "found %d more kernels" % (len(newtodo))
        res = res + newtodo
        todo = newtodo
    res.sort()
    return res


#line 610 "lalr1_parser.ipk"
  def initLALR1items(self):
      self.kernelitems = kernels = self.kernelsoflalr1items()
      props = {}
      la_table = []
      for x in range(len(kernels)):
          la_table.append([])
          for y in range(len(kernels[x])):
              la_table[x].append([])
      la_table[0][0] = [EOF]
      if self.verbosity>1:
          print "initLALR1items, kernels done, calculating propagations and spontaneous lookaheads"
      state_i = 0
      for itemset in kernels:
          if self.verbosity>1:
              print ".",
          sp, pr = self.lookaheads(itemset)
          for ns, (pi, ri), t in sp:
              inner = kernels[ns].index((pi, ri))
              la_table[ns][inner].append(t)
          props[state_i] = pr
          state_i = state_i + 1
      return la_table, props


  def calc_LALR1items(self):
      la_table, props = self.initLALR1items()
      if self.verbosity>1:
          print "done init LALR1items"
      soi = self.kernelitems
      while 1:
          added_la = 0
          state_i = 0
          for state in la_table:
              ii = 0
              for propterms in state:
                  if not propterms:
                      ii = ii + 1
                      continue
                  item = soi[state_i][ii]
                  ii = ii + 1
                  try:
                      proplist = props[state_i][item]
                  except KeyError:
                      continue
                  for pstate, pitem in proplist:
                      inner = soi[pstate].index(pitem)
                      for pt in propterms:
                          if pt not in la_table[pstate][inner]:
                              added_la = 1
                              la_table[pstate][inner].append(pt)
              state_i = state_i + 1
          if not added_la:
              break
      #
      # this section just reorganizes the above data
      # to the state it's used in later...
      #
      if self.verbosity>1:
          print "done with lalr1items, reorganizing the data"
      res = []
      state_i = 0
      for state in soi:
          item_i = 0
          inner = []
          for item in state:
              for term in la_table[state_i][item_i]:
                  if (item, term) not in inner:
                      inner.append((item, term))
              item_i = item_i + 1
          inner.sort() # keeps productions in order!
          res.append(inner)
          state_i = state_i + 1
      self.LALRitems = res

#line 686 "lalr1_parser.ipk"
  def pr_conflict(self,state,sym,rej,acc):
    if rej[0]=='r' and acc[0]=='s':
      print "Shift/Reduce Conflict, Use Shift [%d,%s]:" % (state, repr(sym)), rej, "->", acc
    elif rej[0]=='s' and acc[0]=='r':
      print "WARNING! Shift/Reduce Conflict, Use Reduce [%d,%s]:" % (state, repr(sym)), rej, "->", acc
    elif rej[0]=='s' and acc[0]=='s':
      print "WARNING! Shift/Shift Conflict[%d,%s]:" % (state, repr(sym)), rej, "->", acc
    elif rej[0]=='r' and acc[0]=='r':
      print "WARNING! Reduce/Reduce Conflict[%d,%s]:" % (state, repr(sym)), rej, "->", acc
    else:
      print "WARNING! WEIRD Conflict[%d,%s]:" % (state, repr(sym)), rej, "->", acc

  def resolve(self,at,sym,new,state_i):
    old = at.get(sym)
    # new entry
    if not old:
      at[sym] = new
      return

    # same entry
    if old == new: return

    # resolve shift/reduce conflict in favour of shift
    if old[0]=='s' and new[0] =='r':
      self.pr_conflict(state_i,sym,new,old)
      return
    if old[0]=='r' and new[0] =='s':
      self.pr_conflict(state_i,sym,old,new)
      at[sym] = new
      return

    if old[0]=='r' and new[0]=='r':
      oldp = self.productions[old[1]]
      newp = self.productions[new[1]]
      oldpri = None
      newpri = None
      if hasattr(oldp,'priority'): oldpri = oldp.priority
      if hasattr(newp,'priority'): newpri = newp.priority
      if oldpri > newpri: return
      elif newpri > oldpri:
        at[sym]=new
        return

      # resolve reduce/reduce conflict in favour of earlier production
      if old[1] > new[1]:
        at[sym]=new
        self.pr_conflict(state_i,sym,old,new)
      else:
        self.pr_conflict(state_i,sym,new,old)
      return

    self.pr_conflict(state_i,sym,old,new)
    at[sym] = new

  def calc_action_table(self):
    items = self.LALRitems
    res = []
    state_i = 0
    terms = self.terms.list()
    terms.append(EOF)
    for state in items:
      at = {}
      res.append(at)
      for (prodind, rhsind), term in state:
        if (rhsind ) == len(self.productions[prodind].RHS):
            if prodind != 0: new = ("r", prodind)
            else: new = ("a", None)
            self.resolve(at,term,new,state_i)
        # calculate reduction by epsilon productions
        #
        elif self.productions[prodind].RHS[rhsind] in self.nonterms:
          nt = self.productions[prodind].RHS[rhsind]
          ntfirst = self.firstmap[nt]
          ntfirsts = self.ntfirstmap.get(nt, {})
          for k in ntfirsts.keys():
            if self.epslhs.contains(k):
              reduceterms = self.followmap[k]
              print `((prodind, rhsind), term)`, reduceterms
              for r in reduceterms:
                new = ("r", self.epslhs[k])
                self.resolve(at,r,new,state_i)
          #
          # calculate the shifts that occur but whose normal items aren't in the kernel
          #
          tfirsts = self.tfirstmap[nt]
          for t in tfirsts:
            g = self.goto(self.kernelitems[state_i], t)
            try:
              news = self.kernelitems.index(g)
            except ValueError:
              continue
            new = ("s", news)
            self.resolve(at,t,new,state_i)
        #
        # compute the rest of the shifts that occur 'normally' in the kernel
        #
        else:
          t = self.productions[prodind].RHS[rhsind]
          gt = self.goto(self.kernelitems[state_i], t)
          if gt in self.kernelitems:
            news = self.kernelitems.index(gt)
            new = ("s", news)
            self.resolve(at,t,new,state_i)
      state_i = state_i + 1
    self.action_table = res

#line 794 "lalr1_parser.ipk"
  def calc_goto_table(self):
      items = self.kernelitems
      res = []
      nonterms = self.nonterms.list()
      for state in items:
        gt = {}
        for nt in nonterms:
          goto = self.goto(state, nt)
          if goto in items: gt[nt] = items.index(goto)
        res.append(gt)
      self.goto_table = res


#line 814 "lalr1_parser.ipk"
  def parse(self, data, reduce='func'):
    act = self.action_table
    go = self.goto_table
    stack = gstack()

    stack.push(0)
    n = len(data)
    ip = 0

    while 1:
      s = stack.top
      if ip < len(data): token = data[ip]
      else: token = (EOF,None)
      a = token[0]
      action = act[s][a]
      #print 'Symbol',a,'Value',token[1],'State',s,'Action',action
      if action[0]=='s':
        s = action[1]
        ip = ip + 1
        stack.push(token)
        stack.push(s)
      elif action[0]=='r':
        prodn = action[1]-1
        prod = self.productions[prodn]
        nt = prod.LHS
        #print 'Reduce ',nt,'-->',
        #for sym in prod.RHS: print sym,
        #print
        n = len(prod.RHS)
        vals = []
        while n:
          stack.pop()
          vals.insert(0,stack.pop())
          n = n -1
        vals.insert(0,prod)
        args = tuple(vals)
        #print 'args=',args
        res = None
        if hasattr(prod,reduce):
          if callable(getattr(prod,reduce)):
            res = apply(getattr(prod,reduce),args)
        s = stack.top
        stack.push((nt,res))
        stack.push(go[s][nt])
      elif act[s][a][0]=='a':
        stack.pop()
        res = stack.pop()
        stack.pop()
        assert not stack.s
        print 'Accept'
        return res
      else:
        raise 'Parse Error'

#line 921 "lalr1_parser.ipk"

def pr_tab(p):
  at = p.action_table
  gt = p.goto_table
  print 'actions'
  for i in range(len(at)):
    print i,':',at[i]
  print 'gotos'
  for i in range(len(gt)):
    print i,':',gt[i]

def _test1():
    # the token interface will be defined in
    # a wrapper module and in the lexer.
    # this is the format the information will be stored in
    #
    # first, define the tokens
    #
    #(id, plus, times, lparen, rparen, eof) = range(6)
    #
    # then, define how you want them to appear
    # in the documentation of the output file
    #
    toks = ["id", "+", "*", "(", ")","$"]
    (id, plus, times, lparen, rparen, eof) = toks

    #
    # define the productions (LHS=left hand side, RHS=right hand side)
    #
    prods = map(lambda x: Production(x[0], x[1]), [("E", ["E", plus, "T"]),
                                                   ("E", ["T"]),
                                                   ("T", ["T", times, "F"]),
                                                   ("T", ["F"]),
                                                   ("F", [lparen, "E", rparen]),
                                                   ("F", [id])])
    g = LALRGrammar(prods, "E")
    #

    #
    # define functions for the parser to use
    #
    def fadd(prod,*args):
        print "adding %d with %d" % (args[0][1], args[2][1])
        return args[0][1] + args[2][1]

    def fdummy(prod,*args):
        print "calling fdummy with args %s" % `args`
        return args[0][1]

    def ftimes(prod,*args):
        print "multiplying %d with %d" % (args[0][1], args[2][1])
        return args[0][1] * args[2][1]

    def fparens(prod,*args):
        print "handling parens, returning whats in between"
        return args[1][1]


    #
    # register the functions
    #
    for i in range(len(g.productions)):
        if len(g.productions[i].RHS) == 1:
            g.productions[i].func=fdummy
    g.productions[0].func=fadd
    g.productions[2].func=ftimes
    g.productions[4].func=fparens
    #
    # produce the parser
    #
    pr_tab(g)

    #
    # this is the input as would be returned by the Lexer
    # (3+(4*2))*2*5 =110
    input = [(lparen, "("), (id, 3), (plus, "+"),
             (lparen, "("), (id, 4), (times, "*"), (id, 2),  (rparen, ")"),
             (rparen, ")"), (times, "*"),
             (id, 2), (times, "*"), (id, 5) ]

    res = g.parse(input)
    print 'RESULT=',res

#line 1032 "lalr1_parser.ipk"

import string
def tokenise(s):
  i = 0
  s = s + '\0'
  toks = []
  while 1:
    while s[i] == ' ': i = i + 1
    if s[i] in '#\0': return toks
    lexeme = ''
    if s[i] in string.letters+'_':
      while s[i] in string.letters+'_'+string.digits:
        lexeme = lexeme+s[i]
        i = i + 1
      toks.append(('NAME',lexeme))
      continue
    if s[i] == '"':
      i = i + 1
      while s[i] not in '"\0':
        lexeme = lexeme + s[i]
        i = i + 1
      toks.append(('STRING',lexeme))
      if s[i]=='\0': return toks
      i = i + 1
      continue
    if s[i] == "'":
      i = i + 1
      while s[i] not in "'\0":
        lexeme = lexeme + s[i]
        i = i + 1
      toks.append(('STRING',lexeme))
      if s[i]=='\0': return toks
      i = i + 1
      continue
    if s[i] in '{}=':
      toks.append((s[i],s[i]))
      i = i + 1
      continue
    if s[i] in '#\n':
      toks.append(('NEWLINE','\n'))
      i = i + 1
      continue
    if s[i]=='\\':
      i = i + 1
      if s[i] == '\0': return toks
      toks.append(('STRING',s[i]))
      i = i + 1
      continue
    toks.append(('STRING',s[i]))
    i = i + 1
    continue

#line 1086 "lalr1_parser.ipk"
def _test2():
    def dummy(prod,*args):
      print 'dummy:reduce',prod,'args=',args
      return None

    def new_production_list(prod, *args):
      return [args[0][1]]

    def add_production_to_list(prod, *args):
      return args[0][1]+[args[1][1]]

    def build_production(prod, *args):
      return Production(args[0][1],args[2][1],func=args[4][1])

    def new_symbol_list(prod, *args):
      return [args[0][1]]

    def add_symbol_to_list(prod, *args):
      return args[0][1]+[args[1][1]]

    def name_as_symbol(prod, *args):
      return args[0][1]

    def string_as_symbol(prod, *args):
      return args[0][1]

    def just_copy(prod, *args):
      return args[0][1]

    bootgram = [
      ('G',    ['Plist'], just_copy),
      ('Plist', ['Plist','P'], add_production_to_list),
      ('Plist', ['P'], new_production_list),
      ('P', ['NAME','=','RHS','{','NAME','}','NEWLINE'],build_production),
      ('RHS',['RHS','SYM'],add_symbol_to_list),
      ('RHS',['SYM'],new_symbol_list),
      ('SYM',['NAME'],name_as_symbol),
      ('SYM',['STRING'],string_as_symbol)
    ]
    print 'bootgram=',bootgram
    prods = map(lambda x: Production(x[0], x[1], func=x[2]), bootgram)

    g = LALRGrammar(prods, "G", verbosity=1)
    pr_tab(g)

    print
    print '---------------------------------------------------'
    print '  TABLES FOR MANUALLY CONSTRUCTED GRAMMAR GENERATED'
    print '---------------------------------------------------'
    print

    input = """G       = Plist { just_copy }
Plist   = Plist P { add_production_to_list }
Plist   = P { new_production_list }
P       = NAME \= RHS \{ NAME \} NEWLINE { build_production }
RHS     = RHS SYM { add_symbol_to_list }
RHS     = SYM { new_symbol_list }
SYM     = NAME { name_as_symbol }
SYM     = STRING { string_as_symbol }
"""
    tokens = tokenise(input)
    print 'tokens=',tokens
    for t in tokens: print t[1],
    print

    res = g.parse(tokens)
    prods = res[1]
    print 'RESULT=',prods

    for p in prods: p.func = eval(p.func)
    print 'BOUND=',prods

    g = LALRGrammar(prods, "G", verbosity=2)
    pr_tab(g)

    print
    print '--------------------------------------------------------'
    print '  TABLES FOR AUTOMATICALLY CONSTRUCTED GRAMMAR GENERATED'
    print '--------------------------------------------------------'
    print

    res = g.parse(tokens)
    prods = res[1]
    print 'RESULT=',prods

    print '--------------------------------------------------------'
    print ' IF THAT WORKED, WE HAVE A BOOTSTRAP                    '
    print '--------------------------------------------------------'

    input = """G = S {dummy}
S = if E then S else S {dummy}
S = if E then S {dummy}
S = X {dummy}
E = X {dummy}
"""
    tokens = tokenise(input)
    res = g.parse(tokens)
    prods = res[1]
    print 'RESULT=',prods

    for p in prods: p.func = eval(p.func)
    print 'BOUND=',prods

    ifthenelse = LALRGrammar(prods, "G", verbosity=2)
    pr_tab(ifthenelse)
    input = """if X then X else X"""
    tokens = tokenise(input)
    toks = []
    for tok in tokens[:]:
      toks.append((tok[1],tok[1]))
    print toks
    res = ifthenelse.parse(toks)
    prods = res[1]
    print 'RESULT=',prods


