#line 20 "interscript_options.ipk"
import sys
import traceback
import string
import glob
import os

from interscript.getoptions import getopt

#line 30 "interscript_options.ipk"
#option help dictionary
shortoptdict = { 'v':'verbose (verbosity=6)' }

longoptdict = {
  'echo_input=':{0:"Don't echo input (default)",1:'Echo input'},
  'verbosity=': {
    0:'no messages', # none _at all_, not even serious errors
    1:'fatal messages', # _only_ serious errors
    2:'warnings',       # all errors
    3:'brief progress', # open and close weavers, tanglers, files
    4:'progress and information', # headings, 'watch it run'
    5:'full progress and information', # full user information
    6:'user source debugging', # full debugging of _user_ script
    7:'interscript debugging', # basic control flow debugging
    8:'full interscript debugging', # enough to debug interscript itself
    9:'eveything' # for unintelligible output :-)
  },
  'weaver=': {
    'html': 'flat html',
    'latex': 'latex2e',
    'text':'plain text',
    'web':'html tree',
  },
  'tangler-prefix=':'absolute native os prefix prepended to tangled code filenames',
  'weaver-prefix=':'absolute native os prefix prepended to woven documentation filenames',
  'tangler-directory=':'interscript filename prefix prepended to tangled code filenames',
  'weaver-directory=':'interscript filename prefix prepended to woven documentation filenames',
  'source-prefix=':'absolute native prefix prepended to input filename',
  'python=':'execute python script',
  'update=':{
    0:'Allow buffered file write (default)',
    1:'Inhibit buffered file write'},
  'download=':{
    0:'only download by ftp or http when necessary',
    1:'force download by ftp or http'},
  'refresh_interval=':
    'download when local file is older than this number of days (default 28)',
  'tabwidth=':'column width for tab expansion (default 8)',
  'passes=':'passs on each file (default 1)',
  'logfile=':'<filename> for messages (append to old file)',
  'new-logfile=':'<filename> for messages (cleared first)',
  'nocache':'disable persistent cache usage',
  'copyright': '(prints) Maxtal P/L Australia',
  'licence': '(prints) Free for any use',
  'author': '(prints) mailto:skaller@maxtal.com.au <John Skaller>',
  'homepage': '(prints) http://www.triode.net.au/~skaller/interscript',
  'executable': 'print python executable name',
  'python-version': 'print python version string',
  'title=':'set document title',
  'html-eol=': {
    'CRLF': 'Kludge Unix host (only) to end html lines (only) with CR/LF'
  },
  'help':'this help',
  'usage':'this help' }


def print_help():
  print 'Usage: python iscr.py [options] <filename>'
  print 'Short options:'
  keys = shortoptdict.keys()
  keys.sort()
  for k in keys: print_help1(k)
  print 'Long options:'
  keys = longoptdict.keys()
  keys.sort()
  for k in keys: print_help1(k)

def print_help1(k):
  if longoptdict.has_key(k):
    usek = '--'+ k
    values = longoptdict[k]
  elif longoptdict.has_key(k+'='):
    usek = '--'+ k + '='
    values = longoptdict[k+'=']
  elif shortoptdict.has_key(k):
    usek = '-' + k
    values = shortoptdict[k]
  elif shortoptdict.has_key(k+'='):
    usek = '-' + k + '='
    values = shortoptdict[k+'=']
  else:
    usek = k
    values = 'Unknown option'

  print '  '+usek,
  if values is None:
    print
  elif type(values) is type({}):
    print
    for value in values.keys():
      print '   '+str(value)+':',values[value]
  else:
    print values

#line 127 "interscript_options.ipk"
class argument_frame:
  def copy(self):
     other = argument_frame()
     other.__dict__ = self.__dict__.copy()
     return other

def getoption_frames(args): # note: has side effects!
  parsed =  getopt(args)
  process_options = argument_frame()
  process_options.verbosity = 2
  process_options.logfile = None
  process_options.logfile_mode = None
  process_options.args = args
  master_frames = []

  frame = argument_frame()
  frame.echo_input = 0
  frame.update_files = 1
  frame.tabwidth = 8
  frame.verbosity = 2
  frame.download = 'regularly'
  frame.refresh_interval = 28
  frame.usecache = 1
  frame.passes = 1
  frame.weaver_prefix = ''
  frame.tangler_prefix = ''
  frame.weaver_directory= ''
  frame.tangler_directory = ''
  frame.autoweave = []
  frame.useropt = {}
  frame.html_eol = '\n'
  frame.title = 'Anonymous Interscript Document'
  for opts,filename in parsed:
    for opt,value in opts:
      try:
        if opt == 'verbosity': process_options.verbosity = frame.verbosity = int(value)
        elif opt == 'echo_input': frame.echo_input = int(value)
        elif opt == 'v': process_options.verbosity = frame.verbosity = 6
        elif opt == 'noupdate': frame.update_files = 0
        elif opt == 'nocache': frame.usecache = 0
        elif opt == 'nodownload': frame.download = 'never'
        elif opt == 'download': frame.download = 'always'
        elif opt == 'tabwidth': frame.tabwidth = int(value)
        elif opt == 'passes': frame.passes = int(value)
        elif opt == 'weaver': frame.autoweave.append(value)
        elif opt == 'weaver-prefix': frame.weaver_prefix = value
        elif opt == 'title': frame.title = value
        elif opt == 'tangler-prefix': frame.tangler_prefix = value
        elif opt == 'weaver-directory': frame.weaver_directory = value
        elif opt == 'html-eol':
          if sys.platform == 'Win32':
            print 'CRLF kludge ignored for Win32'
            print 'Use on Unix only, to make html files in DOS format'
          else:
            frame.html_eol = '\r\n'
        elif opt == 'tangler-directory': frame.tangler_directory = value
        elif opt == 'homepage':
          print 'http://www.triode.net.au/~skaller/interscript'
        elif opt == 'author':
          print 'mailto:skaller@maxtal.com.au <John Skaller>'
        elif opt == 'copyright':
          print 'Copyright (C)1998 Maxtal P/L Australia'
        elif opt == 'licence':
          print 'Free for any use'
        elif opt == 'executable':
          print sys.executable
        elif opt == 'python-version':
          print sys.version
        elif opt == 'python':
          try:
            if process_options.verbosity>=3:
              print 'Executing python:'
              print value
            exec value
          except:
            print 'Error in python option'
            traceback.print_exc()
        elif opt == 'logfile':
          process_options.logfile = value
          process_options.logfile_mode = 'a'
        elif opt == 'new-logfile':
          process_options.logfile = value
          process_options.logfile_mode = 'w'
        elif opt in ['help', 'usage']:
          print_help()
          print
        else:
          # FIX: all options should be OK (user options?)
          print 'Nonstandard option',opt,'value',value,'accepted as user option'
          frame.useropt[opt]=value
        if process_options.verbosity>=4: print 'Option:',opt,value
      except:
        print 'Warning: Option',opt,'has bad value',value
        prefix = ''
        while opt[0]=='-': prefix = prefix + '-'; opt=opt[1:]
        print_help1(opt)

    files = glob.glob( filename)
    for file in files:
      frame.source_prefix, frame.filename = os.path.split(file)
      master_frames.append(frame.copy())
  return process_options, master_frames


